/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.commitments;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.kuali.kra.award.commitments.AwardCostShare;
import org.kuali.kra.award.commitments.AwardCostShareRuleEvent;
import org.kuali.kra.award.commitments.AwardCostShareRuleImpl;
import org.kuali.kra.award.document.AwardDocument;
import org.kuali.kra.costshare.CostShareService;
import org.kuali.kra.costshare.CostShareServiceTest;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.test.infrastructure.KcUnitTestBase;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.MessageMap;

public class AwardCostShareRuleTest
extends KcUnitTestBase {
    private static final String TEST_SOURCE = "54321";
    private static final String TEST_DESTINATION = "12345";
    private static final String TEST_FISCAL_YEAR = "2008";
    private static final String TEST_INVALID_FISCAL_YEAR = "1000";
    private static final Integer PERCENTAGE = 50;
    private static final Integer COMMITMENT_AMOUNT = 10000;
    AwardCostShareRuleImpl awardCostShareRule;
    AwardCostShare awardCostShare;
    AwardDocument awardDocument;
    AwardCostShareRuleEvent awardCostShareRuleEvent;

    @Override
    @Before
    public void setUp() throws Exception {
        this.awardCostShareRule = new AwardCostShareRuleImpl();
        this.awardCostShare = new AwardCostShare();
        this.awardCostShare.setCostSharePercentage(new KualiDecimal(PERCENTAGE.intValue()));
        this.awardCostShare.setProjectPeriod(TEST_FISCAL_YEAR);
        this.awardCostShare.setDestination(TEST_DESTINATION);
        this.awardCostShare.setSource(TEST_SOURCE);
        this.awardCostShare.setCommitmentAmount(new KualiDecimal(COMMITMENT_AMOUNT.intValue()));
        GlobalVariables.setMessageMap((MessageMap)new MessageMap());
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.awardCostShareRule = null;
        this.awardCostShare = null;
    }

    @Test
    public final void testProcessCommonValidations() {
        Assert.assertTrue((boolean)this.awardCostShareRule.processCommonValidations(this.awardCostShare));
    }

    @Test
    public final void testValidateCostShareSourceAndDestinationForEquality() {
        Assert.assertTrue((boolean)this.awardCostShareRule.validateCostShareSourceAndDestinationForEquality(this.awardCostShare));
        this.awardCostShare.setSource(TEST_DESTINATION);
        Assert.assertFalse((boolean)this.awardCostShareRule.validateCostShareSourceAndDestinationForEquality(this.awardCostShare));
        this.awardCostShare.setSource(TEST_SOURCE);
    }

    @Ignore
    @Test
    public final void testValidateCostShareFiscalYearRange() {
        this.updateParameterForTesting(CostShareServiceTest.class, "CostShareProjectPeriodNameLabel", "Fiscal Year");
        CostShareService costShareService = (CostShareService)KraServiceLocator.getService(CostShareService.class);
        costShareService.getCostShareLabel();
        this.awardCostShareRule.setCostShareService(costShareService);
        Assert.assertTrue((boolean)this.awardCostShareRule.validateCostShareFiscalYearRange(this.awardCostShare));
        this.awardCostShare.setProjectPeriod(TEST_INVALID_FISCAL_YEAR);
        Assert.assertFalse((boolean)this.awardCostShareRule.validateCostShareFiscalYearRange(this.awardCostShare));
        this.awardCostShare.setSource(TEST_FISCAL_YEAR);
    }
}

