/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.commitments;

import java.sql.Date;
import java.util.HashMap;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.award.commitments.AwardFandARateAuditRule;
import org.kuali.kra.award.commitments.AwardFandaRate;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.lookup.keyvalue.ExtendedPersistableBusinessObjectValuesFinder;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kns.util.KNSGlobalVariables;
import org.kuali.rice.krad.keyvalues.KeyValuesFinder;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.MessageMap;

public class AwardFandARateAuditRuleTest {
    private AwardFandARateAuditRule rule;
    AwardFandaRate awardFandaRate1;
    AwardFandaRate awardFandaRate2;
    private Award award;

    @Before
    public void setUp() throws Exception {
        KNSGlobalVariables.setAuditErrorMap(new HashMap());
        this.rule = new AwardFandARateAuditRule();
        this.rule.setFinder((KeyValuesFinder)new ExtendedPersistableBusinessObjectValuesFinder(){

            public String getKeyLabel(String key) {
                return key.equals("5") ? "A" : "B";
            }
        });
        this.award = new Award();
        this.awardFandaRate1 = new AwardFandaRate();
        this.awardFandaRate1.setApplicableFandaRate(new KualiDecimal(5));
        this.awardFandaRate1.setFiscalYear("2008");
        this.awardFandaRate1.setFandaRateTypeCode("5");
        this.awardFandaRate1.setOnCampusFlag("N");
        this.awardFandaRate1.setUnderrecoveryOfIndirectCost(new KualiDecimal(1000));
        this.awardFandaRate1.setStartDate(new Date(new Long("1183316613046")));
        this.awardFandaRate1.setEndDate(new Date(new Long("1214852613046")));
        this.awardFandaRate2 = new AwardFandaRate();
        this.awardFandaRate2.setApplicableFandaRate(new KualiDecimal(5));
        this.awardFandaRate2.setFiscalYear("2008");
        this.awardFandaRate2.setFandaRateTypeCode("5");
        this.awardFandaRate2.setOnCampusFlag("F");
        this.awardFandaRate2.setUnderrecoveryOfIndirectCost(new KualiDecimal(1000));
        this.awardFandaRate2.setStartDate(new Date(new Long("1183316613046")));
        this.awardFandaRate2.setEndDate(new Date(new Long("1214852613046")));
        this.award.add(this.awardFandaRate1);
        this.award.add(this.awardFandaRate2);
        GlobalVariables.setMessageMap((MessageMap)new MessageMap());
    }

    @Test
    public final void testIsFandaRateInputInPairs() {
        List awardFandaRateList = this.award.getAwardFandaRate();
        awardFandaRateList.add(new AwardFandaRate());
        awardFandaRateList.add(new AwardFandaRate());
        ((AwardFandaRate)awardFandaRateList.get(2)).setFandaRateTypeCode("6");
        ((AwardFandaRate)awardFandaRateList.get(2)).setOnCampusFlag("F");
        ((AwardFandaRate)awardFandaRateList.get(3)).setFandaRateTypeCode("6");
        ((AwardFandaRate)awardFandaRateList.get(3)).setOnCampusFlag("N");
        Assert.assertTrue((boolean)this.rule.isFandaRateInputInPairs(awardFandaRateList));
        ((AwardFandaRate)awardFandaRateList.get(0)).setOnCampusFlag("F");
        ((AwardFandaRate)awardFandaRateList.get(1)).setOnCampusFlag("F");
        ((AwardFandaRate)awardFandaRateList.get(2)).setOnCampusFlag("F");
        ((AwardFandaRate)awardFandaRateList.get(3)).setOnCampusFlag("F");
        Assert.assertFalse((boolean)this.rule.isFandaRateInputInPairs(awardFandaRateList));
    }
}

