/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.commitments;

import java.sql.Date;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.award.commitments.AwardFandaRate;
import org.kuali.kra.award.commitments.AwardFandaRateRule;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.MessageMap;

public class AwardFandaRateRuleTest {
    private static final String PROPERTY_PREFIX = "DUMMY_PREFIX";
    AwardFandaRateRule awardFandaRateRule;
    AwardFandaRate awardFandaRate;

    @Before
    public void setUp() throws Exception {
        this.awardFandaRateRule = new AwardFandaRateRule();
        this.awardFandaRate = new AwardFandaRate();
        this.awardFandaRate.setApplicableFandaRate(new KualiDecimal(5));
        this.awardFandaRate.setFiscalYear("2008");
        this.awardFandaRate.setFandaRateTypeCode("5");
        this.awardFandaRate.setOnCampusFlag("N");
        this.awardFandaRate.setUnderrecoveryOfIndirectCost(new KualiDecimal(1000));
        this.awardFandaRate.setStartDate(new Date(new Long("1183316613046")));
        this.awardFandaRate.setEndDate(new Date(new Long("1214852613046")));
        GlobalVariables.setMessageMap((MessageMap)new MessageMap());
    }

    @After
    public void tearDown() throws Exception {
        this.awardFandaRateRule = null;
        this.awardFandaRate = null;
    }

    @Test
    public final void testEvaluateRuleForApplicableIndirectCostRate() {
        Assert.assertTrue((boolean)this.awardFandaRateRule.evaluateRuleForApplicableFandaRate(this.awardFandaRate, PROPERTY_PREFIX));
    }

    @Test
    public final void testEvaluateRuleForApplicableIndirectCostRateNull() {
        this.awardFandaRate.setApplicableFandaRate(null);
        Assert.assertFalse((boolean)this.awardFandaRateRule.evaluateRuleForApplicableFandaRate(this.awardFandaRate, PROPERTY_PREFIX));
    }

    @Test
    public final void testEvaluateRuleForApplicableIndirectCostRateEmpty() {
        this.awardFandaRate.setApplicableFandaRate(new KualiDecimal(-5));
        Assert.assertFalse((boolean)this.awardFandaRateRule.evaluateRuleForApplicableFandaRate(this.awardFandaRate, PROPERTY_PREFIX));
    }

    @Test
    public final void testEvaluateRuleForIdcRateTypeCode() {
        Assert.assertTrue((boolean)this.awardFandaRateRule.evaluateRuleForFandaRateTypeCode(this.awardFandaRate, PROPERTY_PREFIX));
    }

    @Test
    public final void testEvaluateRuleForFiscalYear() {
        Assert.assertTrue((boolean)this.awardFandaRateRule.evaluateRuleForFiscalYear(this.awardFandaRate, PROPERTY_PREFIX));
    }

    @Test
    public final void testEvaluateRuleForStartAndEndDates() {
        Assert.assertTrue((boolean)this.awardFandaRateRule.evaluateRuleForStartAndEndDates(this.awardFandaRate, PROPERTY_PREFIX));
    }
}

