/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.contacts;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.award.contacts.AwardCreditSplitBean;
import org.kuali.kra.award.contacts.AwardPerson;
import org.kuali.kra.award.contacts.AwardPersonCreditSplit;
import org.kuali.kra.award.contacts.AwardPersonUnit;
import org.kuali.kra.award.contacts.AwardPersonUnitCreditSplit;
import org.kuali.kra.award.contacts.ContactRoleFixtureFactory;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.home.ContactRole;
import org.kuali.kra.bo.KcPerson;
import org.kuali.kra.bo.KcPersonFixtureFactory;
import org.kuali.kra.bo.Unit;
import org.kuali.kra.proposaldevelopment.bo.InvestigatorCreditType;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public class AwardCreditSplitBeanTest {
    private static final double DELTA = 0.1;
    private Award award;
    private AwardCreditSplitBean bean;
    private static final KualiDecimal MAX_VALUE = new KualiDecimal("100.00");
    private static final KualiDecimal ZERO_VALUE = new KualiDecimal("0.00");
    private static final String ERROR_MSG_PATTERN = "Error on Person : %s Role: %s: %s";

    @Before
    public void setUp() {
        this.prepareAward();
        this.bean = new AwardCreditSplitBean(null){

            Award getAward() {
                return AwardCreditSplitBeanTest.this.award;
            }

            Collection<InvestigatorCreditType> loadInvestigatorCreditTypes() {
                return AwardCreditSplitBeanTest.this.getMockCreditTypes();
            }
        };
    }

    @After
    public void tearDown() {
        this.bean = null;
        this.award = null;
    }

    @Test
    public void testCalculatingCreditSplitTotals_PersonTotals_NonZero() {
        Map<String, KualiDecimal> expectedTotals = this.initializeCreditSplitTotalsForAllPersons();
        Map results = this.bean.calculateCreditSplitTotals();
        Map personCreditSplitTotalsByCreditSplitType = (Map)results.get("personTotalsKey");
        for (InvestigatorCreditType creditSplitType : this.bean.loadInvestigatorCreditTypes()) {
            String creditTypeCode = creditSplitType.getInvCreditTypeCode();
            KualiDecimal total = (KualiDecimal)personCreditSplitTotalsByCreditSplitType.get(creditTypeCode);
            KualiDecimal expectedTotal = expectedTotals.get(creditTypeCode);
            Assert.assertEquals((String)this.createInvalidTotalMessage(creditSplitType.getDescription()), (double)expectedTotal.doubleValue(), (double)total.doubleValue(), (double)0.1);
        }
    }

    @Test
    public void testCalculatingCreditSplitTotals_PersonTotals_Zero() {
        Map results = this.bean.calculateCreditSplitTotals();
        Map personCreditSplitTotalsByCreditSplitType = (Map)results.get("personTotalsKey");
        for (String creditSplitType : personCreditSplitTotalsByCreditSplitType.keySet()) {
            KualiDecimal total = (KualiDecimal)personCreditSplitTotalsByCreditSplitType.get(creditSplitType);
            Assert.assertEquals((double)0.0, (double)total.doubleValue(), (double)0.1);
        }
    }

    @Test
    public void testCalculatingCreditSplitTotals_PersonUnitTotals__NonZeroTotals_AllPersonsHaveUnits() {
        this.verifyPersonUnitTotals();
    }

    @Test
    public void testCalculatingCreditSplitTotals_PersonUnitTotals_NonZeroTotals_KeyPersonHasNoUnits() {
        this.clearKeyPersonUnits();
        this.verifyPersonUnitTotals();
    }

    @Test
    public void testCalculatingCreditSplitTotals_PersonUnitTotals_Zero() {
        Map results = this.bean.calculateCreditSplitTotals();
        for (AwardPerson ap : this.award.getProjectPersons()) {
            Map personUnitCreditSplitTotalsByCreditSplitType = (Map)results.get(ap.getFullName());
            for (String creditSplitType : personUnitCreditSplitTotalsByCreditSplitType.keySet()) {
                KualiDecimal total = (KualiDecimal)personUnitCreditSplitTotalsByCreditSplitType.get(creditSplitType);
                Assert.assertEquals((double)0.0, (double)total.doubleValue(), (double)0.1);
            }
        }
    }

    private void addAwardPerson(Long id, String personId, String fullName, ContactRole contactRole) {
        KcPerson person = KcPersonFixtureFactory.createKcPerson(personId);
        person.setPersonId(id.toString());
        AwardPerson ap = new AwardPerson(person, contactRole);
        ap.setFullName(fullName);
        ap.setAwardContactId(id);
        this.addUnit(ap, "Unit A", "100");
        this.addUnit(ap, "Unit B", "200");
        this.addUnit(ap, "Unit C", "300");
        this.award.add(ap);
    }

    private void addUnit(AwardPerson ap, String unitName, String unitNumber) {
        Unit unit = new Unit();
        unit.setUnitName(unitName);
        unit.setUnitNumber(unitNumber);
        AwardPersonUnit apu = new AwardPersonUnit(ap, unit, false);
        ap.add(apu);
    }

    private void clearKeyPersonUnits() {
        AwardPerson keyPerson = (AwardPerson)this.award.getProjectPersons().get(2);
        if (!keyPerson.getContactRoleCode().equals("KP")) {
            Assert.fail((String)"Test should have set 3rd person to be KeyPerson");
        }
        keyPerson.getUnits().clear();
    }

    private String createInvalidTotalMessage(String creditSplitType) {
        return String.format("Invalid total for %s", creditSplitType);
    }

    private Collection<InvestigatorCreditType> getMockCreditTypes() {
        ArrayList<InvestigatorCreditType> types = new ArrayList<InvestigatorCreditType>();
        types.add(new InvestigatorCreditType("0", "Recognition"));
        types.add(new InvestigatorCreditType("1", "Responsibility"));
        types.add(new InvestigatorCreditType("2", "Space"));
        types.add(new InvestigatorCreditType("3", "Financial"));
        return types;
    }

    private Map<String, KualiDecimal> initializeCreditSplitTotalsForAllPersons() {
        HashMap<String, KualiDecimal> expectedTotals = new HashMap<String, KualiDecimal>();
        KualiDecimal creditSplitValue = (KualiDecimal)MAX_VALUE.divide((AbstractKualiDecimal)new KualiDecimal(this.award.getProjectPersons().size()));
        for (InvestigatorCreditType creditType : this.bean.loadInvestigatorCreditTypes()) {
            for (AwardPerson p : this.award.getProjectPersons()) {
                AwardPersonCreditSplit personCreditSplit = new AwardPersonCreditSplit(creditType, creditSplitValue);
                p.add(personCreditSplit);
            }
            expectedTotals.put(creditType.getInvCreditTypeCode(), MAX_VALUE);
        }
        return expectedTotals;
    }

    private Map<String, Map<String, KualiDecimal>> initializeCreditSplitTotalsForEachPersonUnit() {
        HashMap<String, Map<String, KualiDecimal>> personMapOfUnitCreditSplitTotals = new HashMap<String, Map<String, KualiDecimal>>();
        HashMap<String, KualiDecimal> expectedPersonUnitCreditSplitTotals = new HashMap<String, KualiDecimal>();
        Collection creditSplitTypes = this.bean.loadInvestigatorCreditTypes();
        for (AwardPerson p : this.award.getProjectPersons()) {
            for (InvestigatorCreditType creditType : creditSplitTypes) {
                List units = p.getUnits();
                if (units.size() > 0) {
                    KualiDecimal creditSplitValue = (KualiDecimal)MAX_VALUE.divide((AbstractKualiDecimal)new KualiDecimal(units.size()));
                    for (AwardPersonUnit apu : units) {
                        apu.add(new AwardPersonUnitCreditSplit(creditType, creditSplitValue));
                    }
                }
                expectedPersonUnitCreditSplitTotals.put(creditType.getInvCreditTypeCode(), MAX_VALUE);
            }
            personMapOfUnitCreditSplitTotals.put(p.getFullName(), expectedPersonUnitCreditSplitTotals);
        }
        return personMapOfUnitCreditSplitTotals;
    }

    private void prepareAward() {
        this.award = new Award();
        this.addAwardPerson(1L, "1001", "Person A", ContactRoleFixtureFactory.MOCK_PI);
        this.addAwardPerson(2L, "1002", "Person B", ContactRoleFixtureFactory.MOCK_COI);
        this.addAwardPerson(3L, "1003", "Person C", ContactRoleFixtureFactory.MOCK_KEY_PERSON);
    }

    private void verifyPersonUnitTotals() {
        Map<String, Map<String, KualiDecimal>> expectedPersonUnitCreditSplitTotals = this.initializeCreditSplitTotalsForEachPersonUnit();
        Map results = this.bean.calculateCreditSplitTotals();
        for (AwardPerson p : this.award.getProjectPersons()) {
            String fullName = p.getFullName();
            Map personUnitCreditSplitTotalsByCreditSplitType = (Map)results.get(fullName);
            for (InvestigatorCreditType creditSplitType : this.bean.loadInvestigatorCreditTypes()) {
                String invCreditTypeCode = creditSplitType.getInvCreditTypeCode();
                KualiDecimal total = (KualiDecimal)personUnitCreditSplitTotalsByCreditSplitType.get(invCreditTypeCode);
                KualiDecimal expectedValue = expectedPersonUnitCreditSplitTotals.get(fullName).get(invCreditTypeCode);
                Assert.assertEquals((String)this.createErrorMessage(p, creditSplitType), (double)expectedValue.doubleValue(), (double)total.doubleValue(), (double)0.1);
            }
        }
    }

    private String createErrorMessage(AwardPerson p, InvestigatorCreditType creditSplitType) {
        return String.format(ERROR_MSG_PATTERN, p.getPersonId(), p.roleCode, this.createInvalidTotalMessage(creditSplitType.getDescription()));
    }
}

