/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.contacts;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.award.contacts.AwardPerson;
import org.kuali.kra.award.contacts.AwardProjectPersonAddRuleImpl;
import org.kuali.kra.award.contacts.ContactRoleFixtureFactory;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.bo.KcPerson;
import org.kuali.kra.bo.KcPersonFixtureFactory;
import org.kuali.kra.bo.NonOrganizationalRolodex;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.MessageMap;

public class AwardProjectPersonAddRuleImplTest {
    private static final int ROLODEX_ID = 1002;
    private Award award;
    private AwardProjectPersonAddRuleImpl rule;
    private KcPerson person1;
    private static final String PERSON_ID = "1001";

    @Before
    public void setUp() {
        this.rule = new AwardProjectPersonAddRuleImpl();
        this.award = new Award();
        this.person1 = KcPersonFixtureFactory.createKcPerson(PERSON_ID);
        NonOrganizationalRolodex person2 = new NonOrganizationalRolodex();
        person2.setRolodexId(Integer.valueOf(1002));
        this.award.add(new AwardPerson(this.person1, ContactRoleFixtureFactory.MOCK_PI));
        this.award.add(new AwardPerson(person2, ContactRoleFixtureFactory.MOCK_COI));
        GlobalVariables.setMessageMap((MessageMap)new MessageMap());
    }

    @After
    public void tearDown() {
        this.rule = null;
        this.award = null;
    }

    @Test
    public void testCheckForExistingPI_DuplicateFound() {
        AwardPerson newPerson = new AwardPerson(new KcPerson(), ContactRoleFixtureFactory.MOCK_PI);
        Assert.assertFalse((String)"Duplicate PI not identified", (boolean)this.rule.checkForExistingPrincipalInvestigators(this.award, newPerson));
    }

    @Test
    public void testCheckForExistingPI_NoDuplicateFound() {
        AwardPerson newPerson = new AwardPerson(new KcPerson(), ContactRoleFixtureFactory.MOCK_KEY_PERSON);
        Assert.assertTrue((String)"Duplicate PI misidentified", (boolean)this.rule.checkForExistingPrincipalInvestigators(this.award, newPerson));
    }

    @Test
    public void testCheckForDuplicateContact_DuplicatePersonFound() {
        KcPerson duplicatePerson = KcPersonFixtureFactory.createKcPerson(PERSON_ID);
        duplicatePerson.setPersonId(this.person1.getPersonId());
        AwardPerson newPerson = new AwardPerson(duplicatePerson, ContactRoleFixtureFactory.MOCK_KEY_PERSON);
        Assert.assertFalse((String)"Duplicate Person not identified", (boolean)this.rule.checkForDuplicatePerson(this.award, newPerson));
    }

    @Test
    public void testCheckForDuplicateContact_DuplicateRolodexFound() {
        NonOrganizationalRolodex duplicatePerson = new NonOrganizationalRolodex();
        duplicatePerson.setRolodexId(Integer.valueOf(1002));
        AwardPerson newPerson = new AwardPerson(duplicatePerson, ContactRoleFixtureFactory.MOCK_KEY_PERSON);
        Assert.assertFalse((String)"Duplicate Rolodex not identified", (boolean)this.rule.checkForDuplicatePerson(this.award, newPerson));
    }

    @Test
    public void testCheckForKeyPersonRole_NotFound() {
        AwardPerson newPerson = new AwardPerson(new KcPerson(), ContactRoleFixtureFactory.MOCK_KEY_PERSON);
        newPerson.setKeyPersonRole(null);
        Assert.assertFalse((String)"Key Person Role not checked for", (boolean)this.rule.checkForKeyPersonProjectRoles(newPerson));
    }
}

