/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.contacts;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.award.contacts.AwardPerson;
import org.kuali.kra.award.contacts.AwardProjectPersonsAuditRule;
import org.kuali.kra.award.contacts.ContactRoleFixtureFactory;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.bo.KcPerson;
import org.kuali.kra.bo.NonOrganizationalRolodex;
import org.kuali.kra.bo.Unit;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.MessageMap;

public class AwardProjectPersonsAuditRuleTest {
    private static final String MISSING_UNIT_DETAILS_NOT_IDENTIFIED = "Missing unit Details not identified";
    private static final int ROLODEX_ID = 1002;
    private Award award;
    private AwardProjectPersonsAuditRule rule;
    private KcPerson person1;
    private NonOrganizationalRolodex person2;
    private Unit unitA;
    private Unit unitB;

    @Before
    public void setUp() {
        this.rule = new AwardProjectPersonsAuditRule();
        this.award = new Award();
        this.person1 = new KcPerson();
        this.person1.setPersonId("1001");
        this.person2 = new NonOrganizationalRolodex();
        this.person2.setRolodexId(Integer.valueOf(1002));
        this.award.add(new AwardPerson(this.person1, ContactRoleFixtureFactory.MOCK_PI));
        this.award.add(new AwardPerson(this.person2, ContactRoleFixtureFactory.MOCK_COI));
        this.unitA = new Unit();
        this.unitA.setUnitName("a");
        this.unitA.setUnitNumber("1");
        this.unitB = new Unit();
        this.unitB.setUnitName("b");
        this.unitB.setUnitNumber("2");
        GlobalVariables.setMessageMap((MessageMap)new MessageMap());
    }

    @After
    public void tearDown() {
        this.rule = null;
        this.award = null;
    }

    @Test
    public void testCheckForExistingPI_DuplicateFound() {
        AwardPerson newPerson = new AwardPerson(new KcPerson(), ContactRoleFixtureFactory.MOCK_PI);
        this.award.add(newPerson);
        Assert.assertFalse((String)"Duplicate PI not identified", (boolean)this.rule.checkPrincipalInvestigators(this.award.getProjectPersons()));
    }

    @Test
    public void testCheckForExistingPI_NoDuplicateFound() {
        AwardPerson newPerson = new AwardPerson(new KcPerson(), ContactRoleFixtureFactory.MOCK_KEY_PERSON);
        this.award.add(newPerson);
        Assert.assertTrue((String)"Duplicate PI misidentified", (boolean)this.rule.checkPrincipalInvestigators(this.award.getProjectPersons()));
    }

    @Test
    public void testCheckForUnitDetails_RequiredForPI() {
        ((AwardPerson)this.award.getProjectPersons().get(1)).setContactRole(ContactRoleFixtureFactory.MOCK_KEY_PERSON);
        Assert.assertFalse((String)MISSING_UNIT_DETAILS_NOT_IDENTIFIED, (boolean)this.rule.checkUnits(this.award.getProjectPersons()));
    }

    @Test
    public void testCheckForUnitDetails_RequiredForCoI() {
        ((AwardPerson)this.award.getProjectPersons().get(0)).setContactRole(ContactRoleFixtureFactory.MOCK_KEY_PERSON);
        Assert.assertFalse((String)MISSING_UNIT_DETAILS_NOT_IDENTIFIED, (boolean)this.rule.checkUnits(this.award.getProjectPersons()));
    }

    @Test
    public void testCheckForUnitDetails_NotRequiredForKeyPerson() {
        ((AwardPerson)this.award.getProjectPersons().get(0)).setContactRole(ContactRoleFixtureFactory.MOCK_KEY_PERSON);
        ((AwardPerson)this.award.getProjectPersons().get(1)).setContactRole(ContactRoleFixtureFactory.MOCK_KEY_PERSON);
        Assert.assertTrue((String)"Unit details are not required for key person", (boolean)this.rule.checkLeadUnits(this.award.getProjectPersons()));
    }
}

