/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.contacts;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.award.contacts.AwardPerson;
import org.kuali.kra.award.contacts.AwardPersonUnit;
import org.kuali.kra.award.contacts.AwardProjectPersonsSaveRuleImpl;
import org.kuali.kra.award.contacts.ContactRoleFixtureFactory;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.bo.KcPerson;
import org.kuali.kra.bo.KcPersonFixtureFactory;
import org.kuali.kra.bo.NonOrganizationalRolodex;
import org.kuali.kra.bo.Unit;
import org.kuali.rice.krad.util.ErrorMessage;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.MessageMap;
import org.springframework.util.AutoPopulatingList;

public class AwardProjectPersonsSaveRuleImplTest {
    private static final String MISSING_UNIT_DETAILS_NOT_IDENTIFIED = "Missing unit Details not identified";
    private static final int ROLODEX_ID = 1002;
    private Award award;
    private AwardProjectPersonsSaveRuleImpl rule;
    private Unit unitA;
    private Unit unitB;
    private static final String PERSON_ID = "1001";
    private static final String KP_PERSON_ID = "1002";
    private AwardPerson piPerson;
    private AwardPerson coiPerson;
    private AwardPerson kpPerson;

    @Before
    public void setUp() {
        this.rule = new AwardProjectPersonsSaveRuleImpl();
        this.award = new Award();
        this.unitA = new Unit();
        this.unitA.setUnitName("a");
        this.unitA.setUnitNumber("1");
        this.unitB = new Unit();
        this.unitB.setUnitName("b");
        this.unitB.setUnitNumber("2");
        KcPerson employee = KcPersonFixtureFactory.createKcPerson(PERSON_ID);
        this.piPerson = new AwardPerson(employee, ContactRoleFixtureFactory.MOCK_PI);
        this.piPerson.add(new AwardPersonUnit(this.piPerson, this.unitA, true));
        NonOrganizationalRolodex nonEmployee = new NonOrganizationalRolodex();
        nonEmployee.setRolodexId(Integer.valueOf(1002));
        this.coiPerson = new AwardPerson(nonEmployee, ContactRoleFixtureFactory.MOCK_COI);
        this.coiPerson.add(new AwardPersonUnit(this.coiPerson, this.unitA, false));
        KcPerson employee2 = KcPersonFixtureFactory.createKcPerson(KP_PERSON_ID);
        this.kpPerson = new AwardPerson(employee2, ContactRoleFixtureFactory.MOCK_KEY_PERSON);
        this.kpPerson.setKeyPersonRole("Tester");
        this.kpPerson.add(new AwardPersonUnit(this.kpPerson, this.unitA, false));
        this.award.add(this.piPerson);
        this.award.add(this.coiPerson);
        this.award.add(this.kpPerson);
        GlobalVariables.setMessageMap((MessageMap)new MessageMap());
    }

    @After
    public void tearDown() {
        this.rule = null;
        this.award = null;
    }

    @Test
    public void testCheckForExistingPI() {
        Assert.assertTrue((String)"PI not found or more than one found", (boolean)this.rule.checkForOnePrincipalInvestigator(this.award.getProjectPersons()));
        this.award.getProjectPersons().remove(0);
        Assert.assertFalse((String)"PI existence check failed", (boolean)this.rule.checkForOnePrincipalInvestigator(this.award.getProjectPersons()));
        this.checkErrorState("projectPersons", "error.awardProjectPerson.no.pi.exists");
    }

    @Test
    public void testCheckForMultiplePIs() {
        AwardPerson newPerson = new AwardPerson(KcPersonFixtureFactory.createKcPerson(KP_PERSON_ID), ContactRoleFixtureFactory.MOCK_PI);
        this.award.add(newPerson);
        Assert.assertFalse((String)"Multiple PIs not detected", (boolean)this.rule.checkForOnePrincipalInvestigator(this.award.getProjectPersons()));
        this.checkErrorState("projectPersons", "error.awardProjectPerson.pi.exists");
    }

    @Test
    public void testCheckForRequiredUnitDetails_PI() {
        Assert.assertTrue((String)MISSING_UNIT_DETAILS_NOT_IDENTIFIED, (boolean)this.rule.checkForRequiredUnitDetails(this.award.getProjectPersons()));
        this.piPerson.getUnits().clear();
        Assert.assertFalse((String)MISSING_UNIT_DETAILS_NOT_IDENTIFIED, (boolean)this.rule.checkForRequiredUnitDetails(this.award.getProjectPersons()));
        this.checkErrorState("projectPersons", "error.awardProjectPerson.unit.details.required");
    }

    @Test
    public void testCheckForRequiredUnitDetails_COI() {
        Assert.assertTrue((String)MISSING_UNIT_DETAILS_NOT_IDENTIFIED, (boolean)this.rule.checkForRequiredUnitDetails(this.award.getProjectPersons()));
        this.coiPerson.getUnits().clear();
        Assert.assertFalse((String)MISSING_UNIT_DETAILS_NOT_IDENTIFIED, (boolean)this.rule.checkForRequiredUnitDetails(this.award.getProjectPersons()));
        this.checkErrorState("projectPersons", "error.awardProjectPerson.unit.details.required");
    }

    @Test
    public void testCheckForUnitDetailsNotRequired_KP() {
        Assert.assertTrue((String)MISSING_UNIT_DETAILS_NOT_IDENTIFIED, (boolean)this.rule.checkForRequiredUnitDetails(this.award.getProjectPersons()));
        this.kpPerson.getUnits().clear();
        Assert.assertTrue((String)MISSING_UNIT_DETAILS_NOT_IDENTIFIED, (boolean)this.rule.checkForRequiredUnitDetails(this.award.getProjectPersons()));
        Assert.assertEquals((long)0L, (long)GlobalVariables.getMessageMap().getErrorCount());
    }

    @Test
    public void testCheckForDuplicateUnits_NoneFound() {
        this.piPerson.add(new AwardPersonUnit(this.piPerson, this.unitB, false));
        Assert.assertTrue((boolean)this.rule.checkForDuplicateUnits(this.award.getProjectPersons()));
    }

    @Test
    public void testCheckForDuplicateUnits_DupeFound() {
        this.piPerson.add(new AwardPersonUnit(this.piPerson, this.unitA, false));
        Assert.assertFalse((String)"Duplicate should have been found", (boolean)this.rule.checkForDuplicateUnits(this.award.getProjectPersons()));
        this.checkErrorState("projectPersons", "error.awardProjectPerson.duplicate.units");
    }

    @Test
    public void testCheckForLeadUnit_NoneFound() {
        Assert.assertTrue((String)"No lead unit was found", (boolean)this.rule.checkForLeadUnitForPI(this.award.getProjectPersons()));
        this.piPerson.getUnit(0).setLeadUnit(false);
        Assert.assertFalse((String)"No lead unit should have been found", (boolean)this.rule.checkForLeadUnitForPI(this.award.getProjectPersons()));
        this.checkErrorState("projectPersons", "error.awardProjectPerson.lead.unit.required");
    }

    @Test
    public void testCheckForKeyPersonRole_NotFound() {
        this.kpPerson.setKeyPersonRole(null);
        Assert.assertFalse((String)"Key Person Role not checked for", (boolean)this.rule.checkForKeyPersonProjectRoles(this.award.getProjectPersons()));
        this.checkErrorState("projectPersons", "error.awardProjectPerson.keyperson.role.required");
    }

    @Test
    public void testCheckForKeyPersonRole_Found() {
        Assert.assertTrue((String)"Key Person Role not checked for", (boolean)this.rule.checkForKeyPersonProjectRoles(this.award.getProjectPersons()));
    }

    @Test
    public void testProjectRolesChanges() {
        this.coiPerson.setContactRole(ContactRoleFixtureFactory.MOCK_KEY_PERSON);
        Assert.assertFalse((String)"Key Person Role not checked for", (boolean)this.rule.checkForKeyPersonProjectRoles(this.award.getProjectPersons()));
        this.coiPerson.setKeyPersonRole("fromCOI");
        Assert.assertTrue((String)"Key Person Role not checked for", (boolean)this.rule.checkForKeyPersonProjectRoles(this.award.getProjectPersons()));
        this.kpPerson.setContactRole(ContactRoleFixtureFactory.MOCK_COI);
        Assert.assertTrue((String)"rule should return true", (boolean)this.rule.processSaveAwardProjectPersonsBusinessRules(this.award.getProjectPersons()));
    }

    private void checkErrorState(String errorProperty, String errorMessageKey) {
        MessageMap messageMap = GlobalVariables.getMessageMap();
        Assert.assertTrue((messageMap.getErrorCount() >= 1 ? 1 : 0) != 0);
        AutoPopulatingList errors = messageMap.getErrorMessagesForProperty(errorProperty);
        if (errors != null) {
            Assert.assertEquals((long)1L, (long)errors.size());
            Assert.assertEquals((Object)errorMessageKey, (Object)((ErrorMessage)errors.get(0)).getErrorKey());
        } else {
            Assert.fail((String)"No errors posted");
        }
        Assert.assertFalse((String)"rule should return false", (boolean)this.rule.processSaveAwardProjectPersonsBusinessRules(this.award.getProjectPersons()));
    }
}

