/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.contacts;

import org.apache.ojb.broker.accesslayer.conversions.ConversionException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.award.contacts.UnitContactTypeConverter;
import org.kuali.kra.bo.UnitContactType;

public class ContactCategoryConversionTest {
    private static final String UNSUPPORTED_ENUM_VALUE = "FOO_BAR";
    private UnitContactTypeConverter converter;

    @Before
    public void setUp() {
        this.converter = new UnitContactTypeConverter();
    }

    @After
    public void tearDown() {
        this.converter = null;
    }

    @Test(expected=ConversionException.class)
    public void testConvertingRoleToSqlString_ConversionException() {
        this.converter.javaToSql((Object)"Bad Type");
    }

    @Test
    public void testConvertingContactCategoryToSqlString() {
        for (UnitContactType unitContactType : UnitContactType.values()) {
            Assert.assertEquals((Object)unitContactType.name(), (Object)this.converter.javaToSql((Object)unitContactType));
        }
    }

    @Test(expected=ConversionException.class)
    public void testConvertingSqlValueToContactRole_ConversionException_BadType() {
        this.converter.sqlToJava((Object)Long.MAX_VALUE);
    }

    @Test(expected=ConversionException.class)
    public void testConvertingSqlValueToContactRole_ConversionException_InvalidValue() {
        this.converter.sqlToJava((Object)UNSUPPORTED_ENUM_VALUE);
    }

    @Test
    public void testConvertingSqlValueToContactCategory() {
        for (UnitContactType unitContactType : UnitContactType.values()) {
            Assert.assertEquals((Object)unitContactType, (Object)this.converter.sqlToJava((Object)unitContactType.name()));
        }
    }
}

