/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.detailsdates;

import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.kra.award.detailsdates.AddAwardTransferringSponsorEvent;
import org.kuali.kra.award.detailsdates.AwardDetailsAndDatesRuleImpl;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.bo.Sponsor;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.MessageMap;

public class AwardDetailsAndDatesRuleImplTest {
    Sponsor sponsor;
    Award award;
    AddAwardTransferringSponsorEvent event;
    AwardDetailsAndDatesRuleImpl awardDetailsAndDatesRule;
    private Mockery context = new JUnit4Mockery();

    @Test
    public void testAddUnknownAwardTransferringSponsor() throws Exception {
        this.initializeDefaults();
        this.awardDetailsAndDatesRule.setBusinessObjectService(this.getMockBusinessObjectServiceReturnsNull());
        Assert.assertFalse((boolean)this.awardDetailsAndDatesRule.processAddAwardTransferringSponsorEvent(this.event));
        Assert.assertTrue((boolean)GlobalVariables.getMessageMap().containsMessageKey("error.sponsor.invalid"));
    }

    @Test
    public void testAddDuplicateAwardTransferringSponsor() throws Exception {
        this.initializeDefaults();
        this.award.addAwardTransferringSponsor(this.sponsor);
        this.awardDetailsAndDatesRule.setBusinessObjectService(this.getMockBusinessObjectServiceReturnsSponsor());
        Assert.assertFalse((boolean)this.awardDetailsAndDatesRule.processAddAwardTransferringSponsorEvent(this.event));
        Assert.assertTrue((boolean)GlobalVariables.getMessageMap().containsMessageKey("error.sponsor.duplicate"));
    }

    @Test
    public void testAddValidAwardTransferringSponsor() throws Exception {
        this.initializeDefaults();
        this.awardDetailsAndDatesRule.setBusinessObjectService(this.getMockBusinessObjectServiceReturnsSponsor());
        Assert.assertTrue((boolean)this.awardDetailsAndDatesRule.processAddAwardTransferringSponsorEvent(this.event));
        Assert.assertTrue((boolean)GlobalVariables.getMessageMap().hasNoErrors());
    }

    private void initializeDefaults() {
        this.sponsor = new Sponsor();
        this.sponsor.setSponsorCode("1");
        this.award = new Award();
        this.awardDetailsAndDatesRule = new AwardDetailsAndDatesRuleImpl();
        this.event = new AddAwardTransferringSponsorEvent("", null, this.award, this.sponsor);
        GlobalVariables.setMessageMap((MessageMap)new MessageMap());
    }

    private BusinessObjectService getMockBusinessObjectServiceReturnsNull() {
        final BusinessObjectService MOCK_BO_SERVICE = (BusinessObjectService)this.context.mock(BusinessObjectService.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((BusinessObjectService)this.one(MOCK_BO_SERVICE)).retrieve((PersistableBusinessObject)AwardDetailsAndDatesRuleImplTest.this.sponsor);
                this.will(1.returnValue(null));
            }
        });
        return MOCK_BO_SERVICE;
    }

    private BusinessObjectService getMockBusinessObjectServiceReturnsSponsor() {
        final BusinessObjectService MOCK_BO_SERVICE = (BusinessObjectService)this.context.mock(BusinessObjectService.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((BusinessObjectService)this.one(MOCK_BO_SERVICE)).retrieve((PersistableBusinessObject)AwardDetailsAndDatesRuleImplTest.this.sponsor);
                this.will(2.returnValue((Object)AwardDetailsAndDatesRuleImplTest.this.sponsor));
            }
        });
        return MOCK_BO_SERVICE;
    }
}

