/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.home;

import java.util.ArrayList;
import java.util.List;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.award.contacts.AwardPerson;
import org.kuali.kra.award.contacts.AwardPersonUnit;
import org.kuali.kra.award.contacts.ContactRoleFixtureFactory;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.paymentreports.specialapproval.approvedequipment.AwardApprovedEquipment;
import org.kuali.kra.bo.KcPerson;
import org.kuali.kra.bo.KcPersonFixtureFactory;
import org.kuali.kra.bo.NonOrganizationalRolodex;
import org.kuali.kra.bo.Unit;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public class AwardTest {
    private static final double DELTA = 0.001;
    private static final int AWARD_ATTRIBUTES_COUNT = 129;
    private static final String PERSON_ID = "1001";
    private static final String KP_PERSON_ID = "1002";
    private static final int ROLODEX_ID = 1002;
    private Award awardBo;

    @Before
    public void setUp() throws Exception {
        this.awardBo = new Award();
    }

    @After
    public void tearDown() throws Exception {
        this.awardBo = null;
    }

    @Test
    public void testAwardBoAttributesCount() throws Exception {
        Assert.assertEquals((long)129L, (long)this.awardBo.getClass().getDeclaredFields().length);
    }

    @Test
    public void testCalculatingValuableItemTotal() {
        double AMOUNT1 = 100.0;
        double AMOUNT2 = 200.0;
        double AMOUNT3 = 300.0;
        Award award = new Award();
        ArrayList<AwardApprovedEquipment> items = new ArrayList<AwardApprovedEquipment>();
        items.add(this.createValuableItem(100.0));
        items.add(this.createValuableItem(200.0));
        items.add(this.createValuableItem(300.0));
        award.setApprovedEquipmentItems(items);
        Assert.assertEquals((double)600.0, (double)award.getTotalAmount(items).doubleValue(), (double)0.001);
    }

    private AwardApprovedEquipment createValuableItem(double amount) {
        AwardApprovedEquipment item = new AwardApprovedEquipment();
        item.setAmount(new KualiDecimal(amount));
        return item;
    }

    @Test
    public void testIsNew_CaseAwardIdIsNull() {
        this.awardBo.setAwardId(null);
        Assert.assertTrue((boolean)this.awardBo.isNew());
    }

    @Test
    public void testIsNew_CaseAwardIdIsNotNull() {
        this.awardBo.setAwardId(new Long(1L));
        Assert.assertFalse((boolean)this.awardBo.isNew());
    }

    @Test
    public void testGetProjectPesons() {
        this.addProjectPersonsToAward();
        List aList = this.awardBo.getProjectPersons();
        Assert.assertEquals((long)3L, (long)aList.size());
        ((AwardPerson)aList.get(0)).getContactRole();
        Assert.assertEquals((Object)"COI", (Object)((AwardPerson)aList.get(0)).getContactRoleCode());
        Assert.assertEquals((Object)"KP", (Object)((AwardPerson)aList.get(1)).getContactRoleCode());
        Assert.assertEquals((Object)"PI", (Object)((AwardPerson)aList.get(2)).getContactRoleCode());
        aList = this.awardBo.getProjectPersonsSorted();
        Assert.assertEquals((long)3L, (long)aList.size());
        Assert.assertEquals((Object)"PI", (Object)((AwardPerson)aList.get(0)).getContactRoleCode());
        Assert.assertEquals((Object)"COI", (Object)((AwardPerson)aList.get(1)).getContactRoleCode());
        Assert.assertEquals((Object)"KP", (Object)((AwardPerson)aList.get(2)).getContactRoleCode());
    }

    public void addProjectPersonsToAward() {
        this.awardBo = new Award();
        Unit unitA = new Unit();
        unitA.setUnitName("a");
        unitA.setUnitNumber("1");
        Unit unitB = new Unit();
        unitB.setUnitName("b");
        unitB.setUnitNumber("2");
        KcPerson employee = KcPersonFixtureFactory.createKcPerson(PERSON_ID);
        AwardPerson piPerson = new AwardPerson(employee, ContactRoleFixtureFactory.MOCK_PI);
        AwardPersonUnit aUnit = new AwardPersonUnit();
        aUnit.setAwardPerson(piPerson);
        aUnit.setUnit(unitA);
        aUnit.setLeadUnit(true);
        piPerson.add(aUnit);
        NonOrganizationalRolodex nonEmployee = new NonOrganizationalRolodex();
        nonEmployee.setRolodexId(Integer.valueOf(1002));
        AwardPerson coiPerson = new AwardPerson(nonEmployee, ContactRoleFixtureFactory.MOCK_COI);
        aUnit.setAwardPerson(coiPerson);
        aUnit.setUnit(unitA);
        aUnit.setLeadUnit(false);
        coiPerson.add(aUnit);
        KcPerson employee2 = KcPersonFixtureFactory.createKcPerson(KP_PERSON_ID);
        AwardPerson kpPerson = new AwardPerson(employee2, ContactRoleFixtureFactory.MOCK_KEY_PERSON);
        kpPerson.setKeyPersonRole("Tester");
        aUnit.setAwardPerson(kpPerson);
        aUnit.setUnit(unitA);
        aUnit.setLeadUnit(false);
        kpPerson.add(aUnit);
        this.awardBo.add(coiPerson);
        this.awardBo.add(kpPerson);
        this.awardBo.add(piPerson);
    }
}

