/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.home.fundingproposal;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.award.customdata.AwardCustomData;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.home.AwardService;
import org.kuali.kra.award.home.AwardServiceImpl;
import org.kuali.kra.award.home.fundingproposal.AwardFundingProposalBean;
import org.kuali.kra.award.home.fundingproposal.FundingProposalMergeType;
import org.kuali.kra.bo.NsfCode;
import org.kuali.kra.bo.Sponsor;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposal;
import org.kuali.kra.proposaldevelopment.bo.ActivityType;
import org.kuali.kra.test.infrastructure.KcUnitTestBase;

public class AwardFundingProposalBeanTest
extends KcUnitTestBase {
    private AwardFundingProposalBean bean;
    private Award award1;
    private Award award2;
    private Award award3;
    private InstitutionalProposal instProp;
    final MockAwardService awardService = new MockAwardService();

    @Override
    @Before
    public void setUp() {
        this.award1 = this.createAward(1L, "100001-001", 1);
        this.award2 = this.createAward(2L, "100002-001", 1);
        this.award3 = this.createAward(3L, "100001-001", 2);
        Sponsor testSponsor = new Sponsor();
        testSponsor.setSponsorCode("testsp");
        this.instProp = new InstitutionalProposal();
        this.instProp.setProposalNumber("1234");
        this.instProp.setTitle("Test Title");
        this.instProp.setActivityTypeCode("RES");
        this.instProp.setCfdaNumber("11.111a");
        this.instProp.setNsfCode("0A");
        this.instProp.setActivityType(new ActivityType());
        this.instProp.setSponsor(testSponsor);
        this.instProp.setPrimeSponsor(testSponsor);
        this.instProp.setNsfCodeBo(new NsfCode());
        this.bean = new AwardFundingProposalBean(){

            Award getAward() {
                return AwardFundingProposalBeanTest.this.award3;
            }

            AwardService getAwardService() {
                return AwardFundingProposalBeanTest.this.awardService;
            }
        };
    }

    @Override
    @After
    public void tearDown() {
        this.bean = null;
        this.award1 = null;
        this.award2 = null;
        this.award3 = null;
    }

    @Test
    public void testGettingAllAwardsForAwardNumber_OneFound() {
        ArrayList<Award> results = new ArrayList<Award>();
        results.add(this.award2);
        this.awardService.setResults(results);
        Assert.assertEquals((long)1L, (long)this.bean.getAllAwardsForAwardNumber().size());
    }

    @Test
    public void testGettingAllAwardsForAwardNumber_twoFound() {
        ArrayList<Award> cannedResults = new ArrayList<Award>();
        cannedResults.add(this.award3);
        cannedResults.add(this.award1);
        this.awardService.setResults(cannedResults);
        List actualResults = this.bean.getAllAwardsForAwardNumber();
        Assert.assertEquals((long)2L, (long)actualResults.size());
        Assert.assertEquals((long)1L, (long)((Award)actualResults.get(0)).getSequenceNumber().intValue());
        Assert.assertEquals((long)2L, (long)((Award)actualResults.get(1)).getSequenceNumber().intValue());
    }

    @Test
    public void testPerformDataFeedsNewAward() {
        this.bean.setMergeType(FundingProposalMergeType.NEWAWARD);
        this.award3.getAwardCustomDataList().add(new AwardCustomData());
        this.bean.performDataFeeds(this.award3, this.instProp);
        AwardFundingProposalBeanTest.assertEquals((Object)this.instProp.getTitle(), (Object)this.award3.getTitle());
        AwardFundingProposalBeanTest.assertEquals((Object)this.instProp.getActivityTypeCode(), (Object)this.award3.getActivityTypeCode());
        AwardFundingProposalBeanTest.assertEquals((Object)this.instProp.getSponsorCode(), (Object)this.award3.getSponsorCode());
        AwardFundingProposalBeanTest.assertEquals((Object)this.instProp.getPrimeSponsorCode(), (Object)this.award3.getPrimeSponsorCode());
        AwardFundingProposalBeanTest.assertEquals((Object)this.instProp.getCfdaNumber(), (Object)this.award3.getCfdaNumber());
        AwardFundingProposalBeanTest.assertEquals((Object)this.instProp.getNsfCode(), (Object)this.award3.getNsfCode());
    }

    @Test
    public void testPerformDataFeedsNoChange() {
        this.bean.setMergeType(FundingProposalMergeType.NOCHANGE);
        this.award3.getAwardCustomDataList().add(new AwardCustomData());
        this.bean.performDataFeeds(this.award3, this.instProp);
        AwardFundingProposalBeanTest.assertFalse((boolean)StringUtils.equals((String)this.instProp.getTitle(), (String)this.award3.getTitle()));
        AwardFundingProposalBeanTest.assertFalse((boolean)StringUtils.equals((String)this.instProp.getActivityTypeCode(), (String)this.award3.getActivityTypeCode()));
        AwardFundingProposalBeanTest.assertFalse((boolean)StringUtils.equals((String)this.instProp.getSponsorCode(), (String)this.award3.getSponsorCode()));
        AwardFundingProposalBeanTest.assertFalse((boolean)StringUtils.equals((String)this.instProp.getPrimeSponsorCode(), (String)this.award3.getPrimeSponsorCode()));
        AwardFundingProposalBeanTest.assertFalse((boolean)StringUtils.equals((String)this.instProp.getCfdaNumber(), (String)this.award3.getCfdaNumber()));
        AwardFundingProposalBeanTest.assertFalse((boolean)StringUtils.equals((String)this.instProp.getNsfCode(), (String)this.award3.getNsfCode()));
    }

    private Award createAward(Long id, String awardNumber, Integer sequenceNumber) {
        Award award = new Award();
        award.setAwardId(id);
        award.setAwardNumber(awardNumber);
        award.setSequenceNumber(sequenceNumber);
        return award;
    }

    class MockAwardService
    extends AwardServiceImpl {
        private List<Award> results;

        MockAwardService() {
        }

        public void setResults(List<Award> results) {
            this.results = results;
        }

        public List<Award> findAwardsForAwardNumber(String awardNumber) {
            TreeSet<Award> orderedSet = new TreeSet<Award>(new Comparator<Award>(){

                @Override
                public int compare(Award a1, Award a2) {
                    return a1.getSequenceNumber().compareTo(a2.getSequenceNumber());
                }
            });
            orderedSet.addAll(this.results);
            return new ArrayList<Award>(orderedSet);
        }
    }
}

