/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.home.fundingproposal;

import org.apache.commons.lang.StringUtils;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.award.commitments.AwardCostShare;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.home.fundingproposal.BaseDataFeedCommandTest;
import org.kuali.kra.award.home.fundingproposal.CostSharingDataFeedCommand;
import org.kuali.kra.award.home.fundingproposal.FundingProposalMergeType;
import org.kuali.kra.bo.CostShareType;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposalCostShare;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public class CostSharingDataFeedCommandTest
extends BaseDataFeedCommandTest {
    private CostShareType costShareType;
    private InstitutionalProposalCostShare ipCostShare1;
    private InstitutionalProposalCostShare ipCostShare2;
    private AwardCostShare awardCostShare1;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.costShareType = new CostShareType();
        this.costShareType.setCostShareTypeCode(Integer.valueOf(1));
        this.ipCostShare1 = this.createIpCostShare("2010");
        this.ipCostShare2 = this.createIpCostShare("2011");
        this.awardCostShare1 = this.createAwardCostShare("2010");
        this.proposal.add(this.ipCostShare1);
        this.proposal.add(this.ipCostShare2);
    }

    @Test
    public void testAddCostShares() {
        CostSharingDataFeedCommand command = new CostSharingDataFeedCommand(this.award, this.proposal, FundingProposalMergeType.NEWAWARD);
        command.performDataFeed();
        CostSharingDataFeedCommandTest.assertTrue((this.award.getAwardCostShares().size() == this.proposal.getInstitutionalProposalCostShares().size() ? 1 : 0) != 0);
        CostSharingDataFeedCommandTest.assertTrue((boolean)this.containsCostShare(this.award, this.ipCostShare1));
        CostSharingDataFeedCommandTest.assertTrue((boolean)this.containsCostShare(this.award, this.ipCostShare2));
    }

    @Test
    public void testMergeCostShares() {
        CostSharingDataFeedCommand command = new CostSharingDataFeedCommand(this.award, this.proposal, FundingProposalMergeType.MERGE);
        this.award.add(this.awardCostShare1);
        command.performDataFeed();
        CostSharingDataFeedCommandTest.assertTrue((this.award.getAwardCostShares().size() == this.proposal.getInstitutionalProposalCostShares().size() + 1 ? 1 : 0) != 0);
        CostSharingDataFeedCommandTest.assertTrue((boolean)this.containsCostShare(this.award, this.ipCostShare1));
        CostSharingDataFeedCommandTest.assertTrue((boolean)this.containsCostShare(this.award, this.ipCostShare2));
    }

    protected InstitutionalProposalCostShare createIpCostShare(String fiscalYear) {
        InstitutionalProposalCostShare retval = new InstitutionalProposalCostShare();
        retval.setAmount(new KualiDecimal(200.0));
        retval.setCostSharePercentage(new KualiDecimal(0.05));
        retval.setCostShareType(this.costShareType);
        retval.setProjectPeriod(fiscalYear);
        retval.setSourceAccount("abc123");
        return retval;
    }

    protected AwardCostShare createAwardCostShare(String fiscalYear) {
        AwardCostShare retval = new AwardCostShare();
        retval.setCommitmentAmount(new KualiDecimal(100.0));
        retval.setCostSharePercentage(new KualiDecimal(0.05));
        retval.setCostShareType(this.costShareType);
        retval.setProjectPeriod(fiscalYear);
        retval.setSource("abc123");
        return retval;
    }

    protected boolean containsCostShare(Award award, InstitutionalProposalCostShare ipCostShare) {
        for (AwardCostShare awardCostShare : award.getAwardCostShares()) {
            if (!StringUtils.equals((String)awardCostShare.getProjectPeriod(), (String)ipCostShare.getProjectPeriod()) || !StringUtils.equals((String)awardCostShare.getSource(), (String)ipCostShare.getSourceAccount()) || !awardCostShare.getAmount().equals((Object)ipCostShare.getAmount())) continue;
            return true;
        }
        return false;
    }
}

