/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.home.fundingproposal;

import org.apache.commons.lang.StringUtils;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.home.fundingproposal.BaseDataFeedCommandTest;
import org.kuali.kra.award.home.fundingproposal.FundingProposalMergeType;
import org.kuali.kra.award.home.fundingproposal.KeywordsDataFeedCommand;
import org.kuali.kra.award.home.keywords.AwardScienceKeyword;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposalScienceKeyword;

public class KeywordsDataFeedCommandTest
extends BaseDataFeedCommandTest {
    private InstitutionalProposalScienceKeyword ipKey1;
    private InstitutionalProposalScienceKeyword ipKey2;
    private AwardScienceKeyword awardKey1;
    private AwardScienceKeyword awardKey2;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.ipKey1 = new InstitutionalProposalScienceKeyword();
        this.ipKey1.setScienceKeywordCode("1");
        this.ipKey2 = new InstitutionalProposalScienceKeyword();
        this.ipKey2.setScienceKeywordCode("2");
        this.proposal.getKeywords().add(this.ipKey1);
        this.proposal.getKeywords().add(this.ipKey2);
        this.awardKey1 = new AwardScienceKeyword();
        this.awardKey1.setScienceKeywordCode("1");
        this.awardKey2 = new AwardScienceKeyword();
        this.awardKey2.setScienceKeywordCode("3");
    }

    @Test
    public void testAddRates() {
        KeywordsDataFeedCommand command = new KeywordsDataFeedCommand(this.award, this.proposal, FundingProposalMergeType.NEWAWARD);
        command.performDataFeed();
        KeywordsDataFeedCommandTest.assertTrue((this.award.getKeywords().size() == this.proposal.getKeywords().size() ? 1 : 0) != 0);
        KeywordsDataFeedCommandTest.assertTrue((boolean)this.containsKeyword(this.award, this.ipKey1));
        KeywordsDataFeedCommandTest.assertTrue((boolean)this.containsKeyword(this.award, this.ipKey2));
    }

    @Test
    public void testMergeRates() {
        KeywordsDataFeedCommand command = new KeywordsDataFeedCommand(this.award, this.proposal, FundingProposalMergeType.MERGE);
        this.award.getKeywords().add(this.awardKey2);
        command.performDataFeed();
        KeywordsDataFeedCommandTest.assertTrue((this.award.getKeywords().size() == this.proposal.getKeywords().size() + 1 ? 1 : 0) != 0);
        KeywordsDataFeedCommandTest.assertTrue((boolean)this.containsKeyword(this.award, this.ipKey1));
        KeywordsDataFeedCommandTest.assertTrue((boolean)this.containsKeyword(this.award, this.ipKey2));
    }

    @Test
    public void testDuplicates() {
        KeywordsDataFeedCommand command = new KeywordsDataFeedCommand(this.award, this.proposal, FundingProposalMergeType.MERGE);
        this.award.getKeywords().add(this.awardKey1);
        command.performDataFeed();
        KeywordsDataFeedCommandTest.assertTrue((this.award.getKeywords().size() == this.proposal.getKeywords().size() ? 1 : 0) != 0);
        KeywordsDataFeedCommandTest.assertTrue((boolean)this.containsKeyword(this.award, this.ipKey1));
        KeywordsDataFeedCommandTest.assertTrue((boolean)this.containsKeyword(this.award, this.ipKey2));
    }

    protected boolean containsKeyword(Award award, InstitutionalProposalScienceKeyword ipKey) {
        for (AwardScienceKeyword awardKey : award.getKeywords()) {
            if (!StringUtils.equals((String)awardKey.getScienceKeywordCode(), (String)ipKey.getScienceKeywordCode())) continue;
            return true;
        }
        return false;
    }
}

