/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.home.fundingproposal;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.award.contacts.AwardPerson;
import org.kuali.kra.award.contacts.AwardPersonCreditSplit;
import org.kuali.kra.award.contacts.AwardPersonUnit;
import org.kuali.kra.award.contacts.AwardPersonUnitCreditSplit;
import org.kuali.kra.award.home.fundingproposal.BaseDataFeedCommandTest;
import org.kuali.kra.award.home.fundingproposal.FundingProposalMergeType;
import org.kuali.kra.award.home.fundingproposal.ProjectPersonnelDataFeedCommand;
import org.kuali.kra.bo.CreditType;
import org.kuali.kra.bo.Unit;
import org.kuali.kra.institutionalproposal.contacts.InstitutionalProposalPerson;
import org.kuali.kra.institutionalproposal.contacts.InstitutionalProposalPersonCreditSplit;
import org.kuali.kra.institutionalproposal.contacts.InstitutionalProposalPersonUnit;
import org.kuali.kra.institutionalproposal.contacts.InstitutionalProposalPersonUnitCreditSplit;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public class ProjectPersonnelDataFeedCommandTest
extends BaseDataFeedCommandTest {
    private Unit unit1;
    private Unit unit2;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.unit1 = new Unit();
        this.unit1.setUnitNumber("000001");
        this.unit2 = new Unit();
        this.unit2.setUnitNumber("BL-BL");
    }

    protected InstitutionalProposalPerson generateIPPerson(String personId, String personName, String roleCode, KualiDecimal creditSplit) {
        InstitutionalProposalPerson retval = new InstitutionalProposalPerson();
        retval.setPersonId(personId);
        retval.setFullName(personName);
        retval.setRoleCode(roleCode);
        if (creditSplit != null) {
            for (CreditType type : this.getCreditTypes()) {
                InstitutionalProposalPersonCreditSplit ipCredit = new InstitutionalProposalPersonCreditSplit();
                ipCredit.setCredit(creditSplit);
                ipCredit.setInvCreditTypeCode(type.getCreditTypeCode());
                retval.add(ipCredit);
            }
        }
        return retval;
    }

    protected InstitutionalProposalPersonUnit generateIPUnit(Unit unit, boolean leadUnit, KualiDecimal creditSplit) {
        InstitutionalProposalPersonUnit ipUnit = new InstitutionalProposalPersonUnit();
        ipUnit.setUnit(unit);
        ipUnit.setUnitNumber(unit.getUnitNumber());
        ipUnit.setLeadUnit(leadUnit);
        if (creditSplit != null) {
            for (CreditType type : this.getCreditTypes()) {
                InstitutionalProposalPersonUnitCreditSplit ipCredit = new InstitutionalProposalPersonUnitCreditSplit();
                ipCredit.setCredit(creditSplit);
                ipCredit.setInvCreditTypeCode(type.getCreditTypeCode());
                ipUnit.add(ipCredit);
            }
        }
        return ipUnit;
    }

    protected AwardPerson generateAwardPerson(String personId, String personName, String roleCode, KualiDecimal creditSplit) {
        AwardPerson retval = new AwardPerson();
        retval.setPersonId(personId);
        retval.setFullName(personName);
        retval.setRoleCode(roleCode);
        for (CreditType type : this.getCreditTypes()) {
            AwardPersonCreditSplit awardCredit = new AwardPersonCreditSplit();
            awardCredit.setCredit(creditSplit);
            awardCredit.setInvCreditTypeCode(type.getCreditTypeCode());
            retval.add(awardCredit);
        }
        return retval;
    }

    protected AwardPersonUnit generateAwardUnit(Unit unit, boolean leadUnit, KualiDecimal creditSplit) {
        AwardPersonUnit awardUnit = new AwardPersonUnit();
        awardUnit.setUnitNumber(unit.getUnitNumber());
        awardUnit.setUnit(unit);
        awardUnit.setLeadUnit(leadUnit);
        for (CreditType type : this.getCreditTypes()) {
            AwardPersonUnitCreditSplit awardCredit = new AwardPersonUnitCreditSplit();
            awardCredit.setCredit(creditSplit);
            awardCredit.setInvCreditTypeCode(type.getCreditTypeCode());
            awardUnit.add(awardCredit);
        }
        return awardUnit;
    }

    protected Collection<CreditType> getCreditTypes() {
        ArrayList<CreditType> types = new ArrayList<CreditType>();
        CreditType type = new CreditType();
        type.setCreditTypeCode("0");
        type.setDescription("CreditType1");
        types.add(type);
        type = new CreditType();
        type.setCreditTypeCode("1");
        type.setDescription("CreditType2");
        types.add(type);
        return types;
    }

    @Test
    public void testFeedNewAward() {
        InstitutionalProposalPerson ipPerson1 = this.generateIPPerson("10000000001", "Number 1", "PI", new KualiDecimal(50.0));
        ipPerson1.add(this.generateIPUnit(this.unit1, true, new KualiDecimal(100.0)));
        InstitutionalProposalPerson ipPerson2 = this.generateIPPerson("10000000002", "Number 2", "COI", new KualiDecimal(50.0));
        ipPerson2.add(this.generateIPUnit(this.unit1, false, new KualiDecimal(50.0)));
        ipPerson2.add(this.generateIPUnit(this.unit2, false, new KualiDecimal(50.0)));
        this.proposal.add(ipPerson1);
        this.proposal.add(ipPerson2);
        ProjectPersonnelDataFeedCommand command = new ProjectPersonnelDataFeedCommand(this.award, this.proposal, FundingProposalMergeType.NEWAWARD);
        command.performDataFeed();
        ProjectPersonnelDataFeedCommandTest.assertTrue((this.award.getProjectPersons().size() == this.proposal.getProjectPersons().size() ? 1 : 0) != 0);
        AwardPerson person1 = this.findAwardPerson(ipPerson1.getPersonId());
        AwardPerson person2 = this.findAwardPerson(ipPerson2.getPersonId());
        ProjectPersonnelDataFeedCommandTest.assertTrue((boolean)StringUtils.equals((String)person1.getRoleCode(), (String)ipPerson1.getRoleCode()));
        ProjectPersonnelDataFeedCommandTest.assertTrue((boolean)StringUtils.equals((String)person1.getFullName(), (String)ipPerson1.getFullName()));
        AwardPersonUnit awardUnit1 = this.findPersonUnit(person1, this.unit1.getUnitNumber());
        ProjectPersonnelDataFeedCommandTest.assertTrue((boolean)awardUnit1.isLeadUnit());
        ProjectPersonnelDataFeedCommandTest.assertTrue((boolean)person1.getCreditSplit(0).getCredit().equals((Object)ipPerson1.getCreditSplit(0).getCredit()));
        ProjectPersonnelDataFeedCommandTest.assertTrue((boolean)StringUtils.equals((String)person2.getRoleCode(), (String)ipPerson2.getRoleCode()));
    }

    @Test
    public void testTypicalMerge() {
        InstitutionalProposalPerson ipPerson1 = this.generateIPPerson("10000000001", "Number 1", "PI", new KualiDecimal(50.0));
        ipPerson1.add(this.generateIPUnit(this.unit1, true, new KualiDecimal(100.0)));
        InstitutionalProposalPerson ipPerson2 = this.generateIPPerson("10000000002", "Number 2", "COI", new KualiDecimal(50.0));
        ipPerson2.add(this.generateIPUnit(this.unit1, false, new KualiDecimal(50.0)));
        ipPerson2.add(this.generateIPUnit(this.unit2, false, new KualiDecimal(50.0)));
        this.proposal.add(ipPerson1);
        this.proposal.add(ipPerson2);
        AwardPerson awardPerson1 = this.generateAwardPerson("10000000003", "Number 3", "PI", new KualiDecimal(80.0));
        awardPerson1.add(this.generateAwardUnit(this.unit1, true, new KualiDecimal(100.0)));
        AwardPerson awardPerson2 = this.generateAwardPerson("10000000002", "Number 2", "COI", new KualiDecimal(20.0));
        awardPerson2.add(this.generateAwardUnit(this.unit1, false, new KualiDecimal(100.0)));
        this.award.add(awardPerson1);
        this.award.add(awardPerson2);
        ProjectPersonnelDataFeedCommand command = new ProjectPersonnelDataFeedCommand(this.award, this.proposal, FundingProposalMergeType.MERGE);
        command.performDataFeed();
        ProjectPersonnelDataFeedCommandTest.assertEquals((long)3L, (long)this.award.getProjectPersons().size());
        AwardPerson person1 = this.findAwardPerson(awardPerson1.getPersonId());
        ProjectPersonnelDataFeedCommandTest.assertEquals((Object)new KualiDecimal(80.0), (Object)person1.getCreditSplit(0).getCredit());
        ProjectPersonnelDataFeedCommandTest.assertTrue((boolean)person1.getUnit(0).isLeadUnit());
        ProjectPersonnelDataFeedCommandTest.assertEquals((Object)new KualiDecimal(100.0), (Object)person1.getUnit(0).getCreditSplit(0).getCredit());
        AwardPerson person2 = this.findAwardPerson(awardPerson2.getPersonId());
        ProjectPersonnelDataFeedCommandTest.assertEquals((Object)new KualiDecimal(70.0), (Object)person2.getCreditSplit(0).getCredit());
        ProjectPersonnelDataFeedCommandTest.assertEquals((long)2L, (long)person2.getUnits().size());
        AwardPersonUnit tempUnit = this.findPersonUnit(person2, this.unit1.getUnitNumber());
        ProjectPersonnelDataFeedCommandTest.assertEquals((Object)new KualiDecimal(150.0), (Object)tempUnit.getCreditSplit(0).getCredit());
        ProjectPersonnelDataFeedCommandTest.assertFalse((boolean)tempUnit.isLeadUnit());
        tempUnit = this.findPersonUnit(person2, this.unit2.getUnitNumber());
        ProjectPersonnelDataFeedCommandTest.assertEquals((Object)new KualiDecimal(50.0), (Object)tempUnit.getCreditSplit(0).getCredit());
        AwardPerson person3 = this.findAwardPerson(ipPerson1.getPersonId());
        ProjectPersonnelDataFeedCommandTest.assertEquals((Object)"COI", (Object)person3.getRoleCode());
        ProjectPersonnelDataFeedCommandTest.assertFalse((boolean)person3.getUnit(0).isLeadUnit());
    }

    @Test
    public void testDuplicateMerge() {
        InstitutionalProposalPerson ipPerson1 = this.generateIPPerson("10000000001", "Number 1", "PI", new KualiDecimal(50.0));
        ipPerson1.add(this.generateIPUnit(this.unit1, true, new KualiDecimal(100.0)));
        this.proposal.add(ipPerson1);
        AwardPerson awardPerson1 = this.generateAwardPerson("10000000001", "Number 1", "PI", new KualiDecimal(50.0));
        awardPerson1.add(this.generateAwardUnit(this.unit1, true, new KualiDecimal(100.0)));
        this.award.add(awardPerson1);
        ProjectPersonnelDataFeedCommand command = new ProjectPersonnelDataFeedCommand(this.award, this.proposal, FundingProposalMergeType.MERGE);
        command.performDataFeed();
        ProjectPersonnelDataFeedCommandTest.assertEquals((long)1L, (long)this.award.getProjectPersons().size());
        ProjectPersonnelDataFeedCommandTest.assertEquals((Object)new KualiDecimal(50.0), (Object)awardPerson1.getCreditSplit(0).getCredit());
        ProjectPersonnelDataFeedCommandTest.assertTrue((boolean)awardPerson1.getUnit(0).isLeadUnit());
        ProjectPersonnelDataFeedCommandTest.assertEquals((Object)new KualiDecimal(100.0), (Object)awardPerson1.getUnit(0).getCreditSplit(0).getCredit());
    }

    @Test
    public void testTypicalReplace() {
        InstitutionalProposalPerson ipPerson1 = this.generateIPPerson("10000000001", "Number 1", "PI", new KualiDecimal(50.0));
        ipPerson1.add(this.generateIPUnit(this.unit1, true, new KualiDecimal(100.0)));
        this.proposal.add(ipPerson1);
        AwardPerson awardPerson1 = this.generateAwardPerson("10000000003", "Number 1", "PI", new KualiDecimal(50.0));
        awardPerson1.add(this.generateAwardUnit(this.unit1, true, new KualiDecimal(100.0)));
        this.award.add(awardPerson1);
        ProjectPersonnelDataFeedCommand command = new ProjectPersonnelDataFeedCommand(this.award, this.proposal, FundingProposalMergeType.REPLACE);
        command.performDataFeed();
        ProjectPersonnelDataFeedCommandTest.assertEquals((long)1L, (long)this.award.getProjectPersons().size());
        AwardPerson person1 = this.findAwardPerson(awardPerson1.getPersonId());
        ProjectPersonnelDataFeedCommandTest.assertNull((Object)person1);
        AwardPerson person2 = this.findAwardPerson(ipPerson1.getPersonId());
        ProjectPersonnelDataFeedCommandTest.assertNotNull((Object)person2);
        ProjectPersonnelDataFeedCommandTest.assertEquals((Object)ipPerson1.getFullName(), (Object)person2.getFullName());
    }

    @Test
    public void testNoSplitReplace() {
        InstitutionalProposalPerson ipPerson1 = this.generateIPPerson("10000000001", "Number 1", "PI", null);
        ipPerson1.add(this.generateIPUnit(this.unit1, true, null));
        InstitutionalProposalPerson ipPerson2 = this.generateIPPerson("10000000002", "Number 2", "COI", null);
        ipPerson2.add(this.generateIPUnit(this.unit1, false, null));
        ipPerson2.add(this.generateIPUnit(this.unit2, false, null));
        this.proposal.add(ipPerson1);
        this.proposal.add(ipPerson2);
        AwardPerson awardPerson1 = this.generateAwardPerson("10000000003", "Number 3", "PI", new KualiDecimal(80.0));
        awardPerson1.add(this.generateAwardUnit(this.unit1, true, new KualiDecimal(100.0)));
        AwardPerson awardPerson2 = this.generateAwardPerson("10000000002", "Number 2", "COI", new KualiDecimal(20.0));
        awardPerson2.add(this.generateAwardUnit(this.unit1, false, new KualiDecimal(100.0)));
        this.award.add(awardPerson1);
        this.award.add(awardPerson2);
        ProjectPersonnelDataFeedCommand command = new ProjectPersonnelDataFeedCommand(this.award, this.proposal, FundingProposalMergeType.REPLACE);
        command.performDataFeed();
        ProjectPersonnelDataFeedCommandTest.assertEquals((long)3L, (long)this.award.getProjectPersons().size());
        AwardPerson person1 = this.findAwardPerson(awardPerson1.getPersonId());
        ProjectPersonnelDataFeedCommandTest.assertEquals((Object)new KualiDecimal(80.0), (Object)person1.getCreditSplit(0).getCredit());
        ProjectPersonnelDataFeedCommandTest.assertTrue((boolean)person1.getUnit(0).isLeadUnit());
        ProjectPersonnelDataFeedCommandTest.assertEquals((Object)new KualiDecimal(100.0), (Object)person1.getUnit(0).getCreditSplit(0).getCredit());
        AwardPerson person2 = this.findAwardPerson(awardPerson2.getPersonId());
        ProjectPersonnelDataFeedCommandTest.assertEquals((Object)new KualiDecimal(20.0), (Object)person2.getCreditSplit(0).getCredit());
        ProjectPersonnelDataFeedCommandTest.assertEquals((long)2L, (long)person2.getUnits().size());
        AwardPerson person3 = this.findAwardPerson(ipPerson1.getPersonId());
        ProjectPersonnelDataFeedCommandTest.assertEquals((Object)"COI", (Object)person3.getRoleCode());
        ProjectPersonnelDataFeedCommandTest.assertFalse((boolean)person3.getUnit(0).isLeadUnit());
    }

    public AwardPerson findAwardPerson(String personId) {
        AwardPerson person = this.award.getProjectPerson(personId);
        for (AwardPerson curPerson : this.award.getProjectPersons()) {
            if (curPerson == person) continue;
            ProjectPersonnelDataFeedCommandTest.assertFalse((String)"Duplicate award person", (boolean)StringUtils.equals((String)curPerson.getPersonId(), (String)personId));
        }
        return person;
    }

    public AwardPersonUnit findPersonUnit(AwardPerson person, String unitNumber) {
        AwardPersonUnit unit = person.getUnit(unitNumber);
        for (AwardPersonUnit curUnit : person.getUnits()) {
            if (curUnit == unit) continue;
            ProjectPersonnelDataFeedCommandTest.assertFalse((String)"Duplicate unit found", (boolean)StringUtils.equals((String)curUnit.getUnitNumber(), (String)unitNumber));
        }
        return unit;
    }
}

