/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.home.fundingproposal;

import org.apache.commons.lang.StringUtils;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.award.commitments.AwardFandaRate;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.home.fundingproposal.BaseDataFeedCommandTest;
import org.kuali.kra.award.home.fundingproposal.FandARatesDataFeedCommand;
import org.kuali.kra.award.home.fundingproposal.FundingProposalMergeType;
import org.kuali.kra.institutionalproposal.IndirectcostRateType;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposalUnrecoveredFandA;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public class SpecialReviewDataFeedCommandTest
extends BaseDataFeedCommandTest {
    private IndirectcostRateType idcRateType;
    private InstitutionalProposalUnrecoveredFandA ipFandA1;
    private InstitutionalProposalUnrecoveredFandA ipFandA2;
    private AwardFandaRate awardFandA;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.idcRateType = new IndirectcostRateType();
        this.idcRateType.setIndirectcostRateTypeCode(Integer.valueOf(1));
        this.ipFandA1 = this.createIPFandA("2010");
        this.ipFandA2 = this.createIPFandA("2011");
        this.awardFandA = this.createAwardFandA("2010");
        this.proposal.add(this.ipFandA1);
        this.proposal.add(this.ipFandA2);
    }

    @Test
    public void testAddRates() {
        FandARatesDataFeedCommand command = new FandARatesDataFeedCommand(this.award, this.proposal, FundingProposalMergeType.NEWAWARD);
        command.performDataFeed();
        SpecialReviewDataFeedCommandTest.assertTrue((this.award.getAwardFandaRate().size() == this.proposal.getInstitutionalProposalUnrecoveredFandAs().size() ? 1 : 0) != 0);
        SpecialReviewDataFeedCommandTest.assertTrue((boolean)this.containsRate(this.award, this.ipFandA1));
        SpecialReviewDataFeedCommandTest.assertTrue((boolean)this.containsRate(this.award, this.ipFandA2));
    }

    @Test
    public void testMergeRates() {
        FandARatesDataFeedCommand command = new FandARatesDataFeedCommand(this.award, this.proposal, FundingProposalMergeType.MERGE);
        this.award.add(this.awardFandA);
        command.performDataFeed();
        SpecialReviewDataFeedCommandTest.assertTrue((this.award.getAwardFandaRate().size() == this.proposal.getInstitutionalProposalUnrecoveredFandAs().size() + 1 ? 1 : 0) != 0);
        SpecialReviewDataFeedCommandTest.assertTrue((boolean)this.containsRate(this.award, this.ipFandA1));
        SpecialReviewDataFeedCommandTest.assertTrue((boolean)this.containsRate(this.award, this.ipFandA2));
    }

    protected InstitutionalProposalUnrecoveredFandA createIPFandA(String fiscalYear) {
        InstitutionalProposalUnrecoveredFandA retval = new InstitutionalProposalUnrecoveredFandA();
        retval.setFiscalYear(fiscalYear);
        retval.setIndirectcostRateType(this.idcRateType);
        retval.setApplicableIndirectcostRate(new KualiDecimal(0.01));
        retval.setOnCampusFlag(true);
        retval.setSourceAccount("abc123");
        retval.setUnderrecoveryOfIndirectcost(new KualiDecimal(10.5));
        return retval;
    }

    protected AwardFandaRate createAwardFandA(String fiscalYear) {
        AwardFandaRate retval = new AwardFandaRate();
        retval.setApplicableFandaRate(new KualiDecimal(0.02));
        retval.setFandaRateTypeCode(this.idcRateType.getIndirectcostRateTypeCode() == null ? null : this.idcRateType.getIndirectcostRateTypeCode().toString());
        retval.setFiscalYear(fiscalYear);
        retval.setOnCampusFlag("N");
        retval.setSourceAccount("abc123");
        retval.setUnderrecoveryOfIndirectCost(new KualiDecimal(21.0));
        return retval;
    }

    protected boolean containsRate(Award award, InstitutionalProposalUnrecoveredFandA ipRate) {
        for (AwardFandaRate rate : award.getAwardFandaRate()) {
            if (!StringUtils.equals((String)rate.getFiscalYear(), (String)ipRate.getFiscalYear()) || !StringUtils.equals((String)rate.getSourceAccount(), (String)ipRate.getSourceAccount()) || !rate.getUnderrecoveryOfIndirectCost().equals((Object)ipRate.getUnderrecoveryOfIndirectcost())) continue;
            return true;
        }
        return false;
    }
}

