/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.home.fundingproposal;

import junit.framework.Assert;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.award.home.fundingproposal.BaseDataFeedCommandTest;
import org.kuali.kra.award.home.fundingproposal.FundingProposalMergeType;
import org.kuali.kra.award.home.fundingproposal.ProposalDataFeedCommandBase;
import org.kuali.kra.award.home.fundingproposal.SponsorDataFeedCommand;
import org.kuali.kra.bo.Sponsor;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.service.SponsorService;

public class SponsorDataFeedCommandTest
extends BaseDataFeedCommandTest {
    private ProposalDataFeedCommandBase command;
    private Sponsor sponsor;
    private SponsorService sponsorService;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.sponsorService = (SponsorService)KraServiceLocator.getService(SponsorService.class);
        this.sponsor = this.sponsorService.getSponsor("000107");
        this.initializeProposal();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.sponsorService = null;
        super.tearDown();
    }

    @Test
    public void testSponsorFeed() {
        this.command = new SponsorDataFeedCommand(this.award, this.proposal, FundingProposalMergeType.NEWAWARD);
        this.command.performDataFeed();
        Assert.assertEquals((String)this.proposal.getSponsorCode(), (String)this.award.getSponsorCode());
        Assert.assertEquals((String)this.proposal.getSponsor().getSponsorCode(), (String)this.award.getSponsor().getSponsorCode());
        Assert.assertEquals((String)this.proposal.getSponsor().getSponsorName(), (String)this.award.getSponsor().getSponsorName());
        Assert.assertEquals((String)this.proposal.getPrimeSponsorCode(), (String)this.award.getPrimeSponsorCode());
        Assert.assertEquals((String)this.proposal.getPrimeSponsor().getSponsorName(), (String)this.award.getPrimeSponsor().getSponsorName());
    }

    @Test
    public void testReplaceSponsorFeed() {
        this.command = new SponsorDataFeedCommand(this.award, this.proposal, FundingProposalMergeType.REPLACE);
        this.command.performDataFeed();
        Assert.assertNotSame((Object)this.proposal.getSponsorCode(), (Object)this.award.getSponsorCode());
        Assert.assertEquals((String)this.proposal.getPrimeSponsorCode(), (String)this.award.getPrimeSponsorCode());
        Assert.assertEquals((String)this.proposal.getPrimeSponsor().getSponsorName(), (String)this.award.getPrimeSponsor().getSponsorName());
    }

    private void initializeProposal() {
        this.proposal.setSponsor(this.sponsor);
        this.proposal.setSponsorCode(this.sponsor.getSponsorCode());
        this.proposal.setPrimeSponsor(this.sponsor);
        this.proposal.setPrimeSponsorCode(this.sponsor.getSponsorCode());
        this.proposal.setCfdaNumber("abc.123");
        this.proposal.setNsfCode("abc");
    }
}

