/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.lookup.keyvalue;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.award.home.AwardTemplate;
import org.kuali.kra.award.home.AwardTemplateContact;
import org.kuali.kra.award.home.ContactType;
import org.kuali.kra.award.lookup.keyvalue.AwardTemplateContactValuesFinder;
import org.kuali.kra.lookup.keyvalue.PrefixValuesFinder;
import org.kuali.kra.test.infrastructure.KcUnitTestBase;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;

public class AwardTemplateContactValuesFinderTest
extends KcUnitTestBase {
    AwardTemplateContactValuesFinder awardTempContactValuesFinder;
    List<KeyValue> contactKeys;
    AwardTemplate template;
    List<AwardTemplateContact> contactList;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.template = new AwardTemplate();
        this.contactList = new ArrayList<AwardTemplateContact>();
        this.addContacts("ContactType1", 1);
        this.addContacts("ContactType2", 2);
        this.template.setTemplateContacts(this.contactList);
        this.awardTempContactValuesFinder = this.getAwardTemplateContactValuesFinder();
        this.contactKeys = new ArrayList<KeyValue>();
        this.contactKeys = this.awardTempContactValuesFinder.getKeyValues();
    }

    public void addContacts(String contactTypeCode, int rolodexId) {
        AwardTemplateContact aContact = new AwardTemplateContact();
        ContactType aContactType = new ContactType();
        aContactType.setContactTypeCode(contactTypeCode);
        aContactType.setDescription(contactTypeCode + " Description");
        aContact.setContactType(aContactType);
        aContact.setRoleCode(contactTypeCode);
        aContact.setRolodexId(Integer.valueOf(rolodexId));
        this.contactList.add(aContact);
    }

    private AwardTemplateContactValuesFinder getAwardTemplateContactValuesFinder() {
        return new AwardTemplateContactValuesFinder(){

            public List<KeyValue> getKeyValues() {
                List contacts = AwardTemplateContactValuesFinderTest.this.template.getTemplateContacts();
                ArrayList<KeyValue> keyValues = new ArrayList<KeyValue>();
                for (AwardTemplateContact contact : contacts) {
                    keyValues.add((KeyValue)new ConcreteKeyValue(contact.getRoleCode() + "***" + contact.getRolodexId().toString(), contact.getContactType().getDescription() + "***" + contact.getRolodexId().toString()));
                }
                keyValues.add(0, (KeyValue)new ConcreteKeyValue(PrefixValuesFinder.getPrefixKey(), PrefixValuesFinder.getDefaultPrefixValue()));
                return keyValues;
            }
        };
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
        this.awardTempContactValuesFinder = null;
        this.template = null;
        this.contactKeys = null;
        this.contactList = null;
    }

    @Test
    public final void testGetKeyValues() {
        int count = this.template.getTemplateContacts().size();
        Assert.assertEquals((long)(count + 1), (long)this.contactKeys.size());
        for (KeyValue KeyValue2 : this.contactKeys) {
            Assert.assertNotNull((Object)KeyValue2.getKey());
            Assert.assertNotNull((Object)KeyValue2.getValue());
            String keyString = KeyValue2.getKey().toString();
            String labelString = KeyValue2.getValue();
            if (StringUtils.equals((String)labelString, (String)"select")) continue;
            if (keyString.contains("1")) {
                StringUtils.equals((String)keyString, (String)"ContactType1***1");
                StringUtils.equals((String)labelString, (String)"ContactType1 Description***1");
                continue;
            }
            StringUtils.equals((String)keyString, (String)"ContactType2***2");
            StringUtils.equals((String)labelString, (String)"ContactType2 Description***1");
        }
    }
}

