/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.lookup.keyvalue;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.award.lookup.keyvalue.FrequencyBaseCodeValuesFinder;
import org.kuali.kra.award.paymentreports.ValidFrequencyBase;
import org.kuali.kra.test.infrastructure.KcUnitTestBase;
import org.kuali.rice.core.api.util.KeyValue;

public class FrequencyBaseCodeValuesFinderTest
extends KcUnitTestBase {
    FrequencyBaseCodeValuesFinder frequencyBaseCodeValuesFinder;
    List<KeyValue> frequencyBaseCodes;
    Collection<ValidFrequencyBase> validFrequencyBases;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.frequencyBaseCodeValuesFinder = new FrequencyBaseCodeValuesFinder("13");
        this.frequencyBaseCodes = new ArrayList<KeyValue>();
        this.validFrequencyBases = new ArrayList<ValidFrequencyBase>();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
        this.frequencyBaseCodeValuesFinder = null;
        this.frequencyBaseCodes = null;
        this.validFrequencyBases = null;
    }

    @Test
    public final void testGetKeyValues() {
        this.frequencyBaseCodes = this.frequencyBaseCodeValuesFinder.getKeyValues();
        Assert.assertEquals((long)3L, (long)this.frequencyBaseCodes.size());
        for (KeyValue KeyValue2 : this.frequencyBaseCodes) {
            Assert.assertNotNull((Object)KeyValue2.getKey());
            Assert.assertNotNull((Object)KeyValue2.getValue());
        }
    }

    @Test
    public final void testGetRelevantValidClassReportFrequencies() {
        this.validFrequencyBases.add(new ValidFrequencyBase("13", "14"));
        this.validFrequencyBases.add(new ValidFrequencyBase("13", "1"));
        this.validFrequencyBases.add(new ValidFrequencyBase("13", "55"));
        this.validFrequencyBases.add(new ValidFrequencyBase("14", "55"));
        this.validFrequencyBases.add(new ValidFrequencyBase("14", "2"));
        this.validFrequencyBases.add(new ValidFrequencyBase("15", "5"));
        Assert.assertEquals((long)3L, (long)this.frequencyBaseCodeValuesFinder.getUniqueRelevantFrequencyBaseCodes(this.validFrequencyBases).size());
    }
}

