/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.lookup.keyvalue;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.award.lookup.keyvalue.FrequencyCodeValuesFinder;
import org.kuali.kra.award.paymentreports.ValidClassReportFrequency;
import org.kuali.kra.test.infrastructure.KcUnitTestBase;
import org.kuali.rice.core.api.util.KeyValue;

public class FrequencyCodeValuesFinderTest
extends KcUnitTestBase {
    FrequencyCodeValuesFinder frequencyCodeValuesFinder;
    List<KeyValue> frequencyCodes;
    Collection<ValidClassReportFrequency> validClassReportFrequencies;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.frequencyCodeValuesFinder = new FrequencyCodeValuesFinder("4", "9");
        this.frequencyCodes = new ArrayList<KeyValue>();
        this.validClassReportFrequencies = new ArrayList<ValidClassReportFrequency>();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
        this.frequencyCodeValuesFinder = null;
        this.frequencyCodes = null;
    }

    @Test
    public final void testGetKeyValues() {
        this.frequencyCodes = this.frequencyCodeValuesFinder.getKeyValues();
        Assert.assertEquals((long)5L, (long)this.frequencyCodes.size());
        for (KeyValue KeyValue2 : this.frequencyCodes) {
            Assert.assertNotNull((Object)KeyValue2.getKey());
            Assert.assertNotNull((Object)KeyValue2.getValue());
        }
    }

    @Test
    public final void testGetRelevantValidClassReportFrequencies() {
        this.frequencyCodeValuesFinder = new FrequencyCodeValuesFinder("1", "55");
        this.validClassReportFrequencies.add(new ValidClassReportFrequency("1", "1", "1"));
        this.validClassReportFrequencies.add(new ValidClassReportFrequency("1", "1", "13"));
        this.validClassReportFrequencies.add(new ValidClassReportFrequency("1", "55", "4"));
        this.validClassReportFrequencies.add(new ValidClassReportFrequency("1", "55", "7"));
        this.validClassReportFrequencies.add(new ValidClassReportFrequency("1", "55", "8"));
        this.validClassReportFrequencies.add(new ValidClassReportFrequency("2", "5", "16"));
        Assert.assertEquals((long)3L, (long)this.frequencyCodeValuesFinder.getUniqueRelevantFrequencyCodes(this.validClassReportFrequencies).size());
    }

    @Test
    public final void testThis() {
        this.frequencyCodeValuesFinder.setReportClassCode("1");
        this.frequencyCodeValuesFinder.setReportCode("27");
        this.frequencyCodes = this.frequencyCodeValuesFinder.getKeyValues();
        Assert.assertEquals((long)3L, (long)this.frequencyCodes.size());
        for (KeyValue KeyValue2 : this.frequencyCodes) {
            Assert.assertNotNull((Object)KeyValue2.getKey());
            Assert.assertNotNull((Object)KeyValue2.getValue());
        }
    }
}

