/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.lookup.keyvalue;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.award.lookup.keyvalue.ReportCodeValuesFinder;
import org.kuali.kra.award.paymentreports.ValidClassReportFrequency;
import org.kuali.kra.test.infrastructure.KcUnitTestBase;
import org.kuali.rice.core.api.util.KeyValue;

public class ReportCodeValuesFinderTest
extends KcUnitTestBase {
    ReportCodeValuesFinder reportCodeValuesFinder;
    List<KeyValue> reportCodes;
    Collection<ValidClassReportFrequency> validClassReportFrequencies;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.reportCodeValuesFinder = new ReportCodeValuesFinder("1");
        this.reportCodes = new ArrayList<KeyValue>();
        this.validClassReportFrequencies = new ArrayList<ValidClassReportFrequency>();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
        this.reportCodeValuesFinder = null;
        this.reportCodes = null;
    }

    @Test
    public final void testGetKeyValues() {
        this.reportCodes = this.reportCodeValuesFinder.getKeyValues();
        Assert.assertEquals((long)11L, (long)this.reportCodes.size());
        for (KeyValue KeyValue2 : this.reportCodes) {
            Assert.assertNotNull((Object)KeyValue2.getKey());
            Assert.assertNotNull((Object)KeyValue2.getValue());
        }
    }

    @Test
    public final void testGetRelevantValidClassReportFrequencies() {
        this.validClassReportFrequencies.add(new ValidClassReportFrequency("1", "1", "1"));
        this.validClassReportFrequencies.add(new ValidClassReportFrequency("1", "1", "13"));
        this.validClassReportFrequencies.add(new ValidClassReportFrequency("1", "55", "4"));
        this.validClassReportFrequencies.add(new ValidClassReportFrequency("1", "55", "7"));
        this.validClassReportFrequencies.add(new ValidClassReportFrequency("1", "55", "8"));
        this.validClassReportFrequencies.add(new ValidClassReportFrequency("2", "5", "16"));
        Assert.assertEquals((long)2L, (long)this.reportCodeValuesFinder.getUniqueRelevantReportClassCodes(this.validClassReportFrequencies).size());
    }
}

