/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.paymentreports.awardreports;

import java.sql.Date;
import java.util.ArrayList;
import java.util.List;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.award.paymentreports.awardreports.AwardReportTerm;
import org.kuali.kra.award.paymentreports.awardreports.AwardReportTermRuleImpl;
import org.kuali.kra.award.paymentreports.awardreports.GenericAwardReportTerm;
import org.kuali.kra.test.infrastructure.KcUnitTestBase;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.MessageMap;

public class AwardReportTermRuleImplTest
extends KcUnitTestBase {
    AwardReportTermRuleImpl awardReportTermRule;
    AwardReportTerm awardReportTerm;
    List<AwardReportTerm> awardReportTermItems;

    @Override
    @Before
    public void setUp() throws Exception {
        this.awardReportTermRule = new AwardReportTermRuleImpl();
        this.awardReportTerm = this.buildAwardReportTerm();
        this.awardReportTermItems = new ArrayList<AwardReportTerm>();
        GlobalVariables.setMessageMap((MessageMap)new MessageMap());
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.awardReportTermRule = null;
        this.awardReportTerm = null;
        this.awardReportTermItems = null;
    }

    private AwardReportTerm buildAwardReportTerm() {
        AwardReportTerm awardReportTerm = new AwardReportTerm();
        awardReportTerm.setReportCode("5");
        awardReportTerm.setFrequencyCode("5");
        awardReportTerm.setFrequencyBaseCode("5");
        awardReportTerm.setOspDistributionCode("5");
        return awardReportTerm;
    }

    @Test
    public final void testIsUnique() {
        AwardReportTerm awardReportTermItem = new AwardReportTerm();
        awardReportTermItem.setAwardNumber("2");
        awardReportTermItem.setSequenceNumber(Integer.valueOf(2));
        awardReportTermItem.setReportClassCode("5");
        awardReportTermItem.setReportCode("5");
        awardReportTermItem.setFrequencyBaseCode("5");
        awardReportTermItem.setFrequencyCode("5");
        awardReportTermItem.setDueDate(new Date(10000332L));
        this.awardReportTermItems.add(awardReportTermItem);
        awardReportTermItem = new AwardReportTerm();
        awardReportTermItem.setAwardNumber("2");
        awardReportTermItem.setSequenceNumber(Integer.valueOf(2));
        awardReportTermItem.setReportClassCode("5");
        awardReportTermItem.setReportCode("5");
        awardReportTermItem.setFrequencyBaseCode("5");
        awardReportTermItem.setFrequencyCode("5");
        awardReportTermItem.setDueDate(new Date(10000332L));
        Assert.assertFalse((boolean)this.awardReportTermRule.isUnique(this.awardReportTermItems, (GenericAwardReportTerm)awardReportTermItem));
        awardReportTermItem = new AwardReportTerm();
        awardReportTermItem.setAwardNumber("2");
        awardReportTermItem.setSequenceNumber(Integer.valueOf(2));
        awardReportTermItem.setReportClassCode("6");
        awardReportTermItem.setReportCode("5");
        awardReportTermItem.setFrequencyBaseCode("5");
        awardReportTermItem.setFrequencyCode("5");
        awardReportTermItem.setDueDate(new Date(10000332L));
        Assert.assertTrue((boolean)this.awardReportTermRule.isUnique(this.awardReportTermItems, (GenericAwardReportTerm)awardReportTermItem));
    }

    @Test
    public final void testValidAwardReportTerm() {
        Assert.assertTrue((boolean)this.awardReportTermRule.validateRequiredFields((GenericAwardReportTerm)this.awardReportTerm, ""));
    }

    @Test
    public final void testEvaluateRuleForReportCode() {
        this.awardReportTerm.setReportCode(null);
        Assert.assertFalse((boolean)this.awardReportTermRule.validateRequiredFields((GenericAwardReportTerm)this.awardReportTerm, ""));
    }

    @Test
    public final void testEvaluateRuleForFrequency() {
        this.awardReportTerm.setFrequencyCode(null);
        Assert.assertFalse((boolean)this.awardReportTermRule.validateRequiredFields((GenericAwardReportTerm)this.awardReportTerm, ""));
    }

    @Test
    public final void testEvaluateRuleForFrequencyBase() {
        this.awardReportTerm.setFrequencyBaseCode(null);
        Assert.assertFalse((boolean)this.awardReportTermRule.validateRequiredFields((GenericAwardReportTerm)this.awardReportTerm, ""));
    }

    @Test
    public final void testEvaluateRuleForDistribution() {
        this.awardReportTerm.setOspDistributionCode(null);
        Assert.assertFalse((boolean)this.awardReportTermRule.validateRequiredFields((GenericAwardReportTerm)this.awardReportTerm, ""));
    }
}

