/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.paymentreports.awardreports.reporting.service;

import java.sql.Date;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.List;
import org.junit.Test;
import org.kuali.kra.award.AwardFixtureFactory;
import org.kuali.kra.award.document.AwardDocument;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.home.AwardService;
import org.kuali.kra.award.home.AwardServiceImpl;
import org.kuali.kra.award.paymentreports.awardreports.reporting.ReportTracking;
import org.kuali.kra.award.paymentreports.awardreports.reporting.service.ReportTrackingNotification;
import org.kuali.kra.award.paymentreports.awardreports.reporting.service.ReportTrackingNotificationDetails;
import org.kuali.kra.award.paymentreports.awardreports.reporting.service.ReportTrackingNotificationService;
import org.kuali.kra.award.paymentreports.awardreports.reporting.service.ReportTrackingNotificationServiceImpl;
import org.kuali.kra.award.paymentreports.awardreports.reporting.service.SentReportNotification;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.test.infrastructure.KcUnitTestBase;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.DocumentService;

public class ReportTrackingNotificationServiceTest
extends KcUnitTestBase {
    private ReportTrackingNotificationServiceImpl service;
    private BusinessObjectService boService;
    private DocumentService documentService;
    private Long currentTermId = 1L;
    private Award award;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.service = (ReportTrackingNotificationServiceImpl)KraServiceLocator.getService(ReportTrackingNotificationService.class);
        this.boService = (BusinessObjectService)KraServiceLocator.getService(BusinessObjectService.class);
        this.documentService = (DocumentService)KraServiceLocator.getService(DocumentService.class);
        AwardDocument awardDoc = (AwardDocument)this.documentService.getNewDocument(AwardDocument.class);
        this.award = AwardFixtureFactory.createAwardFixture();
        awardDoc.setAward(this.award);
        awardDoc.getDocumentHeader().setDocumentDescription("Testing");
        this.documentService.saveDocument((Document)awardDoc);
        AwardServiceImpl mockAwardService = new AwardServiceImpl(){

            public Award getActiveOrNewestAward(String awardNumber) {
                return ReportTrackingNotificationServiceTest.this.award;
            }
        };
        this.service.setAwardService((AwardService)mockAwardService);
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
    }

    @Test
    public void testRunReportTrackingNotifications() {
        this.boService.save((PersistableBusinessObject)this.getNewReportTracking(this.award, "4", "4", Calendar.getInstance().getTime()));
        Calendar newDate = Calendar.getInstance();
        newDate.add(5, -40);
        this.boService.save((PersistableBusinessObject)this.getNewReportTracking(this.award, "4", "4", newDate.getTime()));
        this.service.getNotifications().clear();
        this.service.getNotifications().add(new ReportTrackingNotification("Test", "401", true, Integer.valueOf(30), Integer.valueOf(30), "4"));
        List details = this.service.runReportTrackingNotifications();
        ReportTrackingNotificationServiceTest.assertEquals((long)1L, (long)details.size());
        ReportTrackingNotificationServiceTest.assertTrue((boolean)((ReportTrackingNotificationDetails)details.get(0)).isNotificationActive());
        ReportTrackingNotificationServiceTest.assertEquals((long)1L, (long)((ReportTrackingNotificationDetails)details.get(0)).getNotificationRecipients());
        ReportTrackingNotificationServiceTest.assertEquals((long)2L, (long)((ReportTrackingNotificationDetails)details.get(0)).getTrackingRecordsFound());
        ReportTrackingNotificationServiceTest.assertEquals((long)1L, (long)((ReportTrackingNotificationDetails)details.get(0)).getTrackingRecordsMatched());
        ReportTrackingNotificationServiceTest.assertEquals((long)2L, (long)((ReportTrackingNotificationDetails)details.get(0)).getNotificationsSent());
        List notificationsSent = (List)this.boService.findAll(SentReportNotification.class);
        ReportTrackingNotificationServiceTest.assertEquals((long)1L, (long)notificationsSent.size());
    }

    @Test
    public void testRunReportTrackingNotificationsPreviouslySent() {
        this.boService.save((PersistableBusinessObject)this.getNewReportTracking(this.award, "4", "4", Calendar.getInstance().getTime()));
        Calendar newDate = Calendar.getInstance();
        newDate.add(5, -40);
        this.boService.save((PersistableBusinessObject)this.getNewReportTracking(this.award, "4", "4", newDate.getTime()));
        this.service.getNotifications().clear();
        this.service.getNotifications().add(new ReportTrackingNotification("Test", "401", true, Integer.valueOf(30), Integer.valueOf(30), "4"));
        List details = this.service.runReportTrackingNotifications();
        List notificationsSent = (List)this.boService.findAll(SentReportNotification.class);
        ReportTrackingNotificationServiceTest.assertEquals((long)1L, (long)notificationsSent.size());
        details = this.service.runReportTrackingNotifications();
        ReportTrackingNotificationServiceTest.assertEquals((long)1L, (long)details.size());
        ReportTrackingNotificationServiceTest.assertTrue((boolean)((ReportTrackingNotificationDetails)details.get(0)).isNotificationActive());
        ReportTrackingNotificationServiceTest.assertEquals((long)1L, (long)((ReportTrackingNotificationDetails)details.get(0)).getNotificationRecipients());
        ReportTrackingNotificationServiceTest.assertEquals((long)2L, (long)((ReportTrackingNotificationDetails)details.get(0)).getTrackingRecordsFound());
        ReportTrackingNotificationServiceTest.assertEquals((long)0L, (long)((ReportTrackingNotificationDetails)details.get(0)).getTrackingRecordsMatched());
        ReportTrackingNotificationServiceTest.assertEquals((long)0L, (long)((ReportTrackingNotificationDetails)details.get(0)).getNotificationsSent());
    }

    @Test
    public void testDateBarriers() {
        this.boService.save((PersistableBusinessObject)this.getNewReportTracking(this.award, "4", "4", Calendar.getInstance().getTime()));
        Calendar newDate = Calendar.getInstance();
        newDate.add(6, -29);
        this.boService.save((PersistableBusinessObject)this.getNewReportTracking(this.award, "4", "4", newDate.getTime()));
        newDate = Calendar.getInstance();
        newDate.add(6, -30);
        this.boService.save((PersistableBusinessObject)this.getNewReportTracking(this.award, "4", "4", newDate.getTime()));
        newDate = Calendar.getInstance();
        newDate.add(6, -59);
        this.boService.save((PersistableBusinessObject)this.getNewReportTracking(this.award, "4", "4", newDate.getTime()));
        newDate = Calendar.getInstance();
        newDate.add(6, -60);
        this.boService.save((PersistableBusinessObject)this.getNewReportTracking(this.award, "4", "4", newDate.getTime()));
        newDate = Calendar.getInstance();
        newDate.add(6, 10);
        this.boService.save((PersistableBusinessObject)this.getNewReportTracking(this.award, "4", "4", newDate.getTime()));
        newDate = Calendar.getInstance();
        newDate.add(6, 30);
        this.boService.save((PersistableBusinessObject)this.getNewReportTracking(this.award, "4", "4", newDate.getTime()));
        newDate = Calendar.getInstance();
        newDate.add(6, 60);
        this.boService.save((PersistableBusinessObject)this.getNewReportTracking(this.award, "4", "4", newDate.getTime()));
        newDate = Calendar.getInstance();
        newDate.add(6, 61);
        this.boService.save((PersistableBusinessObject)this.getNewReportTracking(this.award, "4", "4", newDate.getTime()));
        this.service.getNotifications().clear();
        this.service.getNotifications().add(new ReportTrackingNotification("Test", "401", true, Integer.valueOf(30), Integer.valueOf(30), "4"));
        this.service.getNotifications().add(new ReportTrackingNotification("Test", "402", true, Integer.valueOf(60), Integer.valueOf(30), "4"));
        this.service.getNotifications().add(new ReportTrackingNotification("Test", "403", false, Integer.valueOf(30), Integer.valueOf(30), "4"));
        this.service.getNotifications().add(new ReportTrackingNotification("Test", "404", false, Integer.valueOf(60), Integer.valueOf(30), "4"));
        List details = this.service.runReportTrackingNotifications();
        List notificationsSent = (List)this.boService.findAll(SentReportNotification.class);
        ReportTrackingNotificationServiceTest.assertEquals((long)6L, (long)notificationsSent.size());
        ReportTrackingNotificationServiceTest.assertEquals((long)4L, (long)details.size());
        ReportTrackingNotificationServiceTest.assertEquals((Object)"401", (Object)((ReportTrackingNotificationDetails)details.get(0)).getActionCode());
        ReportTrackingNotificationServiceTest.assertEquals((long)9L, (long)((ReportTrackingNotificationDetails)details.get(0)).getTrackingRecordsFound());
        ReportTrackingNotificationServiceTest.assertEquals((long)2L, (long)((ReportTrackingNotificationDetails)details.get(0)).getTrackingRecordsMatched());
        ReportTrackingNotificationServiceTest.assertEquals((long)2L, (long)((ReportTrackingNotificationDetails)details.get(0)).getNotificationsSent());
        ReportTrackingNotificationServiceTest.assertEquals((Object)"402", (Object)((ReportTrackingNotificationDetails)details.get(1)).getActionCode());
        ReportTrackingNotificationServiceTest.assertEquals((long)9L, (long)((ReportTrackingNotificationDetails)details.get(1)).getTrackingRecordsFound());
        ReportTrackingNotificationServiceTest.assertEquals((long)1L, (long)((ReportTrackingNotificationDetails)details.get(1)).getTrackingRecordsMatched());
        ReportTrackingNotificationServiceTest.assertEquals((long)2L, (long)((ReportTrackingNotificationDetails)details.get(1)).getNotificationsSent());
        ReportTrackingNotificationServiceTest.assertEquals((Object)"403", (Object)((ReportTrackingNotificationDetails)details.get(2)).getActionCode());
        ReportTrackingNotificationServiceTest.assertEquals((long)9L, (long)((ReportTrackingNotificationDetails)details.get(2)).getTrackingRecordsFound());
        ReportTrackingNotificationServiceTest.assertEquals((long)2L, (long)((ReportTrackingNotificationDetails)details.get(2)).getTrackingRecordsMatched());
        ReportTrackingNotificationServiceTest.assertEquals((long)2L, (long)((ReportTrackingNotificationDetails)details.get(2)).getNotificationsSent());
        ReportTrackingNotificationServiceTest.assertEquals((Object)"404", (Object)((ReportTrackingNotificationDetails)details.get(3)).getActionCode());
        ReportTrackingNotificationServiceTest.assertEquals((long)9L, (long)((ReportTrackingNotificationDetails)details.get(3)).getTrackingRecordsFound());
        ReportTrackingNotificationServiceTest.assertEquals((long)1L, (long)((ReportTrackingNotificationDetails)details.get(3)).getTrackingRecordsMatched());
        ReportTrackingNotificationServiceTest.assertEquals((long)2L, (long)((ReportTrackingNotificationDetails)details.get(3)).getNotificationsSent());
    }

    public ReportTracking getNewReportTracking(Award award, String reportClassCode, String frequencyBaseCode, java.util.Date dueDate) {
        ReportTracking result = new ReportTracking();
        Long l = this.currentTermId;
        Long l2 = this.currentTermId = Long.valueOf(this.currentTermId + 1L);
        result.setAwardReportTermId(l);
        result.setAwardNumber(award.getAwardNumber());
        result.setPiName("Quickstart Quickstart");
        result.setLeadUnitNumber("000001");
        result.setReportClassCode(reportClassCode);
        result.setReportCode("4");
        result.setSponsorCode("4");
        result.setTitle("Testing");
        result.setLastUpdateUser("quickstart");
        result.setLastUpdateDate(new Timestamp(Calendar.getInstance().getTimeInMillis()));
        result.setUpdateUser("quickstart");
        result.setUpdateTimestamp(new Timestamp(Calendar.getInstance().getTimeInMillis()));
        result.setFrequencyBaseCode(frequencyBaseCode);
        result.setDueDate(new Date(dueDate.getTime()));
        return result;
    }
}

