/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.paymentreports.closeout;

import java.util.ArrayList;
import java.util.List;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.award.paymentreports.closeout.AwardCloseout;
import org.kuali.kra.award.paymentreports.closeout.AwardCloseoutRuleImpl;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.MessageMap;

public class AwardCloseoutRuleImplTest {
    public static final String CLOSE_OUT_REPORT_CODE_A = "A";
    public static final String CLOSE_OUT_REPORT_CODE_B = "B";
    public static final String CLOSE_OUT_REPORT_NAME = "FINANCIAL";
    AwardCloseoutRuleImpl awardCloseoutRuleImpl;
    AwardCloseout newCloseoutItem;
    AwardCloseout closeoutItem;
    List<AwardCloseout> closeoutItems;

    @Before
    public void setUp() throws Exception {
        this.awardCloseoutRuleImpl = new AwardCloseoutRuleImpl();
        this.newCloseoutItem = new AwardCloseout();
        this.closeoutItem = new AwardCloseout();
        this.closeoutItem.setCloseoutReportCode(CLOSE_OUT_REPORT_CODE_A);
        this.closeoutItem.setCloseoutReportName(CLOSE_OUT_REPORT_NAME);
        this.closeoutItems = new ArrayList<AwardCloseout>();
        this.closeoutItems.add(this.closeoutItem);
        GlobalVariables.setMessageMap((MessageMap)new MessageMap());
    }

    @After
    public void tearDown() throws Exception {
        this.awardCloseoutRuleImpl = null;
        this.closeoutItem = null;
        this.newCloseoutItem = null;
        this.closeoutItems = null;
        GlobalVariables.setMessageMap(null);
    }

    @Test
    public final void testIsUniqueSuccess() {
        this.newCloseoutItem.setCloseoutReportCode(CLOSE_OUT_REPORT_CODE_B);
        this.newCloseoutItem.setCloseoutReportName(CLOSE_OUT_REPORT_NAME);
        Assert.assertTrue((boolean)this.awardCloseoutRuleImpl.isUnique(this.closeoutItems, this.newCloseoutItem));
    }

    @Test
    public final void testIsUniqueFailure() {
        this.newCloseoutItem.setCloseoutReportCode(CLOSE_OUT_REPORT_CODE_A);
        this.newCloseoutItem.setCloseoutReportName(CLOSE_OUT_REPORT_NAME);
        Assert.assertFalse((boolean)this.awardCloseoutRuleImpl.isUnique(this.closeoutItems, this.newCloseoutItem));
    }

    @Test
    public final void testAreRequiredFieldsCompleteFailure() {
        Assert.assertFalse((boolean)this.awardCloseoutRuleImpl.areRequiredFieldsComplete(this.newCloseoutItem));
    }

    @Test
    public final void testAreRequiredFieldsCompleteSuccess() {
        Assert.assertTrue((boolean)this.awardCloseoutRuleImpl.areRequiredFieldsComplete(this.closeoutItem));
    }
}

