/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.paymentreports.closeout;

import java.sql.Date;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JMock;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kuali.kra.award.paymentreports.Frequency;
import org.kuali.kra.award.paymentreports.Report;
import org.kuali.kra.award.paymentreports.awardreports.AwardReportTerm;
import org.kuali.kra.award.paymentreports.closeout.AwardCloseoutServiceImpl;

@RunWith(value=JMock.class)
public class AwardCloseoutServiceImplTest {
    public static final String REPORT_CLASS_CODE_FINANCIAL_REPORT = "1";
    public static final String REPORT_CLASS_CODE_PATENT = "3";
    public static final String REPORT_CLASS_CODE_USER_DEFINED = "UD";
    AwardCloseoutServiceImpl service;
    List<AwardReportTerm> awardReportTermItems;
    Map<String, Object> closeoutDueDates;
    AwardReportTerm newAwardReportTerm;
    Report newReport;
    Frequency newFrequency;
    java.util.Date dateCalculatedUsingFinalInvoiceDue;
    private Mockery context = new JUnit4Mockery();

    @Before
    public void setUp() throws Exception {
        this.service = new AwardCloseoutServiceImpl();
        this.awardReportTermItems = new ArrayList<AwardReportTerm>();
        this.closeoutDueDates = new HashMap<String, Object>();
        this.newAwardReportTerm = new AwardReportTerm();
        this.newReport = new Report();
        this.newFrequency = new Frequency();
        this.dateCalculatedUsingFinalInvoiceDue = new java.util.Date();
    }

    @After
    public void tearDown() throws Exception {
        this.service = null;
        this.awardReportTermItems = null;
        this.closeoutDueDates = null;
        this.newAwardReportTerm = null;
        this.newReport = null;
        this.newFrequency = null;
    }

    @Test
    public final void testUpdateCloseoutDueDate_allDueDatesAreEqual_And_2DatesAreEqual() {
        this.service.updateCloseoutDueDate(this.closeoutDueDates, new java.util.Date(10000L), true, REPORT_CLASS_CODE_FINANCIAL_REPORT);
        Assert.assertEquals((Object)new java.util.Date(10000L), (Object)this.closeoutDueDates.get(REPORT_CLASS_CODE_FINANCIAL_REPORT));
    }

    @Test
    public final void testUpdateCloseoutDueDate_allDueDatesAreEqual_And_2DatesAreNotEqual() {
        this.service.updateCloseoutDueDate(this.closeoutDueDates, new java.util.Date(10000L), false, REPORT_CLASS_CODE_FINANCIAL_REPORT);
        Assert.assertEquals((Object)"M", (Object)this.closeoutDueDates.get(REPORT_CLASS_CODE_FINANCIAL_REPORT));
    }

    @Test
    public final void testUpdateCloseoutDueDate_allDueDatesAreNotEqual_And_2DatesAreEqual() {
        this.service.updateCloseoutDueDate(this.closeoutDueDates, new java.util.Date(10000L), false, REPORT_CLASS_CODE_FINANCIAL_REPORT);
        Assert.assertEquals((Object)"M", (Object)this.closeoutDueDates.get(REPORT_CLASS_CODE_FINANCIAL_REPORT));
    }

    @Test
    public final void testUpdateCloseoutDueDate_allDueDatesAreNotEqual_And_2DatesAreNotEqual() {
        this.service.updateCloseoutDueDate(this.closeoutDueDates, new java.util.Date(10000L), false, REPORT_CLASS_CODE_FINANCIAL_REPORT);
        Assert.assertEquals((Object)"M", (Object)this.closeoutDueDates.get(REPORT_CLASS_CODE_FINANCIAL_REPORT));
    }

    @Test
    public final void testFilterAwardReportTerms_ReportClassMatches_FinalFlagTrue() {
        this.newAwardReportTerm.setReportClassCode(REPORT_CLASS_CODE_FINANCIAL_REPORT);
        this.newReport.setFinalReportFlag(true);
        this.newAwardReportTerm.setReport(this.newReport);
        this.awardReportTermItems.add(this.newAwardReportTerm);
        Assert.assertEquals((long)1L, (long)this.service.filterAwardReportTerms(this.awardReportTermItems, REPORT_CLASS_CODE_FINANCIAL_REPORT).size());
    }

    @Test
    public final void testFilterAwardReportTerms_ReportClassDoesNotMatch_FinalFlagTrue() {
        this.newAwardReportTerm.setReportClassCode(REPORT_CLASS_CODE_PATENT);
        this.newReport.setFinalReportFlag(true);
        this.newAwardReportTerm.setReport(this.newReport);
        this.awardReportTermItems.add(this.newAwardReportTerm);
        Assert.assertEquals((long)0L, (long)this.service.filterAwardReportTerms(this.awardReportTermItems, REPORT_CLASS_CODE_FINANCIAL_REPORT).size());
    }

    @Test
    public final void testFilterAwardReportTerms_ReportClassMatches_FinalFlagFalse() {
        this.newAwardReportTerm.setReportClassCode(REPORT_CLASS_CODE_FINANCIAL_REPORT);
        this.newReport.setFinalReportFlag(false);
        this.newAwardReportTerm.setReport(this.newReport);
        this.awardReportTermItems.add(this.newAwardReportTerm);
        Assert.assertEquals((long)0L, (long)this.service.filterAwardReportTerms(this.awardReportTermItems, REPORT_CLASS_CODE_FINANCIAL_REPORT).size());
    }

    @Test
    public final void testFilterAwardReportTerms_ReportClassDoesNotMatch_FinalFlagFalse() {
        this.newAwardReportTerm.setReportClassCode(REPORT_CLASS_CODE_PATENT);
        this.newReport.setFinalReportFlag(false);
        this.newAwardReportTerm.setReport(this.newReport);
        this.awardReportTermItems.add(this.newAwardReportTerm);
        Assert.assertEquals((long)0L, (long)this.service.filterAwardReportTerms(this.awardReportTermItems, REPORT_CLASS_CODE_FINANCIAL_REPORT).size());
    }

    @Test
    public final void testGetCalculatedDueDate_NumberOfDaysAreZero_NumberOfMonthsAreZero() {
        this.getCalculatedDueDatTesting(0, 0, 0, 0);
    }

    @Test
    public final void testGetCalculatedDueDate_NumberOfDaysAreZero_NumberOfMonthsAreNotZero() {
        this.getCalculatedDueDatTesting(0, 5, 0, 0);
    }

    @Test
    public final void testGetCalculatedDueDate_NumberOfDaysAreNotZero_NumberOfMonthsAreZero() {
        this.getCalculatedDueDatTesting(15, 0, 0, 0);
    }

    @Test
    public final void testGetCalculatedDueDate_NumberOfDaysAreNotZero_NumberOfMonthsAreNotZero() {
        this.getCalculatedDueDatTesting(15, 5, 0, 0);
    }

    @Test
    public final void testGetCalculatedDueDate_NumberOfAdvanceDaysAreNotZero_NumberOfAdvanceMonthsAreNotZero() {
        this.getCalculatedDueDatTesting(0, 0, 15, 5);
    }

    @Test
    public final void testGetCalculatedDueDate_NumberOfAdvanceDaysAreNotZero_NumberOfAdvanceMonthsAreZero() {
        this.getCalculatedDueDatTesting(0, 0, 15, 0);
    }

    @Test
    public final void testGetCalculatedDueDate_NumberOfAdvanceDaysAreZero_NumberOfAdvanceMonthsAreNotZero() {
        this.getCalculatedDueDatTesting(0, 0, 0, 5);
    }

    public void getCalculatedDueDatTesting(int numberOfDays, int numberOfMonths, int numberOfAdvanceDays, int numberOfAdvanceMonths) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTimeInMillis(1000000L);
        this.newFrequency.setNumberOfDays(Integer.valueOf(numberOfDays));
        this.newFrequency.setNumberOfMonths(Integer.valueOf(numberOfMonths));
        this.newFrequency.setAdvanceNumberOfDays(Integer.valueOf(numberOfAdvanceDays));
        this.newFrequency.setAdvanceNumberOfMonths(Integer.valueOf(numberOfAdvanceMonths));
        this.newAwardReportTerm.setFrequency(this.newFrequency);
        ((Calendar)calendar).add(2, numberOfMonths);
        ((Calendar)calendar).add(6, numberOfDays);
        ((Calendar)calendar).add(2, -numberOfAdvanceMonths);
        ((Calendar)calendar).add(6, -numberOfAdvanceDays);
        java.util.Date calculatedDate = this.service.getCalculatedDueDate(new Date(calendar.getTimeInMillis()), this.newAwardReportTerm, (Calendar)calendar);
        Assert.assertEquals((Object)calendar.getTime(), (Object)calculatedDate);
    }
}

