/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.paymentreports.paymentschedule;

import java.sql.Date;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.paymentreports.paymentschedule.AwardPaymentSchedule;
import org.kuali.kra.award.paymentreports.paymentschedule.AwardPaymentScheduleRuleImpl;
import org.kuali.kra.rules.SoftError;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.MessageMap;

public class AwardPaymentScheduleRuleTest {
    private static final Calendar calendar = new GregorianCalendar();
    private AwardPaymentScheduleRuleImpl awardPaymentScheduleRule;
    private Award award;

    @Before
    public void setUp() throws Exception {
        this.awardPaymentScheduleRule = this.prepareTestReadyAwardPaymentScheduleRuleImpl();
        this.award = new Award();
        this.award.setAwardId(Long.valueOf(1L));
        this.award.setAwardNumber("X1000");
        this.award.setSequenceNumber(Integer.valueOf(1));
        calendar.set(2009, 4, 1);
        GlobalVariables.setMessageMap((MessageMap)new MessageMap());
    }

    @After
    public void tearDown() {
        this.award = null;
        this.awardPaymentScheduleRule = null;
    }

    @Test
    public void testIsUnique() {
        AwardPaymentSchedule paymentScheduleItem1 = this.createPaymentScheduleItem(new Date(calendar.getTimeInMillis()), this.award.getAwardNumber(), this.award.getSequenceNumber());
        AwardPaymentSchedule paymentScheduleItem2 = this.createPaymentScheduleItem(new Date(calendar.getTimeInMillis()), this.award.getAwardNumber(), this.award.getSequenceNumber());
        this.checkAddingNewItemToEmptyList(paymentScheduleItem1);
        this.award.add(paymentScheduleItem1);
        this.checkExistingEntriesDoesntTriggerErrorOnSave();
        this.addPaymentScheduleToAward(paymentScheduleItem1, paymentScheduleItem2);
        this.checkAddingDuplicateToCollection();
        this.checkEditingItemResultingInDuplicate(paymentScheduleItem2);
    }

    private void addPaymentScheduleToAward(AwardPaymentSchedule paymentScheduleItem1, AwardPaymentSchedule paymentScheduleItem2) {
        paymentScheduleItem1.setAwardPaymentScheduleId(Long.valueOf(1L));
        this.award.add(paymentScheduleItem1);
        paymentScheduleItem2.setAwardPaymentScheduleId(Long.valueOf(2L));
        this.award.add(paymentScheduleItem2);
    }

    private void checkAddingDuplicateToCollection() {
        AwardPaymentSchedule item1Duplicate = this.createPaymentScheduleItem(new Date(calendar.getTimeInMillis()), this.award.getAwardNumber(), this.award.getSequenceNumber());
        Assert.assertFalse((boolean)this.awardPaymentScheduleRule.isUnique(this.award.getPaymentScheduleItems(), item1Duplicate));
    }

    private void checkAddingNewItemToEmptyList(AwardPaymentSchedule paymentScheduleItem1) {
        Assert.assertTrue((boolean)this.awardPaymentScheduleRule.isUnique(new ArrayList(), paymentScheduleItem1));
    }

    private void checkExistingEntriesDoesntTriggerErrorOnSave() {
        List items = this.award.getPaymentScheduleItems();
        for (AwardPaymentSchedule item : items) {
            Assert.assertTrue((boolean)this.awardPaymentScheduleRule.isUnique(items, item));
        }
    }

    private void checkEditingItemResultingInDuplicate(AwardPaymentSchedule paymentScheduleItem2) {
        Assert.assertFalse((boolean)this.awardPaymentScheduleRule.isUnique(this.award.getPaymentScheduleItems(), paymentScheduleItem2));
    }

    private AwardPaymentSchedule createPaymentScheduleItem(Date dueDate, String awardNumber, Integer sequenceNumber) {
        return new AwardPaymentSchedule(dueDate, awardNumber, sequenceNumber);
    }

    private AwardPaymentScheduleRuleImpl prepareTestReadyAwardPaymentScheduleRuleImpl() {
        AwardPaymentScheduleRuleImpl approvedEquipmentRule = new AwardPaymentScheduleRuleImpl(){
            private Map<String, Collection<SoftError>> softErrors = new HashMap<String, Collection<SoftError>>();

            public Map<String, Collection<SoftError>> getSoftErrors() {
                return this.softErrors;
            }
        };
        return approvedEquipmentRule;
    }
}

