/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.paymentreports.specialapproval.approvedequipment;

import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Test;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.paymentreports.specialapproval.approvedequipment.ApprovedEquipmentBean;
import org.kuali.kra.award.paymentreports.specialapproval.approvedequipment.AwardApprovedEquipment;
import org.kuali.kra.award.paymentreports.specialapproval.approvedequipment.EquipmentCapitalizationMinimumLoader;
import org.kuali.kra.award.paymentreports.specialapproval.approvedequipment.SpecialApprovalBean;
import org.kuali.rice.krad.rules.rule.event.KualiDocumentEvent;
import org.kuali.rice.krad.service.KualiRuleService;

public class ApprovedEquipmentBeanTest {
    private static final String MODEL_NAME = "Model";
    private static final String VENDOR_NAME = "Vendor";
    private static final String ITEM_NAME = "Item";
    private static final double INSTITUTION_MINIMUM_AMOUNT = 50.0;
    private static final double FEDERAL_MINIMUM_AMOUNT = 100.0;
    private Mockery context;
    private KualiRuleService ruleService;
    private Award award;
    private SpecialApprovalBean bean;
    private AwardApprovedEquipment equipmentItem;

    @Test
    public void testDummy() {
    }

    private void checkAddingEquipmentItem(ApprovedEquipmentBean bean, AwardApprovedEquipment item, boolean expectedOutcome) {
        bean.setNewAwardApprovedEquipment(item);
        bean.setRuleService(this.ruleService);
        this.setExpectation(this.ruleService, (KualiDocumentEvent)bean.generateAddEvent(), expectedOutcome);
        bean.addApprovedEquipmentItem();
        this.context.assertIsSatisfied();
    }

    private KualiRuleService getRuleService() {
        return (KualiRuleService)this.context.mock(KualiRuleService.class);
    }

    private void setExpectation(final KualiRuleService ruleService, final KualiDocumentEvent event, final boolean outcome) {
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((KualiRuleService)this.one(ruleService)).applyRules(event);
                this.will(1.returnValue((Object)outcome));
            }
        });
    }

    private EquipmentCapitalizationMinimumLoader getCapitalizationMinimumLoader() {
        EquipmentCapitalizationMinimumLoader loader = new EquipmentCapitalizationMinimumLoader(){

            protected double getFederalCapitalizationMinimum() {
                return 100.0;
            }

            protected double getInstitutionCapitalizationMinimum() {
                return 50.0;
            }
        };
        return loader;
    }
}

