/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.paymentreports.specialapproval.approvedequipment;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.award.paymentreports.specialapproval.approvedequipment.EquipmentCapitalizationMinimumLoader;
import org.kuali.kra.test.infrastructure.KcUnitTestBase;

public class AwardApprovedEquipmentRuleHelperIntegrationTest
extends KcUnitTestBase {
    private static final double DELTA = 0.001;
    private static final double INSTITUTION_MINIMUM = 0.0;
    private static final double FEDERAL_MINIMUM = 0.0;
    private static final String FED_PARM = "federalCapitalizationMinimum";
    private static final String INST_PARM = "institutionCapitalizationMinimum";
    private EquipmentCapitalizationMinimumLoader helper;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.helper = new EquipmentCapitalizationMinimumLoader();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.helper = null;
        super.tearDown();
    }

    @Test
    public void testGettingValueFromParameter() {
        this.checkValuefromParm(FED_PARM, 0.0);
        this.checkValuefromParm(INST_PARM, 0.0);
    }

    @Test
    public void testGettingFederalMinimum() {
        Assert.assertEquals((double)0.0, (double)this.helper.getFederalCapitalizationMinimum(), (double)0.001);
    }

    @Test
    public void testGettingInstitutionMinimum() {
        Assert.assertEquals((double)0.0, (double)this.helper.getInstitutionCapitalizationMinimum(), (double)0.001);
    }

    private void checkValuefromParm(String parmName, double parmValue) {
        double value = this.helper.getValueFromParameter(parmName);
        Assert.assertEquals((double)parmValue, (double)value, (double)0.001);
    }
}

