/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.paymentreports.specialapproval.approvedequipment;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.award.paymentreports.specialapproval.approvedequipment.EquipmentCapitalizationMinimumLoader;
import org.kuali.rice.core.api.config.ConfigurationException;

public class AwardApprovedEquipmentRuleHelperTest {
    private static final String INVALID_NUMBER_FORMAT = "$1,234.56";
    private static final double DELTA = 0.001;
    private static final String INSTITUTION_MINIMUM = "50.00";
    private static final String FEDERAL_MINIMUM = "100.00";
    private static final String FED_PARM = "federalCapitalizationMinimum";
    private static final String INST_PARM = "institutionCapitalizationMinimum";
    private EquipmentCapitalizationMinimumLoader helper;

    @Before
    public void setUp() {
        this.helper = new EquipmentCapitalizationMinimumLoader(){

            protected String fetchParameterValue(String parmName) {
                return parmName.equals(AwardApprovedEquipmentRuleHelperTest.FED_PARM) ? AwardApprovedEquipmentRuleHelperTest.FEDERAL_MINIMUM : AwardApprovedEquipmentRuleHelperTest.INSTITUTION_MINIMUM;
            }
        };
    }

    @After
    public void tearDown() {
        this.helper = null;
    }

    @Test(expected=ConfigurationException.class)
    public void testGettingValueFromParameter_FederalMinimumNull() {
        this.helper = new EquipmentCapitalizationMinimumLoader(){

            protected String fetchParameterValue(String parmName) {
                return parmName.equals(AwardApprovedEquipmentRuleHelperTest.FED_PARM) ? null : AwardApprovedEquipmentRuleHelperTest.INSTITUTION_MINIMUM;
            }
        };
        this.helper.getValueFromParameter(FED_PARM);
    }

    @Test(expected=ConfigurationException.class)
    public void testGettingValueFromParameter_InstitutionMinimumNull() {
        this.helper = new EquipmentCapitalizationMinimumLoader(){

            protected String fetchParameterValue(String parmName) {
                return parmName.equals(AwardApprovedEquipmentRuleHelperTest.FED_PARM) ? AwardApprovedEquipmentRuleHelperTest.FEDERAL_MINIMUM : null;
            }
        };
        this.helper.getValueFromParameter(INST_PARM);
    }

    @Test(expected=ConfigurationException.class)
    public void testGettingValueFromParameter_FederalMinimumNotNumber() {
        this.helper = new EquipmentCapitalizationMinimumLoader(){

            protected String fetchParameterValue(String parmName) {
                return parmName.equals(AwardApprovedEquipmentRuleHelperTest.FED_PARM) ? AwardApprovedEquipmentRuleHelperTest.INVALID_NUMBER_FORMAT : AwardApprovedEquipmentRuleHelperTest.INSTITUTION_MINIMUM;
            }
        };
        this.helper.getValueFromParameter(FED_PARM);
    }

    @Test(expected=ConfigurationException.class)
    public void testGettingValueFromParameter_InstitutionMinimumNotNumber() {
        this.helper = new EquipmentCapitalizationMinimumLoader(){

            protected String fetchParameterValue(String parmName) {
                return parmName.equals(AwardApprovedEquipmentRuleHelperTest.FED_PARM) ? AwardApprovedEquipmentRuleHelperTest.FEDERAL_MINIMUM : AwardApprovedEquipmentRuleHelperTest.INVALID_NUMBER_FORMAT;
            }
        };
        this.helper.getValueFromParameter(INST_PARM);
    }

    @Test
    public void testGettingValueFromParameter() {
        this.checkValuefromParm(FED_PARM, FEDERAL_MINIMUM);
        this.checkValuefromParm(INST_PARM, INSTITUTION_MINIMUM);
    }

    private void checkValuefromParm(String parmName, String parmValue) {
        double value = this.helper.getValueFromParameter(parmName);
        Assert.assertEquals((double)Double.parseDouble(parmValue), (double)value, (double)0.001);
    }
}

