/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.paymentreports.specialapproval.approvedequipment;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.award.AwardForm;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.paymentreports.specialapproval.approvedequipment.AwardApprovedEquipment;
import org.kuali.kra.award.paymentreports.specialapproval.approvedequipment.AwardApprovedEquipmentRuleImpl;
import org.kuali.kra.award.paymentreports.specialapproval.approvedequipment.MinimumCapitalizationInfo;
import org.kuali.kra.rules.SoftError;
import org.kuali.kra.test.infrastructure.KcUnitTestBase;
import org.kuali.rice.kns.util.KNSGlobalVariables;
import org.kuali.rice.kns.web.struts.form.KualiForm;
import org.kuali.rice.krad.UserSession;
import org.kuali.rice.krad.util.GlobalVariables;

public class AwardApprovedEquipmentRuleIntegrationTest
extends KcUnitTestBase {
    private static final double ONE_PENNY = 0.01;
    private static final double FEDERAL_MIN_AMOUNT = 100.0;
    private static final double INSTITUTE_MIN_AMOUNT = 50.0;
    private static final String MIN_AMOUNT_TEXT = "50.00";
    private static final String WIDGET = "Widget";
    private static final String MODEL = "Model 1001";
    private static final String VENDOR = "WidgetVendor";
    private static final String ERROR_KEY = "approvedEquipmentItems";
    private AwardApprovedEquipmentRuleImpl approvedEquipmentRule;
    private Award award;
    private MinimumCapitalizationInfo minimumCapitalizationInfo;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        GlobalVariables.setUserSession((UserSession)new UserSession("quickstart"));
        this.approvedEquipmentRule = new AwardApprovedEquipmentRuleImpl();
        String requirement = "Institution";
        this.minimumCapitalizationInfo = new MinimumCapitalizationInfo(requirement, 50.0, 100.0, 50.0);
        this.award = new Award();
        this.award.setAwardId(Long.valueOf(1L));
        this.award.setAwardNumber("X1000");
        this.award.setSequenceNumber(Integer.valueOf(1));
        KNSGlobalVariables.setKualiForm((KualiForm)new AwardForm());
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.minimumCapitalizationInfo = null;
        this.award = null;
        this.approvedEquipmentRule = null;
        GlobalVariables.setUserSession(null);
        super.tearDown();
    }

    @Test
    public void testValidatingAmount() throws Exception {
        AwardApprovedEquipment equipmentItem = this.createEquipmentItem(VENDOR, MODEL, WIDGET, -1.0);
        this.approvedEquipmentRule.isAmountValid(ERROR_KEY, equipmentItem, this.minimumCapitalizationInfo);
        Assert.assertEquals((long)1L, (long)this.getSoftErrors().size());
        equipmentItem.setAmount(0.0);
        this.approvedEquipmentRule.isAmountValid(ERROR_KEY, equipmentItem, this.minimumCapitalizationInfo);
        Assert.assertEquals((long)1L, (long)this.getSoftErrors().size());
        equipmentItem.setAmount(49.99);
        this.approvedEquipmentRule.isAmountValid(ERROR_KEY, equipmentItem, this.minimumCapitalizationInfo);
        List<SoftError> errors = this.getSoftErrors();
        Assert.assertEquals((long)1L, (long)errors.size());
        Assert.assertEquals((Object)MIN_AMOUNT_TEXT, (Object)errors.get(0).getErrorParms()[0]);
        equipmentItem.setAmount(50.0);
        this.approvedEquipmentRule.isAmountValid(ERROR_KEY, equipmentItem, this.minimumCapitalizationInfo);
        Assert.assertEquals((long)1L, (long)this.getSoftErrors().size());
        equipmentItem.setAmount(100.0);
        this.approvedEquipmentRule.isAmountValid(ERROR_KEY, equipmentItem, this.minimumCapitalizationInfo);
        Assert.assertEquals((long)0L, (long)this.getSoftErrors().size());
    }

    private List<SoftError> getSoftErrors() {
        Map softMessageMap = ((AwardForm)KNSGlobalVariables.getKualiForm()).getSoftErrors();
        Collection errors = softMessageMap != null ? (Collection)softMessageMap.get(ERROR_KEY) : null;
        return errors != null ? new ArrayList<SoftError>(errors) : new ArrayList();
    }

    private AwardApprovedEquipment createEquipmentItem(String vendor, String model, String item, double value) {
        return new AwardApprovedEquipment(vendor, model, item, value);
    }
}

