/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.paymentreports.specialapproval.approvedequipment;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.paymentreports.specialapproval.approvedequipment.AwardApprovedEquipment;
import org.kuali.kra.award.paymentreports.specialapproval.approvedequipment.AwardApprovedEquipmentRuleImpl;
import org.kuali.kra.award.paymentreports.specialapproval.approvedequipment.MinimumCapitalizationInfo;
import org.kuali.kra.rules.SoftError;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.MessageMap;

public class AwardApprovedEquipmentRuleTest {
    private static final double ONE_PENNY = 0.01;
    private static final double AMOUNT1 = 200.0;
    private static final double AMOUNT2 = 100.0;
    private static final String AMOUNT2_TEXT = "100.00";
    private static final String WIDGET1 = "Widget1";
    private static final String WIDGET2 = "Widget2";
    private static final String MODEL = "Model 1001";
    private static final String VENDOR = "WidgetVendor";
    private AwardApprovedEquipmentRuleImpl approvedEquipmentRule;
    private Award award;
    private MinimumCapitalizationInfo minimumCapitalizationInfo;

    @Before
    public void setUp() throws Exception {
        this.approvedEquipmentRule = this.prepareTestReadyAwardApprovedEquipmentRule();
        this.award = new Award();
        this.award.setAwardId(Long.valueOf(1L));
        this.award.setAwardNumber("X1000");
        this.award.setSequenceNumber(Integer.valueOf(1));
        String requirement = "Institution";
        this.minimumCapitalizationInfo = new MinimumCapitalizationInfo(requirement, 100.0, 200.0, 100.0);
        GlobalVariables.setMessageMap((MessageMap)new MessageMap());
    }

    @After
    public void tearDown() throws Exception {
        this.minimumCapitalizationInfo = null;
        this.award = null;
        this.approvedEquipmentRule = null;
    }

    @Test
    public void testRequiredFieldPresent() {
        AwardApprovedEquipment equipmentItem = this.createEquipmentItem(VENDOR, MODEL, WIDGET1, 200.0);
        Assert.assertTrue((boolean)this.approvedEquipmentRule.areRequiredFieldsComplete(equipmentItem));
        equipmentItem.setVendor(null);
        Assert.assertTrue((boolean)this.approvedEquipmentRule.areRequiredFieldsComplete(equipmentItem));
        equipmentItem.setModel(null);
        Assert.assertTrue((boolean)this.approvedEquipmentRule.areRequiredFieldsComplete(equipmentItem));
        equipmentItem.setItem(null);
        Assert.assertFalse((boolean)this.approvedEquipmentRule.areRequiredFieldsComplete(equipmentItem));
        equipmentItem.setItem(WIDGET1);
        equipmentItem.setAmount(null);
        Assert.assertFalse((boolean)this.approvedEquipmentRule.areRequiredFieldsComplete(equipmentItem));
    }

    @Test
    public void testValidatingAmount() {
        AwardApprovedEquipment equipmentItem = this.createEquipmentItem(VENDOR, MODEL, WIDGET1, -1.0);
        this.checkValidAmount(equipmentItem, 1);
        equipmentItem.setAmount(0.0);
        this.checkValidAmount(equipmentItem, 1);
        equipmentItem.setAmount(99.99);
        this.checkValidAmount(equipmentItem, 1);
        equipmentItem.setAmount(100.0);
        this.checkValidAmount(equipmentItem, 1);
        equipmentItem.setAmount(null);
        this.checkValidAmount(equipmentItem, 1);
    }

    @Test
    public void testValidatingAmount_MinimumCapititalizationAmount() {
        AwardApprovedEquipment equipmentItem = this.createEquipmentItem(VENDOR, MODEL, WIDGET1, 1.0);
        this.approvedEquipmentRule.isAmountValid("approvedEquipmentItems", equipmentItem, this.minimumCapitalizationInfo);
        ArrayList errors = new ArrayList((Collection)this.approvedEquipmentRule.getSoftErrors().get("approvedEquipmentItems"));
        Assert.assertEquals((Object)AMOUNT2_TEXT, (Object)((SoftError)errors.get(0)).getErrorParms()[0]);
    }

    @Test
    public void testIsUnique() {
        AwardApprovedEquipment equipmentItem1 = this.createEquipmentItem(VENDOR, MODEL, WIDGET1, 200.0);
        AwardApprovedEquipment equipmentItem2 = this.createEquipmentItem(VENDOR, MODEL, WIDGET2, 100.0);
        this.checkAddingNewItemToEmptyList(equipmentItem1);
        this.award.add(equipmentItem1);
        this.checkExistingEntriesDoesntTriggerErrorOnSave();
        this.addApprovedEquipmentToAward(equipmentItem1, equipmentItem2);
        this.checkAddingDuplicateToCollection();
        this.checkEditingItemResultingInDuplicate(equipmentItem2);
    }

    private void addApprovedEquipmentToAward(AwardApprovedEquipment equipmentItem1, AwardApprovedEquipment equipmentItem2) {
        equipmentItem1.setApprovedEquipmentId(Long.valueOf(1L));
        this.award.add(equipmentItem1);
        equipmentItem2.setApprovedEquipmentId(Long.valueOf(2L));
        this.award.add(equipmentItem2);
    }

    private void checkAddingDuplicateToCollection() {
        AwardApprovedEquipment item1Duplicate = this.createEquipmentItem(VENDOR, MODEL, WIDGET1, 200.0);
        Assert.assertFalse((boolean)this.approvedEquipmentRule.isUnique(this.award.getApprovedEquipmentItems(), item1Duplicate));
    }

    private void checkAddingNewItemToEmptyList(AwardApprovedEquipment equipmentItem1) {
        Assert.assertTrue((boolean)this.approvedEquipmentRule.isUnique(new ArrayList(), equipmentItem1));
    }

    private void checkExistingEntriesDoesntTriggerErrorOnSave() {
        List items = this.award.getApprovedEquipmentItems();
        for (AwardApprovedEquipment item : items) {
            Assert.assertTrue((boolean)this.approvedEquipmentRule.isUnique(items, item));
        }
    }

    private void checkValidAmount(AwardApprovedEquipment equipmentItem, int expectedErrorCount) {
        this.approvedEquipmentRule.isAmountValid("approvedEquipmentItems", equipmentItem, this.minimumCapitalizationInfo);
        Assert.assertEquals((long)expectedErrorCount, (long)this.approvedEquipmentRule.getSoftErrors().size());
        this.approvedEquipmentRule.getSoftErrors().clear();
    }

    private void checkEditingItemResultingInDuplicate(AwardApprovedEquipment equipmentItem2) {
        equipmentItem2.setItem(WIDGET1);
        Assert.assertFalse((boolean)this.approvedEquipmentRule.isUnique(this.award.getApprovedEquipmentItems(), equipmentItem2));
    }

    private AwardApprovedEquipment createEquipmentItem(String vendor, String model, String item, double value) {
        return new AwardApprovedEquipment(vendor, model, item, value);
    }

    private AwardApprovedEquipmentRuleImpl prepareTestReadyAwardApprovedEquipmentRule() {
        AwardApprovedEquipmentRuleImpl approvedEquipmentRule = new AwardApprovedEquipmentRuleImpl(){
            private Map<String, Collection<SoftError>> softErrors = new HashMap<String, Collection<SoftError>>();

            public Map<String, Collection<SoftError>> getSoftErrors() {
                return this.softErrors;
            }

            protected void reportSoftError(String propertyName, String errorKey, String ... errorParams) {
                this.addSoftError(propertyName, errorKey, errorParams);
            }

            private void addSoftError(String propertyName, String errorKey, String[] errorParams) {
                Collection<SoftError> errorsForProperty = this.softErrors.get(propertyName);
                if (errorsForProperty == null) {
                    errorsForProperty = new HashSet<SoftError>();
                }
                errorsForProperty.add(new SoftError(errorKey, errorParams));
                this.softErrors.put(propertyName, errorsForProperty);
            }
        };
        return approvedEquipmentRule;
    }
}

