/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.paymentreports.specialapproval.foreigntravel;

import java.sql.Date;
import java.util.GregorianCalendar;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.award.AwardForm;
import org.kuali.kra.award.contacts.AwardPerson;
import org.kuali.kra.award.contacts.ContactRoleFixtureFactory;
import org.kuali.kra.award.document.AwardDocument;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.paymentreports.specialapproval.foreigntravel.ApprovedForeignTravelBean;
import org.kuali.kra.award.paymentreports.specialapproval.foreigntravel.AwardApprovedForeignTravel;
import org.kuali.kra.bo.Contactable;
import org.kuali.kra.bo.KcPerson;
import org.kuali.kra.bo.KcPersonFixtureFactory;
import org.kuali.kra.bo.NonOrganizationalRolodex;
import org.kuali.kra.test.infrastructure.KcUnitTestBase;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.krad.document.Document;

public class ApprovedForeignTravelBeanTest
extends KcUnitTestBase {
    private static final String DESTINATION_NAME = "Tokyo, Japan";
    private static final Date START_DATE = new Date(new GregorianCalendar(2009, 5, 1).getTimeInMillis());
    private static final Date END_DATE = new Date(new GregorianCalendar(2009, 5, 10).getTimeInMillis());
    private static final KualiDecimal TRIP_AMOUNT = new KualiDecimal(6000.0);
    private static final String TRAVELER_NAME_WAS_NULL = "Traveler name was null";
    private static final String TRAVELER_NAME_WAS_INCORRECT_PATTERN = "Traveler name was incorrect: %s";
    private Award award;
    private ApprovedForeignTravelBean bean;
    private NonOrganizationalRolodex nonEmployeeTraveler;
    private KcPerson employeeTraveler;
    private AwardApprovedForeignTravel foreignTravelTrip;
    private AwardPerson employee;
    private AwardPerson nonEmployee;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.award = new Award();
        AwardForm form = new AwardForm();
        AwardDocument awardDocument = new AwardDocument();
        awardDocument.setAward(this.award);
        form.setDocument((Document)awardDocument);
        this.bean = new ApprovedForeignTravelBean(form);
        this.employeeTraveler = KcPersonFixtureFactory.createKcPerson("1001");
        this.initializeNonEmployeeTraveler();
        this.foreignTravelTrip = this.initializeForeignTravelTrip_Employee();
        this.employee = new AwardPerson(this.employeeTraveler, ContactRoleFixtureFactory.MOCK_PI);
        this.award.add(this.employee);
        this.nonEmployee = new AwardPerson(this.nonEmployeeTraveler, ContactRoleFixtureFactory.MOCK_COI);
        this.award.add(this.nonEmployee);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.bean = null;
        this.award = null;
        super.tearDown();
    }

    @Test
    public void testSunnyDayScenario_Employee() throws Exception {
        this.checkForeignTravelTrip(this.bean, this.foreignTravelTrip, true);
        Assert.assertEquals((long)1L, (long)this.award.getApprovedForeignTravelTrips().size());
    }

    @Test
    public void testSunnyDayScenario_Nonemployee() throws Exception {
        AwardApprovedForeignTravel trip = this.initializeForeignTravelTrip_Nonemployee();
        this.checkForeignTravelTrip(this.bean, trip, true);
        Assert.assertEquals((long)1L, (long)this.award.getApprovedForeignTravelTrips().size());
    }

    @Test
    public void testAddingNewForeignTravelTrip_NothingSet() throws Exception {
        this.checkForeignTravelTrip(this.bean, new AwardApprovedForeignTravel(), false);
    }

    @Test
    public void testAddingNewForeignTravelTrip_TravelerNameSet() throws Exception {
        this.foreignTravelTrip.setPersonTraveler(null);
        this.foreignTravelTrip.setTravelerName(this.employeeTraveler.getFullName());
        this.checkForeignTravelTrip(this.bean, this.foreignTravelTrip, true);
    }

    @Test
    public void testAddingNewForeignTravelTrip_TravelerNameNotSet() throws Exception {
        this.foreignTravelTrip.setPersonTraveler(null);
        this.checkForeignTravelTrip(this.bean, this.foreignTravelTrip, false);
    }

    @Test
    public void testAddingNewForeignTravelTrip_StartDateNotSet() throws Exception {
        this.foreignTravelTrip.setStartDate(null);
        this.checkForeignTravelTrip(this.bean, this.foreignTravelTrip, false);
    }

    @Test
    public void testAddingNewForeignTravelTrip_EndDateNotSet() throws Exception {
        this.foreignTravelTrip.setEndDate(null);
        this.checkForeignTravelTrip(this.bean, this.foreignTravelTrip, true);
    }

    @Test
    public void testAddingNewForeignTravelTrip_AmountNotSet() throws Exception {
        this.foreignTravelTrip.setAmount(null);
        this.checkForeignTravelTrip(this.bean, this.foreignTravelTrip, false);
    }

    @Test
    public void testSettingSelectedTravelerId_Employee() throws Exception {
        this.foreignTravelTrip.setPersonTraveler(null);
        this.checkForIdentificationOfTravelerNameFromTravelerId(this.employee);
    }

    @Test
    public void testSettingSelectedTravelerId_nonEmployee() throws Exception {
        this.foreignTravelTrip.setPersonTraveler(null);
        this.checkForIdentificationOfTravelerNameFromTravelerId(this.nonEmployee);
    }

    private void checkForIdentificationOfTravelerNameFromTravelerId(AwardPerson awardPerson) {
        Contactable contact = awardPerson.getContact();
        this.bean.setSelectedTravelerId(contact.getIdentifier().toString());
        Assert.assertNotNull((String)TRAVELER_NAME_WAS_NULL, (Object)this.bean.getNewApprovedForeignTravel().getTravelerName());
        Assert.assertNotNull((String)this.createIncorrectNameMessage(contact), (Object)this.bean.getNewApprovedForeignTravel().getTravelerName());
    }

    private String createIncorrectNameMessage(Contactable contact) {
        return String.format(TRAVELER_NAME_WAS_INCORRECT_PATTERN, contact.getFullName());
    }

    private void checkForeignTravelTrip(ApprovedForeignTravelBean bean, AwardApprovedForeignTravel item, boolean expectedOutcome) {
        bean.setNewAwardApprovedForeignTravel(item);
        Assert.assertEquals((Object)expectedOutcome, (Object)bean.addApprovedForeignTravel());
        Assert.assertEquals((long)(expectedOutcome ? 1L : 0L), (long)this.award.getApprovedForeignTravelTrips().size());
    }

    private AwardApprovedForeignTravel initializeForeignTravelTrip_Employee() {
        AwardApprovedForeignTravel foreignTravelTrip = this.initializeForeignTravelTrip();
        foreignTravelTrip.setPersonTraveler(this.employeeTraveler);
        return foreignTravelTrip;
    }

    private AwardApprovedForeignTravel initializeForeignTravelTrip_Nonemployee() {
        AwardApprovedForeignTravel foreignTravelTrip = this.initializeForeignTravelTrip();
        foreignTravelTrip.setRolodexTraveler(this.nonEmployeeTraveler);
        return foreignTravelTrip;
    }

    private AwardApprovedForeignTravel initializeForeignTravelTrip() {
        AwardApprovedForeignTravel foreignTravelTrip = new AwardApprovedForeignTravel();
        foreignTravelTrip.setDestination(DESTINATION_NAME);
        foreignTravelTrip.setStartDate(START_DATE);
        foreignTravelTrip.setEndDate(END_DATE);
        foreignTravelTrip.setAmount(TRIP_AMOUNT);
        return foreignTravelTrip;
    }

    private void initializeNonEmployeeTraveler() {
        this.nonEmployeeTraveler = new NonOrganizationalRolodex();
        this.nonEmployeeTraveler.setRolodexId(Integer.valueOf(1234));
        this.nonEmployeeTraveler.setFirstName("Joe");
        this.nonEmployeeTraveler.setLastName("Smith");
    }
}

