/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.paymentreports.specialapproval.foreigntravel;

import java.sql.Date;
import java.util.GregorianCalendar;
import java.util.Map;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.award.AwardForm;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.paymentreports.specialapproval.foreigntravel.AwardApprovedForeignTravel;
import org.kuali.kra.award.paymentreports.specialapproval.foreigntravel.AwardApprovedForeignTravelRuleImpl;
import org.kuali.kra.bo.KcPerson;
import org.kuali.kra.bo.NonOrganizationalRolodex;
import org.kuali.kra.test.infrastructure.KcUnitTestBase;
import org.kuali.rice.kns.util.KNSGlobalVariables;
import org.kuali.rice.kns.web.struts.form.KualiForm;
import org.kuali.rice.krad.UserSession;
import org.kuali.rice.krad.util.GlobalVariables;

public class AwardApprovedForeignTravelRuleIntegrationTest
extends KcUnitTestBase {
    private static final String ERROR_KEY = "approvedForeignTravel";
    private static final double ZERO_AMOUNT = 0.0;
    private static final double AMOUNT1 = 100.0;
    private static final double AMOUNT2 = 200.0;
    private static final String DESTINATION1_NAME = "Tokyo, Japan";
    private static final String DESTINATION2_NAME = "Moscow, Russia";
    private static final int YEAR = 2009;
    private static final int DAY_10 = 10;
    private static final Date END1_DATE = new Date(new GregorianCalendar(2009, 5, 10).getTimeInMillis());
    private static final Date END2_DATE = new Date(new GregorianCalendar(2009, 6, 10).getTimeInMillis());
    private static final double ONE_PENNY = 0.01;
    private static final Date START1_DATE = new Date(new GregorianCalendar(2009, 5, 1).getTimeInMillis());
    private static final Date START2_DATE = new Date(new GregorianCalendar(2009, 6, 1).getTimeInMillis());
    private static final String TRAVELER1_ID = "000000001";
    private static final String TRAVELER1_NAME = "Joe Smith";
    private static final Integer TRAVELER2_ID = 1002;
    private static final String TRAVELER2_NAME = "Jane Doe";
    private AwardApprovedForeignTravelRuleImpl approvedForeignTravelRule;
    private AwardApprovedForeignTravel trip1;
    private AwardApprovedForeignTravel trip2;
    private Award award;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        GlobalVariables.setUserSession((UserSession)new UserSession("quickstart"));
        this.approvedForeignTravelRule = new AwardApprovedForeignTravelRuleImpl();
        this.award = new Award();
        this.award.setAwardId(Long.valueOf(1L));
        this.award.setAwardNumber("X1000");
        this.award.setSequenceNumber(Integer.valueOf(1));
        KNSGlobalVariables.setKualiForm((KualiForm)new AwardForm());
        this.trip1 = this.createForeignTravelTrip(TRAVELER1_ID, TRAVELER1_NAME, DESTINATION1_NAME, START1_DATE, END1_DATE, 100.0);
        this.trip1.setApprovedForeignTravelId(Long.valueOf(1L));
        this.trip2 = this.createForeignTravelTrip(TRAVELER2_ID, TRAVELER2_NAME, DESTINATION2_NAME, START2_DATE, END2_DATE, 200.0);
        this.trip2.setApprovedForeignTravelId(Long.valueOf(2L));
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.award = null;
        this.approvedForeignTravelRule = null;
        GlobalVariables.setUserSession(null);
        super.tearDown();
    }

    @Test
    public void testForDuplicate_NoneExpected() throws Exception {
        this.award.add(this.trip1);
        this.approvedForeignTravelRule.isAmountValid(ERROR_KEY, this.trip2);
        Assert.assertEquals((long)0L, (long)this.getErrors().size());
    }

    @Test
    public void testForDuplicate_ErrorExpected() throws Exception {
        this.award.add(this.trip1);
        this.approvedForeignTravelRule.isAmountValid(ERROR_KEY, new AwardApprovedForeignTravel(this.trip1));
        Assert.assertEquals((long)0L, (long)this.getErrors().size());
    }

    @Test
    public void testValidatingAmount_NegativeAmount() throws Exception {
        this.trip1.setAmount(-0.01);
        this.approvedForeignTravelRule.isAmountValid(ERROR_KEY, this.trip1);
        Assert.assertEquals((long)1L, (long)this.getErrors().size());
    }

    @Test
    public void testValidatingAmount_ZeroAmount() throws Exception {
        this.trip1.setAmount(0.0);
        this.approvedForeignTravelRule.isAmountValid(ERROR_KEY, this.trip1);
        Assert.assertEquals((long)0L, (long)this.getErrors().size());
    }

    @Test
    public void testValidatingAmount_PositiveAmount() throws Exception {
        this.trip1.setAmount(100.0);
        this.approvedForeignTravelRule.isAmountValid(ERROR_KEY, this.trip1);
        Assert.assertEquals((long)0L, (long)this.getErrors().size());
    }

    private Map getErrors() {
        return GlobalVariables.getMessageMap().getErrorMessages();
    }

    private AwardApprovedForeignTravel createForeignTravelTrip(String travelerId, String travelerName, String destination, Date startDate, Date endDate, double amount) {
        return new AwardApprovedForeignTravel((Object)this.getTraveler(travelerId, travelerName), destination, startDate, endDate, amount);
    }

    private AwardApprovedForeignTravel createForeignTravelTrip(Integer travelerId, String travelerName, String destination, Date startDate, Date endDate, double amount) {
        return new AwardApprovedForeignTravel((Object)this.getTraveler(travelerId, travelerName), destination, startDate, endDate, amount);
    }

    private KcPerson getTraveler(String travelerId, String travelerName) {
        KcPerson person = new KcPerson();
        person.setPersonId(travelerId);
        return person;
    }

    private NonOrganizationalRolodex getTraveler(Integer travelerId, String travelerName) {
        NonOrganizationalRolodex contact = new NonOrganizationalRolodex();
        contact.setRolodexId(travelerId);
        String[] parts = travelerName.split(" ");
        contact.setFirstName(parts[0]);
        contact.setFirstName(parts[1]);
        return contact;
    }
}

