/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.rule;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.award.document.AwardDocument;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.home.AwardComment;
import org.kuali.kra.award.rule.AwardCommentsRule;
import org.kuali.kra.award.rule.AwardCommentsRuleImpl;
import org.kuali.kra.award.rule.event.AwardCommentsRuleEvent;
import org.kuali.kra.test.infrastructure.KcUnitTestBase;
import org.kuali.rice.krad.util.ErrorMessage;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.MessageMap;
import org.springframework.util.AutoPopulatingList;

public class AwardCommentsRuleTest
extends KcUnitTestBase {
    private static final String ERROR_PATH_PREFIX = "document.awards[0]";
    private static final String VALID_COMMENT = "This comment should pass validation";
    private static final int MAX_COMMENT_LENGTH = 5000;
    private AwardCommentsRule awardCommentsRule;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        GlobalVariables.setMessageMap((MessageMap)new MessageMap());
        this.awardCommentsRule = new AwardCommentsRuleImpl();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
    }

    @Test
    public void testProcessAwardCommentsBusinessRules() throws Exception {
        AwardDocument document = new AwardDocument();
        Award award = document.getAward();
        AwardComment awardComment = null;
        this.assertNoErrors(document);
        awardComment = award.getAwardPaymentAndInvoiceRequirementsComments();
        AwardCommentsRuleTest.assertEquals((long)1L, (long)award.getAwardComments().size());
        AwardCommentsRuleTest.assertNotNull((Object)awardComment);
        AwardCommentsRuleTest.assertEquals((Object)"", (Object)awardComment.getComments());
        this.assertNoErrors(document);
        awardComment = award.getAwardFandaRateComment();
        AwardCommentsRuleTest.assertEquals((long)2L, (long)award.getAwardComments().size());
        AwardCommentsRuleTest.assertNotNull((Object)awardComment);
        AwardCommentsRuleTest.assertEquals((Object)"", (Object)awardComment.getComments());
        this.assertNoErrors(document);
        awardComment.setComments(VALID_COMMENT);
        AwardCommentsRuleTest.assertEquals((Object)VALID_COMMENT, (Object)awardComment.getComments());
        this.assertNoErrors(document);
        String validLongComment = this.generateComment(5000);
        awardComment.setComments(validLongComment);
        AwardCommentsRuleTest.assertEquals((Object)validLongComment, (Object)awardComment.getComments());
        this.assertNoErrors(document);
        String invalidLongComment = this.generateComment(5001);
        awardComment.setComments(invalidLongComment);
        AwardCommentsRuleTest.assertEquals((Object)invalidLongComment, (Object)awardComment.getComments());
        String propertyKey = "document.awards[0].awardFandaRateComment.comments";
        this.assertOneError(document, propertyKey, "error.maxLength");
    }

    private void assertNoErrors(AwardDocument document) {
        AwardCommentsRuleEvent ruleEvent = new AwardCommentsRuleEvent(ERROR_PATH_PREFIX, document);
        boolean result = this.awardCommentsRule.processAwardCommentsBusinessRules(ruleEvent);
        AwardCommentsRuleTest.assertTrue((boolean)result);
        AwardCommentsRuleTest.assertEquals((long)0L, (long)GlobalVariables.getMessageMap().getErrorCount());
    }

    private void assertOneError(AwardDocument document, String propertyKey, String expectedErrorKey) {
        AwardCommentsRuleEvent ruleEvent = new AwardCommentsRuleEvent(ERROR_PATH_PREFIX, document);
        boolean result = this.awardCommentsRule.processAwardCommentsBusinessRules(ruleEvent);
        AwardCommentsRuleTest.assertFalse((boolean)result);
        AwardCommentsRuleTest.assertEquals((long)1L, (long)GlobalVariables.getMessageMap().getErrorCount());
        AutoPopulatingList errorMessages = GlobalVariables.getMessageMap().getErrorMessagesForProperty(propertyKey);
        AwardCommentsRuleTest.assertNotNull((Object)errorMessages);
        AwardCommentsRuleTest.assertEquals((long)1L, (long)errorMessages.size());
        String actualErrorKey = ((ErrorMessage)errorMessages.get(0)).getErrorKey();
        AwardCommentsRuleTest.assertEquals((Object)expectedErrorKey, (Object)actualErrorKey);
    }

    private String generateComment(int length) {
        StringBuffer comment = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            comment = comment.append('x');
        }
        return comment.toString();
    }
}

