/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.subcontracting.goalsAndExpenditures;

import java.util.ArrayList;
import java.util.HashMap;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.api.Action;
import org.jmock.api.Invocation;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.jmock.lib.action.CustomAction;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.subcontracting.goalsAndExpenditures.AwardSubcontractingBudgetedGoals;
import org.kuali.kra.award.subcontracting.goalsAndExpenditures.AwardSubcontractingGoalsExpendituresRule;
import org.kuali.rice.kns.lookup.Lookupable;
import org.kuali.rice.kns.service.DictionaryValidationService;
import org.kuali.rice.krad.util.ErrorMessage;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.MessageMap;
import org.springframework.util.AutoPopulatingList;

public class AwardSubcontractingGoalsExpendituresRuleTest {
    private static final String AWARD_NUMBER = "awardNumber";
    private static final String BAD_FORMAT_INPUT = "bad format";
    private static final String BLANK_INPUT = "blank format";
    private static final String NO_VALID_AWARD_INPUT = "no valid award input";
    private static final String VALID_AWARD_INPUT = "valid award input";
    private static final String BAD_FORMAT_PROPERTY_KEY = "bad format property key";
    private static final String BAD_FORMAT_ERROR_KEY = "bad format error key";
    private static final String BLANK_FORMAT_PROPERTY_KEY = "blank format property key";
    private static final String BLANK_FORMAT_ERROR_KEY = "blank format error key";
    private static final String SUB_PLAN_FLAG = "subPlanFlag";
    private static final String SUB_PLAN_FLAG_VAL = "Y";
    private static final String DD_ENTRY_NAME = AwardSubcontractingBudgetedGoals.class.getSimpleName();
    protected static final Long AWARD_ID_VAL = 4444L;
    private Mockery context = new JUnit4Mockery();
    private AwardSubcontractingGoalsExpendituresRule rule;

    @Before
    public void setUp() throws Exception {
        GlobalVariables.setMessageMap((MessageMap)new MessageMap());
        this.rule = new AwardSubcontractingGoalsExpendituresRule();
        this.rule.setAwardLookupable((Lookupable)this.context.mock(Lookupable.class));
        this.rule.setDictionaryValidationService((DictionaryValidationService)this.context.mock(DictionaryValidationService.class));
        this.addNegativeExpectations();
    }

    @After
    public void tearDown() {
        this.rule = null;
    }

    @Test
    public void testValidateAwardNumberRequired() throws Exception {
        String awardNumber = BLANK_INPUT;
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((DictionaryValidationService)this.one(AwardSubcontractingGoalsExpendituresRuleTest.this.rule.getDictionaryValidationService())).validateAttributeRequired(DD_ENTRY_NAME, AwardSubcontractingGoalsExpendituresRuleTest.AWARD_NUMBER, (Object)AwardSubcontractingGoalsExpendituresRuleTest.BLANK_INPUT, Boolean.valueOf(false), AwardSubcontractingGoalsExpendituresRuleTest.AWARD_NUMBER);
                GlobalVariables.getMessageMap().putError(AwardSubcontractingGoalsExpendituresRuleTest.BLANK_FORMAT_PROPERTY_KEY, AwardSubcontractingGoalsExpendituresRuleTest.BLANK_FORMAT_ERROR_KEY, new String[0]);
            }
        });
        Assert.assertFalse((boolean)this.rule.validateAwardNumber(BLANK_INPUT));
        this.assertError(BLANK_FORMAT_PROPERTY_KEY, BLANK_FORMAT_ERROR_KEY);
    }

    @Test
    public void testValidateAwardNumberInvalidFormat() throws Exception {
        String awardNumber = BAD_FORMAT_INPUT;
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((DictionaryValidationService)this.one(AwardSubcontractingGoalsExpendituresRuleTest.this.rule.getDictionaryValidationService())).validateAttributeRequired(DD_ENTRY_NAME, AwardSubcontractingGoalsExpendituresRuleTest.AWARD_NUMBER, (Object)AwardSubcontractingGoalsExpendituresRuleTest.BAD_FORMAT_INPUT, Boolean.valueOf(false), AwardSubcontractingGoalsExpendituresRuleTest.AWARD_NUMBER);
                ((DictionaryValidationService)this.one(AwardSubcontractingGoalsExpendituresRuleTest.this.rule.getDictionaryValidationService())).validateAttributeFormat(DD_ENTRY_NAME, AwardSubcontractingGoalsExpendituresRuleTest.AWARD_NUMBER, AwardSubcontractingGoalsExpendituresRuleTest.BAD_FORMAT_INPUT, AwardSubcontractingGoalsExpendituresRuleTest.AWARD_NUMBER);
                this.will((Action)new CustomAction("Add random value to list"){

                    public Object invoke(Invocation invocation) throws Throwable {
                        GlobalVariables.getMessageMap().putError(AwardSubcontractingGoalsExpendituresRuleTest.BAD_FORMAT_PROPERTY_KEY, AwardSubcontractingGoalsExpendituresRuleTest.BAD_FORMAT_ERROR_KEY, new String[0]);
                        return null;
                    }
                });
            }
        });
        Assert.assertFalse((boolean)this.rule.validateAwardNumber(BAD_FORMAT_INPUT));
        this.assertError(BAD_FORMAT_PROPERTY_KEY, BAD_FORMAT_ERROR_KEY);
    }

    @Test
    public void testValidateAwardNumberAwardNotFound() throws Exception {
        String awardNumber = NO_VALID_AWARD_INPUT;
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((DictionaryValidationService)this.one(AwardSubcontractingGoalsExpendituresRuleTest.this.rule.getDictionaryValidationService())).validateAttributeRequired(DD_ENTRY_NAME, AwardSubcontractingGoalsExpendituresRuleTest.AWARD_NUMBER, (Object)AwardSubcontractingGoalsExpendituresRuleTest.NO_VALID_AWARD_INPUT, Boolean.valueOf(false), AwardSubcontractingGoalsExpendituresRuleTest.AWARD_NUMBER);
                ((DictionaryValidationService)this.one(AwardSubcontractingGoalsExpendituresRuleTest.this.rule.getDictionaryValidationService())).validateAttributeFormat(DD_ENTRY_NAME, AwardSubcontractingGoalsExpendituresRuleTest.AWARD_NUMBER, AwardSubcontractingGoalsExpendituresRuleTest.NO_VALID_AWARD_INPUT, AwardSubcontractingGoalsExpendituresRuleTest.AWARD_NUMBER);
                HashMap<String, String> fieldValues = new HashMap<String, String>();
                fieldValues.put(AwardSubcontractingGoalsExpendituresRuleTest.SUB_PLAN_FLAG, AwardSubcontractingGoalsExpendituresRuleTest.SUB_PLAN_FLAG_VAL);
                fieldValues.put(AwardSubcontractingGoalsExpendituresRuleTest.AWARD_NUMBER, AwardSubcontractingGoalsExpendituresRuleTest.NO_VALID_AWARD_INPUT);
                ((Lookupable)this.one(AwardSubcontractingGoalsExpendituresRuleTest.this.rule.getAwardLookupable())).getSearchResults(fieldValues);
                this.will(3.returnValue(new ArrayList()));
            }
        });
        Assert.assertFalse((boolean)this.rule.validateAwardNumber(NO_VALID_AWARD_INPUT));
        this.assertError(AWARD_NUMBER, "error.award.subcontracting.goalsAndExpenditures.awardNotFound");
    }

    @Test
    public void testValidateAwardNumberValidAward() throws Exception {
        String awardNumber = VALID_AWARD_INPUT;
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((DictionaryValidationService)this.one(AwardSubcontractingGoalsExpendituresRuleTest.this.rule.getDictionaryValidationService())).validateAttributeRequired(DD_ENTRY_NAME, AwardSubcontractingGoalsExpendituresRuleTest.AWARD_NUMBER, (Object)AwardSubcontractingGoalsExpendituresRuleTest.VALID_AWARD_INPUT, Boolean.valueOf(false), AwardSubcontractingGoalsExpendituresRuleTest.AWARD_NUMBER);
                ((DictionaryValidationService)this.one(AwardSubcontractingGoalsExpendituresRuleTest.this.rule.getDictionaryValidationService())).validateAttributeFormat(DD_ENTRY_NAME, AwardSubcontractingGoalsExpendituresRuleTest.AWARD_NUMBER, AwardSubcontractingGoalsExpendituresRuleTest.VALID_AWARD_INPUT, AwardSubcontractingGoalsExpendituresRuleTest.AWARD_NUMBER);
                Award foundAward = new Award();
                foundAward.setAwardId(AWARD_ID_VAL);
                HashMap<String, String> fieldValues = new HashMap<String, String>();
                fieldValues.put(AwardSubcontractingGoalsExpendituresRuleTest.SUB_PLAN_FLAG, AwardSubcontractingGoalsExpendituresRuleTest.SUB_PLAN_FLAG_VAL);
                fieldValues.put(AwardSubcontractingGoalsExpendituresRuleTest.AWARD_NUMBER, AwardSubcontractingGoalsExpendituresRuleTest.VALID_AWARD_INPUT);
                ArrayList<Award> awardResults = new ArrayList<Award>();
                awardResults.add(foundAward);
                ((Lookupable)this.one(AwardSubcontractingGoalsExpendituresRuleTest.this.rule.getAwardLookupable())).getSearchResults(fieldValues);
                this.will(4.returnValue(awardResults));
            }
        });
        Assert.assertTrue((boolean)this.rule.validateAwardNumber(VALID_AWARD_INPUT));
        Assert.assertEquals((Object)AWARD_ID_VAL.toString(), (Object)this.rule.getAwardId());
    }

    private void addNegativeExpectations() {
        final HashMap<String, String> blankFieldValues = new HashMap<String, String>();
        blankFieldValues.put(SUB_PLAN_FLAG, SUB_PLAN_FLAG_VAL);
        blankFieldValues.put(AWARD_NUMBER, BLANK_INPUT);
        final HashMap<String, String> badFormatFieldValues = new HashMap<String, String>();
        badFormatFieldValues.put(SUB_PLAN_FLAG, SUB_PLAN_FLAG_VAL);
        badFormatFieldValues.put(AWARD_NUMBER, BAD_FORMAT_INPUT);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((DictionaryValidationService)this.never(AwardSubcontractingGoalsExpendituresRuleTest.this.rule.getDictionaryValidationService())).validateAttributeFormat(DD_ENTRY_NAME, AwardSubcontractingGoalsExpendituresRuleTest.AWARD_NUMBER, AwardSubcontractingGoalsExpendituresRuleTest.BLANK_INPUT, AwardSubcontractingGoalsExpendituresRuleTest.AWARD_NUMBER);
                ((Lookupable)this.never(AwardSubcontractingGoalsExpendituresRuleTest.this.rule.getAwardLookupable())).getSearchResults(blankFieldValues);
                ((Lookupable)this.never(AwardSubcontractingGoalsExpendituresRuleTest.this.rule.getAwardLookupable())).getSearchResults(badFormatFieldValues);
            }
        });
    }

    private void assertError(String propertyKey, String errorKey) {
        AutoPopulatingList errors = GlobalVariables.getMessageMap().getMessages(propertyKey);
        Assert.assertNotNull((Object)errors);
        Assert.assertTrue((errors.size() == 1 ? 1 : 0) != 0);
        ErrorMessage message = (ErrorMessage)errors.get(0);
        Assert.assertNotNull((Object)message);
        Assert.assertEquals((Object)message.getErrorKey(), (Object)errorKey);
    }
}

