/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.subcontracting.goalsAndExpenditures;

import java.util.HashMap;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.award.subcontracting.goalsAndExpenditures.AwardSubcontractingBudgetedGoals;
import org.kuali.kra.award.subcontracting.goalsAndExpenditures.AwardSubcontractingGoalsExpendituresServiceImpl;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.service.BusinessObjectService;

public class AwardSubcontractingGoalsExpendituresServiceTest {
    private static final String AWARD_NUMBER = "awardNumber";
    private static final String FRESH_BO_NUMBER = "fresh BO number";
    private static final String PRESTORED_BO_NUMBER = "prestored BO number";
    private static final String SAVE_BO_NUMBER = "save BO number";
    private Mockery context = new JUnit4Mockery();
    private AwardSubcontractingGoalsExpendituresServiceImpl serviceImpl;

    @Before
    public void setUp() throws Exception {
        this.serviceImpl = new AwardSubcontractingGoalsExpendituresServiceImpl();
        this.serviceImpl.setBusinessObjectService((BusinessObjectService)this.context.mock(BusinessObjectService.class));
    }

    @Test
    public void testGetGoalsExpendituresBOForAwardFresh() {
        String awardNumber = FRESH_BO_NUMBER;
        final HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put(AWARD_NUMBER, FRESH_BO_NUMBER);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((BusinessObjectService)this.one(AwardSubcontractingGoalsExpendituresServiceTest.this.serviceImpl.getBusinessObjectService())).findByPrimaryKey(AwardSubcontractingBudgetedGoals.class, fieldValues);
                this.will(1.returnValue(null));
            }
        });
        AwardSubcontractingBudgetedGoals actualBO = this.serviceImpl.getBudgetedGoalsBOForAward(FRESH_BO_NUMBER);
        Assert.assertNotNull((Object)actualBO);
        Assert.assertTrue((boolean)actualBO.isFresh());
    }

    @Test
    public void testGetGoalsExpendituresBOForAwardPreStored() {
        String awardNumber = PRESTORED_BO_NUMBER;
        final HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put(AWARD_NUMBER, PRESTORED_BO_NUMBER);
        final AwardSubcontractingBudgetedGoals returnBO = new AwardSubcontractingBudgetedGoals();
        returnBO.setAwardNumber(PRESTORED_BO_NUMBER);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((BusinessObjectService)this.one(AwardSubcontractingGoalsExpendituresServiceTest.this.serviceImpl.getBusinessObjectService())).findByPrimaryKey(AwardSubcontractingBudgetedGoals.class, fieldValues);
                this.will(2.returnValue((Object)returnBO));
            }
        });
        AwardSubcontractingBudgetedGoals actualBO = this.serviceImpl.getBudgetedGoalsBOForAward(PRESTORED_BO_NUMBER);
        Assert.assertNotNull((Object)actualBO);
        Assert.assertFalse((boolean)actualBO.isFresh());
        Assert.assertSame((Object)returnBO, (Object)actualBO);
        Assert.assertEquals((Object)PRESTORED_BO_NUMBER, (Object)actualBO.getAwardNumber());
    }

    @Test
    public void testSaveGoalsExpendituresBO() {
        final AwardSubcontractingBudgetedGoals toBeSavedBO = new AwardSubcontractingBudgetedGoals(SAVE_BO_NUMBER);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((BusinessObjectService)this.one(AwardSubcontractingGoalsExpendituresServiceTest.this.serviceImpl.getBusinessObjectService())).save((PersistableBusinessObject)toBeSavedBO);
            }
        });
        Assert.assertTrue((boolean)toBeSavedBO.isFresh());
        this.serviceImpl.saveBudgetedGoalsBO(toBeSavedBO);
        Assert.assertFalse((boolean)toBeSavedBO.isFresh());
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((BusinessObjectService)this.one(AwardSubcontractingGoalsExpendituresServiceTest.this.serviceImpl.getBusinessObjectService())).save((PersistableBusinessObject)toBeSavedBO);
            }
        });
        this.serviceImpl.saveBudgetedGoalsBO(toBeSavedBO);
        Assert.assertFalse((boolean)toBeSavedBO.isFresh());
    }
}

