/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.timeandmoney;

import java.sql.Date;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.timeandmoney.AwardDirectFandADistribution;
import org.kuali.kra.award.timeandmoney.AwardDirectFandADistributionRuleImpl;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.MessageMap;

public class AwardDirectFandADistributionRuleTest {
    private static final int TWO = 2;
    private static final int SIX = 6;
    private static final int THREE = 3;
    private static final int NEGATIVE_THREE = -3;
    private static final int EIGHT = 8;
    AwardDirectFandADistributionRuleImpl awardDirectFandADistributionRuleImpl;
    List<AwardDirectFandADistribution> awardDirectFandADistributions;
    AwardDirectFandADistribution awardDirectFandADistribution;
    Award award;

    @Before
    public void setUp() throws Exception {
        this.awardDirectFandADistributions = new ArrayList<AwardDirectFandADistribution>();
        this.awardDirectFandADistribution = new AwardDirectFandADistribution();
        this.awardDirectFandADistributionRuleImpl = new AwardDirectFandADistributionRuleImpl();
        this.award = new Award();
        this.setAwardDatesToDefault();
        this.createAndSetDefaultDatesForAwardDirectFandADistributions();
        GlobalVariables.setMessageMap((MessageMap)new MessageMap());
    }

    @After
    public void tearDown() throws Exception {
        this.awardDirectFandADistributions = null;
        this.awardDirectFandADistribution = null;
        this.awardDirectFandADistributionRuleImpl = null;
        this.award = null;
    }

    @Test
    public final void testExistingDirectFandADistributionsDatesDontOverlap() {
        Assert.assertTrue((boolean)this.awardDirectFandADistributionRuleImpl.existingDirectFandADistributionsDatesDontOverlap(this.awardDirectFandADistributions));
    }

    @Test
    public final void testExistingDirectFandADistributionsDatesDoOverlap() {
        this.createOverlapOfFirstAndSecondInList();
        Assert.assertFalse((boolean)this.awardDirectFandADistributionRuleImpl.existingDirectFandADistributionsDatesDontOverlap(this.awardDirectFandADistributions));
        this.createAndSetDefaultDatesForAwardDirectFandADistributions();
    }

    @Test
    public final void testDoTargetDatesFallWithinExistingPeriodFails() {
        AwardDirectFandADistribution awardDirectFandADistribution = this.getDateWithinGapPeriod();
        this.awardDirectFandADistributionRuleImpl.setAwardDirectFandADistribution(awardDirectFandADistribution);
        Assert.assertFalse((boolean)this.awardDirectFandADistributionRuleImpl.doTargetDatesFallWithinOpenPeriod(this.awardDirectFandADistributions));
    }

    @Test
    public final void testDoTargetDatesFallWithinExistingPeriodPasses() {
        this.createDateGapBetweenFirstAndSecondInList();
        AwardDirectFandADistribution awardDirectFandADistribution = this.getDateWithinGapPeriod();
        this.awardDirectFandADistributionRuleImpl.setAwardDirectFandADistribution(awardDirectFandADistribution);
        Assert.assertTrue((boolean)this.awardDirectFandADistributionRuleImpl.doTargetDatesFallWithinOpenPeriod(this.awardDirectFandADistributions));
        this.createAndSetDefaultDatesForAwardDirectFandADistributions();
    }

    @Test
    public final void testTargetStartAndEndDates() {
        AwardDirectFandADistribution awardDirectFandADistribution = this.getDateWithinGapPeriod();
        this.awardDirectFandADistributionRuleImpl.setAwardDirectFandADistribution(awardDirectFandADistribution);
        Assert.assertTrue((boolean)this.awardDirectFandADistributionRuleImpl.isStartDatePriorToEndDate());
        this.awardDirectFandADistributionRuleImpl.getAwardDirectFandADistribution().setStartDate(this.getDateAfterProjectEndDate());
        Assert.assertFalse((boolean)this.awardDirectFandADistributionRuleImpl.isStartDatePriorToEndDate());
    }

    public void setAwardDatesToDefault() {
        Calendar calendar = Calendar.getInstance();
        this.award.setAwardEffectiveDate(new Date(calendar.getTime().getTime()));
        calendar.add(1, 2);
        calendar.add(2, 6);
        this.award.setProjectEndDate(new Date(calendar.getTime().getTime()));
    }

    public void createAndSetDefaultDatesForAwardDirectFandADistributions() {
        AwardDirectFandADistribution a0 = new AwardDirectFandADistribution();
        AwardDirectFandADistribution a1 = new AwardDirectFandADistribution();
        AwardDirectFandADistribution a2 = new AwardDirectFandADistribution();
        this.awardDirectFandADistributions = new ArrayList<AwardDirectFandADistribution>();
        Calendar calendar = Calendar.getInstance();
        a0.setStartDate(new Date(calendar.getTime().getTime()));
        calendar.add(1, 1);
        calendar.add(5, -1);
        a0.setEndDate(new Date(calendar.getTime().getTime()));
        this.awardDirectFandADistributions.add(a0);
        calendar.add(5, 1);
        a1.setStartDate(new Date(calendar.getTime().getTime()));
        calendar.add(1, 1);
        calendar.add(5, -1);
        a1.setEndDate(new Date(calendar.getTime().getTime()));
        this.awardDirectFandADistributions.add(a1);
        calendar.add(5, 1);
        a2.setStartDate(new Date(calendar.getTime().getTime()));
        calendar.add(2, 6);
        a2.setEndDate(new Date(calendar.getTime().getTime()));
        this.awardDirectFandADistributions.add(a2);
        this.award.setAwardDirectFandADistributions(this.awardDirectFandADistributions);
    }

    public void createDateGapBetweenFirstAndSecondInList() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(2, 6);
        ((AwardDirectFandADistribution)this.award.getAwardDirectFandADistributions().get(0)).setEndDate(new Date(calendar.getTime().getTime()));
        calendar.add(1, 1);
        ((AwardDirectFandADistribution)this.award.getAwardDirectFandADistributions().get(1)).setStartDate(new Date(calendar.getTime().getTime()));
    }

    public AwardDirectFandADistribution getDateWithinGapPeriod() {
        AwardDirectFandADistribution awardDirectFandADistribution = new AwardDirectFandADistribution();
        Calendar calendar = Calendar.getInstance();
        calendar.add(2, 8);
        awardDirectFandADistribution.setStartDate(new Date(calendar.getTime().getTime()));
        calendar.add(2, 3);
        awardDirectFandADistribution.setEndDate(new Date(calendar.getTime().getTime()));
        return awardDirectFandADistribution;
    }

    public void createOverlapOfFirstAndSecondInList() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(2, 6);
        calendar.add(1, 1);
        ((AwardDirectFandADistribution)this.award.getAwardDirectFandADistributions().get(0)).setEndDate(new Date(calendar.getTime().getTime()));
    }

    public Date getDatePriorToProjectStartDate() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(2, -3);
        return new Date(calendar.getTime().getTime());
    }

    public Date getDateAfterProjectEndDate() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(1, 3);
        return new Date(calendar.getTime().getTime());
    }
}

