/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.web;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.award.web.AwardSeleniumHelper;
import org.kuali.kra.test.infrastructure.KcSeleniumTestBase;

public class AwardAttachmentsPanelSeleniumTest
extends KcSeleniumTestBase {
    private static final String TAB_ID = "Attachments";
    private static final String TABLE_ID = "attachments-table";
    private static final String BEAN_PREFIX = "awardAttachmentFormBean.newAttachment.";
    private static final String NEW_FILE_ID = "newFile";
    private static final String DESCRIPTION_ID = "description";
    private static final String TYPE_CODE_ID = "typeCode";
    private static final String BEAN_NEW_FILE_ID = "awardAttachmentFormBean.newAttachment.newFile";
    private static final String BEAN_DESCRIPTION_ID = "awardAttachmentFormBean.newAttachment.description";
    private static final String BEAN_TYPE_CODE_ID = "awardAttachmentFormBean.newAttachment.typeCode";
    private static final String ATTACHMENTS_LABEL = "Attachments (%d)";
    private static final String TYPE_CODE = "Sponsor Document";
    private static final String DESCRIPTION = "a description";
    private static final String DELETE_ATTACHMENT_BUTTON = "methodToCall.deleteAttachment";
    private static final String ADD_ATTACHMENT_BUTTON = "methodToCall.addAttachment";
    private AwardSeleniumHelper helper;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.helper = AwardSeleniumHelper.instance(driver);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.helper = null;
        super.tearDown();
    }

    @Test
    public void testAddDeleteAttachment() throws Exception {
        this.helper.createAward();
        this.helper.clickAwardCommentsNotesAndAttachmentsPage();
        this.helper.assertPageContains(String.format(ATTACHMENTS_LABEL, 0));
        this.helper.openTab(TAB_ID);
        this.helper.set(BEAN_TYPE_CODE_ID, TYPE_CODE);
        this.helper.set(BEAN_DESCRIPTION_ID, DESCRIPTION);
        this.helper.set(BEAN_NEW_FILE_ID, this.helper.getAbsoluteFilePath(AwardAttachmentsPanelSeleniumTest.class));
        this.helper.click(ADD_ATTACHMENT_BUTTON);
        this.helper.saveDocument();
        this.helper.assertNoPageErrors();
        this.helper.assertPageContains(String.format(ATTACHMENTS_LABEL, 1));
        this.helper.assertTableRowCount(TABLE_ID, 3);
        this.helper.assertTableCellValueContains(TABLE_ID, TYPE_CODE);
        this.helper.assertTableCellValueContains(TABLE_ID, DESCRIPTION);
        this.helper.assertTableCellValueContains(TABLE_ID, this.helper.getSimpleFilePath(AwardAttachmentsPanelSeleniumTest.class));
        this.helper.click(DELETE_ATTACHMENT_BUTTON);
        this.helper.clickYesAnswer();
        this.helper.saveDocument();
        this.helper.assertNoPageErrors();
        this.helper.assertPageContains(String.format(ATTACHMENTS_LABEL, 0));
        this.helper.assertTableRowCount(TABLE_ID, 2);
    }
}

