/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.web;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.award.web.AwardSeleniumHelper;
import org.kuali.kra.budget.web.BudgetSeleniumHelper;
import org.kuali.kra.test.infrastructure.KcSeleniumTestBase;

public class AwardBudgetBasicSeleniumTest
extends KcSeleniumTestBase {
    private AwardSeleniumHelper helper;
    private BudgetSeleniumHelper budgetHelper;
    private static final String DEFAULT_LINE_ITEM_DESC1 = "Equipment - Not MTDC";
    private static final String DEFAULT_LINE_ITEM_QUANTITY1 = "1";
    private static final String DEFAULT_LINE_ITEM_DESC2 = "Travel";
    private static final String DEFAULT_LINE_ITEM_QUANTITY2 = null;
    private String awardBudgetDocNbr;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.helper = AwardSeleniumHelper.instance(driver);
        this.budgetHelper = BudgetSeleniumHelper.instance(driver);
        this.helper.loginBackdoor();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.helper.loginBackdoor();
        this.helper = null;
        super.tearDown();
    }

    @Test
    public void testAwardBudgetBasic() {
        this.helper.createAward();
        this.helper.addContacts();
        this.helper.addSponsorTemplate();
        this.helper.addCustomData();
        this.helper.submit();
        this.helper.addBudget();
        this.helper.openBudget(0);
        this.awardBudgetDocNbr = this.budgetHelper.getDocumentNumber();
        this.populateBudget();
        this.submitBudget();
        this.approveBudget();
        this.postBudget();
    }

    protected void populateBudget() {
        this.budgetHelper.addPersonnel();
        this.budgetHelper.setPersonPercents(0, 0, 0, "35", "35");
        this.budgetHelper.clickBudgetNonPersonnelTab();
        this.budgetHelper.addLineItem(0, DEFAULT_LINE_ITEM_DESC1, DEFAULT_LINE_ITEM_QUANTITY1, "3.51");
        this.budgetHelper.addLineItem(1, DEFAULT_LINE_ITEM_DESC2, DEFAULT_LINE_ITEM_QUANTITY2, "1,759.60");
        this.budgetHelper.saveDocument();
    }

    protected void submitBudget() {
        this.budgetHelper.clickBudgetActionsTab();
        this.budgetHelper.routeDocument();
        this.budgetHelper.assertRoute();
        this.budgetHelper.closeDocument();
    }

    protected void approveBudget() {
        this.helper.loginBackdoor("jtester");
        this.helper.docSearch(this.awardBudgetDocNbr);
        this.budgetHelper.clickBudgetActionsTab();
        this.budgetHelper.approveDocument();
    }

    protected void postBudget() {
        this.helper.loginBackdoor();
        this.helper.docSearch(this.awardBudgetDocNbr);
        this.budgetHelper.clickBudgetActionsTab();
        this.budgetHelper.postBudget();
        this.budgetHelper.returnToAward();
        this.helper.clickAwardBudgetVersionsPage();
        this.helper.assertSelectorContains("div.tab-container tr:nth-child(5) > td:nth-child(2)", "Posted");
    }
}

