/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.web;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.award.web.AwardSeleniumHelper;
import org.kuali.kra.test.infrastructure.KcSeleniumTestBase;

public class AwardDataValidationPanelSeleniumTest
extends KcSeleniumTestBase {
    private static final String DATA_VALIDATION_TAB_ID = "Data Validation";
    private static final String TERMS_VALIDATION_ERRORS_TAB_ID = "Terms Validation Errors";
    private static final String REPORTS_VALIDATION_ERRORS_TAB_ID = "Reports Validation Errors";
    private static final String ERROR_TERMS = "There must be at least one Equipment Approval Terms defined.";
    private static final String ERROR_REPORTS = "There are no reports defined";
    private static final String ACTIVATE_BUTTON = "methodToCall.activate";
    private static final String DEACTIVATE_BUTTON = "methodToCall.deactivate";
    private AwardSeleniumHelper helper;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.helper = AwardSeleniumHelper.instance(driver);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.helper = null;
        super.tearDown();
    }

    @Test
    public void testTurnOnOffDataValidationAfterActivate() throws Exception {
        this.helper.createAward();
        this.helper.clickAwardActionsPage();
        this.helper.openTab(DATA_VALIDATION_TAB_ID);
        this.helper.click(ACTIVATE_BUTTON);
        this.helper.saveDocument();
        this.helper.assertNoPageErrors();
        this.helper.openTab(TERMS_VALIDATION_ERRORS_TAB_ID);
        this.helper.openTab(REPORTS_VALIDATION_ERRORS_TAB_ID);
        this.helper.assertPageContains(ERROR_TERMS);
        this.helper.assertPageContains(ERROR_REPORTS);
        this.helper.click(DEACTIVATE_BUTTON);
        this.helper.saveDocument();
        this.helper.assertNoPageErrors();
        this.helper.assertPageDoesNotContain(ERROR_TERMS);
        this.helper.assertPageDoesNotContain(ERROR_REPORTS);
    }
}

