/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.web;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.award.web.AwardSeleniumHelper;
import org.kuali.kra.test.infrastructure.KcSeleniumTestBase;
import org.kuali.kra.timeandmoney.web.TimeAndMoneySeleniumHelper;

public class AwardDirectFandADistributionPanelSeleniumTest
extends KcSeleniumTestBase {
    private static final String TAB_ID = "Direct FA Funds Distribution";
    private static final String BEAN_PREFIX = "awardDirectFandADistributionBean.newAwardDirectFandADistribution.";
    private static final String LIST_PREFIX = "document.award.awardDirectFandADistributions[0].";
    private static final String START_DATE_ID = "startDate";
    private static final String END_DATE_ID = "endDate";
    private static final String DIRECT_COST_ID = "directCost";
    private static final String INDIRECT_COST_ID = "indirectCost";
    private static final String BEAN_START_DATE_ID = "awardDirectFandADistributionBean.newAwardDirectFandADistribution.startDate";
    private static final String BEAN_END_DATE_ID = "awardDirectFandADistributionBean.newAwardDirectFandADistribution.endDate";
    private static final String BEAN_DIRECT_COST_ID = "awardDirectFandADistributionBean.newAwardDirectFandADistribution.directCost";
    private static final String BEAN_INDIRECT_COST_ID = "awardDirectFandADistributionBean.newAwardDirectFandADistribution.indirectCost";
    private static final String LIST_END_DATE_ID = "document.award.awardDirectFandADistributions[0].endDate";
    private static final String START_DATE = "01/02/2010";
    private static final String END_DATE_FIRST = "01/01/2010";
    private static final String END_DATE_MIDDLE = "01/31/2010";
    private static final String END_DATE_LAST = "03/28/2010";
    private static final String TEN_THOUSAND = "10000";
    private static final String TWENTY_FIVE_THOUSAND = "25000";
    private static final String ADD_AWARD_DIRECT_F_AND_A_DISTRIBUTION_BUTTON = "methodToCall.addAwardDirectFandADistribution.anchorDirectFAFundsDistribution";
    private AwardSeleniumHelper awardHelper;
    private TimeAndMoneySeleniumHelper timeAndMoneyHelper;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.awardHelper = AwardSeleniumHelper.instance(driver);
        this.timeAndMoneyHelper = TimeAndMoneySeleniumHelper.instance(driver);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.awardHelper = null;
        this.timeAndMoneyHelper = null;
        super.tearDown();
    }

    @Test
    public void testAddDirectFandADistribution() throws Exception {
        this.awardHelper.createAward();
        this.awardHelper.openTimeAndMoneyDocument();
        this.timeAndMoneyHelper.openTab(TAB_ID);
        this.timeAndMoneyHelper.set(BEAN_START_DATE_ID, START_DATE);
        this.timeAndMoneyHelper.set(BEAN_END_DATE_ID, END_DATE_MIDDLE);
        this.timeAndMoneyHelper.set(BEAN_DIRECT_COST_ID, TEN_THOUSAND);
        this.timeAndMoneyHelper.set(BEAN_INDIRECT_COST_ID, TWENTY_FIVE_THOUSAND);
        this.timeAndMoneyHelper.click(ADD_AWARD_DIRECT_F_AND_A_DISTRIBUTION_BUTTON);
        this.timeAndMoneyHelper.assertPageErrors();
        this.timeAndMoneyHelper.set(LIST_END_DATE_ID, END_DATE_FIRST);
        this.timeAndMoneyHelper.saveDocument();
        this.timeAndMoneyHelper.assertNoPageErrors();
    }

    @Test
    public void testSaveOverlappingDateFields() throws Exception {
        this.awardHelper.createAward();
        this.awardHelper.openTimeAndMoneyDocument();
        this.timeAndMoneyHelper.openTab(TAB_ID);
        this.timeAndMoneyHelper.saveDocument();
        this.timeAndMoneyHelper.assertNoPageErrors();
        this.timeAndMoneyHelper.set(LIST_END_DATE_ID, END_DATE_FIRST);
        this.timeAndMoneyHelper.saveDocument();
        this.timeAndMoneyHelper.assertNoPageErrors();
        this.timeAndMoneyHelper.set(BEAN_START_DATE_ID, START_DATE);
        this.timeAndMoneyHelper.set(BEAN_END_DATE_ID, END_DATE_MIDDLE);
        this.timeAndMoneyHelper.set(BEAN_DIRECT_COST_ID, TEN_THOUSAND);
        this.timeAndMoneyHelper.set(BEAN_INDIRECT_COST_ID, TWENTY_FIVE_THOUSAND);
        this.timeAndMoneyHelper.click(ADD_AWARD_DIRECT_F_AND_A_DISTRIBUTION_BUTTON);
        this.timeAndMoneyHelper.saveDocument();
        this.timeAndMoneyHelper.assertNoPageErrors();
        this.timeAndMoneyHelper.set(LIST_END_DATE_ID, END_DATE_LAST);
        this.timeAndMoneyHelper.saveDocument();
        this.timeAndMoneyHelper.assertPageErrors();
    }
}

