/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.web;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.award.web.AwardSeleniumHelper;
import org.kuali.kra.test.infrastructure.KcSeleniumTestBase;

public class AwardReportsPanelSeleniumTest
extends KcSeleniumTestBase {
    private static final String TAB_ID = "Reports";
    private static final String ERROR_PANEL_ID = "tab-ReportClasses:Financial-div";
    private static final String SUB_TAB_ID = "div[class='innerTab-head']";
    private static final String FINANCIAL_TAB_ID = "ReportClasses:Financial";
    private static final String PROPERTY_TAB_ID = "ReportClasses:Property";
    private static final String BEAN_PREFIX = "awardReportsBean.newAwardReportTerms[%d].";
    private static final String LIST_PREFIX = "document.awardList[0].";
    private static final String REPORT_CODE_ID = "reportCode";
    private static final String FREQUENCY_CODE_ID = "frequencyCode";
    private static final String FREQUENCY_BASE_CODE_ID = "frequencyBaseCode";
    private static final String OSP_DISTRIBUTION_CODE_ID = "ospDistributionCode";
    private static final String DUE_DATE_ID = "dueDate";
    private static final String ROLODEX_ID_ID = "rolodexId";
    private static final String SUB_PLAN_FLAG_ID = "subPlanFlag";
    private static final String PROCUREMENT_PRIORITY_CODE_ID = "procurementPriorityCode";
    private static final String BEAN_REPORT_CODE_FINANCIAL_ID = String.format("awardReportsBean.newAwardReportTerms[%d].", 0) + "reportCode";
    private static final String BEAN_FREQUENCY_CODE_FINANCIAL_ID = String.format("awardReportsBean.newAwardReportTerms[%d].", 0) + "frequencyCode";
    private static final String BEAN_FREQUENCY_BASE_CODE_FINANCIAL_ID = String.format("awardReportsBean.newAwardReportTerms[%d].", 0) + "frequencyBaseCode";
    private static final String BEAN_OSP_DISTRIBUTION_CODE_FINANCIAL_ID = String.format("awardReportsBean.newAwardReportTerms[%d].", 0) + "ospDistributionCode";
    private static final String BEAN_DUE_DATE_FINANCIAL_ID = String.format("awardReportsBean.newAwardReportTerms[%d].", 0) + "dueDate";
    private static final String BEAN_REPORT_CODE_PROPERTY_ID = String.format("awardReportsBean.newAwardReportTerms[%d].", 4) + "reportCode";
    private static final String BEAN_FREQUENCY_CODE_PROPERTY_ID = String.format("awardReportsBean.newAwardReportTerms[%d].", 4) + "frequencyCode";
    private static final String BEAN_FREQUENCY_BASE_CODE_PROPERTY_ID = String.format("awardReportsBean.newAwardReportTerms[%d].", 4) + "frequencyBaseCode";
    private static final String BEAN_OSP_DISTRIBUTION_CODE_PROPERTY_ID = String.format("awardReportsBean.newAwardReportTerms[%d].", 4) + "ospDistributionCode";
    private static final String BEAN_DUE_DATE_PROPERTY_ID = String.format("awardReportsBean.newAwardReportTerms[%d].", 4) + "dueDate";
    private static final String LIST_SUB_PLAN_FLAG_ID = "document.awardList[0].subPlanFlag";
    private static final String LIST_PROCUREMENT_PRIORITY_CODE_ID = "document.awardList[0].procurementPriorityCode";
    private static final String FINANCIAL_LABEL = "Financial (%d)";
    private static final String PROPERTY_LABEL = "Property (%d)";
    private static final String REPORT_CODE_FINANCIAL = "Final (Final Report)";
    private static final String REPORT_CODE_PROPERTY = "SF 1018 (Final Report)";
    private static final String FREQUENCY_CODE = "As required";
    private static final String FREQUENCY_BASE_CODE = "Project Start Date";
    private static final String OSP_DISTRIBUTION_CODE_EMPTY = "select";
    private static final String OSP_DISTRIBUTION_CODE_FINANCIAL = "Report";
    private static final String OSP_DISTRIBUTION_CODE_PROPERTY = "Letter Only";
    private static final String DUE_DATE = "06/30/2008";
    private static final String ROLODEX_ID = "18725";
    private static final String SUB_PLAN_FLAG = "Required";
    private static final String PROCUREMENT_PRIORITY_CODE = "DO0076";
    private static final String ERROR_REPORT_CODE_REQUIRED = "Type (Type) is a required field";
    private static final String ERROR_FREQUENCY_CODE_REQUIRED_WITH_OSP = "Frequency is required if OSP File Copy is selected";
    private static final String ERROR_OSP_DISTRIBUTION_REQUIRED_WITH_FREQUENCY = "OSP File Copy is required for a final report if Frequency is selected.";
    private static final String ADD_AWARD_REPORT_TERM_FINANCIAL_BUTTON = "methodToCall.addAwardReportTerm.reportClass1.reportClassIndex0";
    private static final String DELETE_AWARD_REPORT_TERM_FINANCIAL_BUTTON = "methodToCall.deleteAwardReportTerm.line0";
    private static final String ADD_AWARD_REPORT_TERM_PROPERTY_BUTTON = "methodToCall.addAwardReportTerm.reportClass2.reportClassIndex4";
    private static final String DELETE_AWARD_REPORT_TERM_PROPERTY_BUTTON = "methodToCall.deleteAwardReportTerm.line0";
    private static final String ADD_RECIPIENT_BUTTON = "methodToCall.addRecipient.awardReportTerm0";
    private AwardSeleniumHelper helper;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.helper = AwardSeleniumHelper.instance(driver);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.helper = null;
        super.tearDown();
    }

    @Test
    public void testAddDeleteFinancialNoErrors() throws Exception {
        this.helper.createAward();
        this.helper.addContacts();
        this.helper.clickAwardPaymentReportsAndTermsPage();
        this.helper.openTab(TAB_ID);
        this.helper.assertSelectorContains(SUB_TAB_ID, String.format(FINANCIAL_LABEL, 0));
        this.helper.openTab(FINANCIAL_TAB_ID);
        this.helper.set(BEAN_REPORT_CODE_FINANCIAL_ID, REPORT_CODE_FINANCIAL);
        this.helper.set(BEAN_FREQUENCY_CODE_FINANCIAL_ID, FREQUENCY_CODE);
        this.helper.set(BEAN_FREQUENCY_BASE_CODE_FINANCIAL_ID, FREQUENCY_BASE_CODE);
        this.helper.set(BEAN_OSP_DISTRIBUTION_CODE_FINANCIAL_ID, OSP_DISTRIBUTION_CODE_FINANCIAL);
        this.helper.set(BEAN_DUE_DATE_FINANCIAL_ID, DUE_DATE);
        this.helper.click(ADD_AWARD_REPORT_TERM_FINANCIAL_BUTTON);
        this.helper.saveDocument();
        this.helper.assertNoPageErrors();
        this.helper.assertSelectorContains(SUB_TAB_ID, String.format(FINANCIAL_LABEL, 1));
        this.helper.click("methodToCall.deleteAwardReportTerm.line0");
        this.helper.saveDocument();
        this.helper.assertNoPageErrors();
        this.helper.assertSelectorContains(SUB_TAB_ID, String.format(FINANCIAL_LABEL, 0));
    }

    @Test
    public void testAddFinancialErrors() throws Exception {
        this.helper.createAward();
        this.helper.addContacts();
        this.helper.clickAwardPaymentReportsAndTermsPage();
        this.helper.openTab(TAB_ID);
        this.helper.openTab(FINANCIAL_TAB_ID);
        this.helper.set(BEAN_OSP_DISTRIBUTION_CODE_FINANCIAL_ID, OSP_DISTRIBUTION_CODE_FINANCIAL);
        this.helper.click(ADD_AWARD_REPORT_TERM_FINANCIAL_BUTTON);
        this.helper.assertErrorCount(ERROR_PANEL_ID, 2);
        this.helper.assertError(ERROR_PANEL_ID, ERROR_REPORT_CODE_REQUIRED);
        this.helper.assertError(ERROR_PANEL_ID, ERROR_FREQUENCY_CODE_REQUIRED_WITH_OSP);
        this.helper.set(BEAN_REPORT_CODE_FINANCIAL_ID, REPORT_CODE_FINANCIAL);
        this.helper.set(BEAN_FREQUENCY_CODE_FINANCIAL_ID, FREQUENCY_CODE);
        this.helper.set(BEAN_FREQUENCY_BASE_CODE_FINANCIAL_ID, FREQUENCY_BASE_CODE);
        this.helper.set(BEAN_OSP_DISTRIBUTION_CODE_FINANCIAL_ID, OSP_DISTRIBUTION_CODE_EMPTY);
        this.helper.click(ADD_AWARD_REPORT_TERM_FINANCIAL_BUTTON);
        this.helper.assertErrorCount(ERROR_PANEL_ID, 1);
        this.helper.assertError(ERROR_PANEL_ID, ERROR_OSP_DISTRIBUTION_REQUIRED_WITH_FREQUENCY);
    }

    @Test
    public void testAddFinancialRecipients() throws Exception {
        this.helper.createAward();
        this.helper.addContacts();
        this.helper.clickAwardPaymentReportsAndTermsPage();
        this.helper.openTab(TAB_ID);
        this.helper.openTab(FINANCIAL_TAB_ID);
        this.helper.set(BEAN_REPORT_CODE_FINANCIAL_ID, REPORT_CODE_FINANCIAL);
        this.helper.set(BEAN_FREQUENCY_CODE_FINANCIAL_ID, FREQUENCY_CODE);
        this.helper.set(BEAN_FREQUENCY_BASE_CODE_FINANCIAL_ID, FREQUENCY_BASE_CODE);
        this.helper.set(BEAN_OSP_DISTRIBUTION_CODE_FINANCIAL_ID, OSP_DISTRIBUTION_CODE_FINANCIAL);
        this.helper.set(BEAN_DUE_DATE_FINANCIAL_ID, DUE_DATE);
        this.helper.click(ADD_AWARD_REPORT_TERM_FINANCIAL_BUTTON);
        this.helper.saveDocument();
        this.helper.assertNoPageErrors();
        this.helper.openTab(3);
        this.helper.lookup(ROLODEX_ID_ID, ROLODEX_ID_ID, ROLODEX_ID);
        this.helper.click(ADD_RECIPIENT_BUTTON);
        this.helper.saveDocument();
        this.helper.assertNoPageErrors();
    }

    @Test
    public void testAddDeleteProperty() throws Exception {
        this.helper.createAward();
        this.helper.addContacts();
        this.helper.clickAwardPaymentReportsAndTermsPage();
        this.helper.openTab(TAB_ID);
        this.helper.assertSelectorContains(SUB_TAB_ID, String.format(PROPERTY_LABEL, 0));
        this.helper.openTab(PROPERTY_TAB_ID);
        this.helper.set(BEAN_REPORT_CODE_PROPERTY_ID, REPORT_CODE_PROPERTY);
        this.helper.set(BEAN_FREQUENCY_CODE_PROPERTY_ID, FREQUENCY_CODE);
        this.helper.set(BEAN_FREQUENCY_BASE_CODE_PROPERTY_ID, FREQUENCY_BASE_CODE);
        this.helper.set(BEAN_OSP_DISTRIBUTION_CODE_PROPERTY_ID, OSP_DISTRIBUTION_CODE_PROPERTY);
        this.helper.set(BEAN_DUE_DATE_PROPERTY_ID, DUE_DATE);
        this.helper.click(ADD_AWARD_REPORT_TERM_PROPERTY_BUTTON);
        this.helper.saveDocument();
        this.helper.assertNoPageErrors();
        this.helper.assertSelectorContains(SUB_TAB_ID, String.format(PROPERTY_LABEL, 1));
        this.helper.click("methodToCall.deleteAwardReportTerm.line0");
        this.helper.saveDocument();
        this.helper.assertNoPageErrors();
        this.helper.assertSelectorContains(SUB_TAB_ID, String.format(PROPERTY_LABEL, 0));
    }

    @Test
    public void testModifyMiscellaneousProcurementPurchasing() throws Exception {
        this.helper.createAward();
        this.helper.addContacts();
        this.helper.clickAwardPaymentReportsAndTermsPage();
        this.helper.openTab(TAB_ID);
        this.helper.set(LIST_SUB_PLAN_FLAG_ID, SUB_PLAN_FLAG);
        this.helper.set(LIST_PROCUREMENT_PRIORITY_CODE_ID, PROCUREMENT_PRIORITY_CODE);
        this.helper.saveDocument();
        this.helper.assertNoPageErrors();
        this.helper.assertElementContains(LIST_SUB_PLAN_FLAG_ID, SUB_PLAN_FLAG);
        this.helper.assertElementContains(LIST_PROCUREMENT_PRIORITY_CODE_ID, PROCUREMENT_PRIORITY_CODE);
    }
}

