/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.web;

import org.apache.commons.lang.StringUtils;
import org.kuali.kra.test.infrastructure.KcSeleniumHelper;
import org.openqa.selenium.WebDriver;

public class AwardSeleniumHelper
extends KcSeleniumHelper {
    private static final String PAGE_TITLE = "Kuali :: KC Award";
    private static final String CREATE_AWARD_LINK_NAME = "Award";
    private static final String HOME_LINK_NAME = "home";
    private static final String CONTACTS_LINK_NAME = "contacts";
    private static final String COMMITMENTS_LINK_NAME = "commitments";
    private static final String BUDGET_VERSIONS_LINK_NAME = "budgets";
    private static final String PAYMENT_REPORTS_AND_TERMS_LINK_NAME = "paymentReportsAndTerms";
    private static final String SPECIAL_REVIEW_LINK_NAME = "specialReview";
    private static final String CUSTOM_DATA_LINK_NAME = "customData";
    private static final String COMMENTS_NOTES_AND_ATTACHMENTS_LINK_NAME = "notesAndAttachments";
    private static final String ACTIONS_LINK_NAME = "awardActions";
    private static final String MEDUSA_LINK_NAME = "medusa";
    private static final String TIME_AND_MONEY_LINK_NAME = "methodToCall.timeAndMoney";
    private static final String SPONSOR_TEMPLATE_TAB_ID = "Sponsor Template";
    private static final String KEY_PERSONNEL_AND_CREDIT_SPLIT_TAB_ID = "Key Personnel and Credit Split";
    private static final String PERSONNEL_ITEMS_FOR_REVIEW_TAB_ID = "Personnel Items for Review";
    private static final String ASDF_TAB_ID = "asdf asdf asdf asdf asdf asdf asdf asdf asdf asdf asdf asdf asdf asdf asdf asdf asdf asdf";
    private static final String DOCUMENT_DESCRIPTION_ID = "document.documentHeader.documentDescription";
    private static final String LIST_PREFIX = "document.awardList[0].";
    private static final String TRANSACTION_TYPE_CODE_ID = "document.awardList[0].awardTransactionTypeCode";
    private static final String UNIT_NUMBER_ID = "document.awardList[0].unitNumber";
    private static final String ACTIVITY_TYPE_CODE_ID = "document.awardList[0].activityTypeCode";
    private static final String STATUS_CODE_ID = "document.awardList[0].statusCode";
    private static final String TYPE_CODE_ID = "document.awardList[0].awardTypeCode";
    private static final String TITLE_ID = "document.awardList[0].title";
    private static final String SPONSOR_CODE_ID = "document.awardList[0].sponsorCode";
    private static final String PRIME_SPONSOR_CODE_ID = "document.awardList[0].primeSponsorCode";
    private static final String SPONSOR_AWARD_NUMBER_ID = "document.awardList[0].sponsorAwardNumber";
    private static final String MODIFICATION_NUMBER_ID = "document.awardList[0].modificationNumber";
    private static final String EFFECTIVE_DATE_ID = "document.awardList[0].awardEffectiveDate";
    private static final String CURRENT_FUND_EFFECTIVE_DATE_ID = "document.awardList[0].awardAmountInfos[0].currentFundEffectiveDate";
    private static final String FINAL_EXPIRATION_DATE_ID = "document.awardList[0].awardAmountInfos[0].finalExpirationDate";
    private static final String OBLIGATION_EXPIRATION_DATE_ID = "document.awardList[0].awardAmountInfos[0].obligationExpirationDate";
    private static final String ANTICIPATED_AMOUNT_ID = "document.awardList[0].awardAmountInfos[0].anticipatedTotalAmount";
    private static final String OBLIGATED_AMOUNT_ID = "document.awardList[0].awardAmountInfos[0].amountObligatedToDate";
    private static final String TEMPLATE_CODE_TAG = "document.award.templateCode";
    private static final String PERSON_NAME_TAG = "projectPersonnelBean.newProjectPerson.person.fullName";
    private static final String CONTACT_ROLE_CODE_ID = "projectPersonnelBean.contactRoleCode";
    private static final String CREDIT_SPLITS_ID = "document.awardList[0].projectPersons[0].creditSplits[%d].credit";
    private static final String UNIT_CREDIT_SPLITS_ID = "document.awardList[0].projectPersons[0].units[0].creditSplits[%d].credit";
    private static final String GRADUATE_STUDENT_COUNT_ID = "customDataHelper.customDataValues[3].value";
    private static final String BILLING_ELEMENT_ID = "customDataHelper.customDataValues[0].value";
    private static final String NEW_BUDGET_VERSION_NAME_ID = "newBudgetVersionName";
    private static final String FINAL_VERSION_FLAG_ID = "document.budgetDocumentVersion[%d].budgetVersionOverview.finalVersionFlag";
    private static final String BUDGET_VERSION_ID = "document.budgetDocumentVersion[%d].budgetVersionOverview.budgetStatus";
    private static final String DEFAULT_DOCUMENT_DESCRIPTION = "Award Development Web Test";
    private static final String DEFAULT_TRANSACTION_TYPE = "New";
    private static final String DEFAULT_ACTIVITY_TYPE = "Instruction";
    private static final String DEFAULT_STATUS = "Active";
    private static final String DEFAULT_TYPE = "Grant";
    private static final String DEFAULT_TITLE = "Award Title";
    private static final String DEFAULT_SPONSOR_CODE = "005979";
    private static final String DEFAULT_SPONSOR_AWARD_NUMBER = "1R01CA123456";
    private static final String DEFAULT_MODIFICATION_NUMBER = "1";
    private static final String DEFAULT_BEGIN_DATE = "03/01/2009";
    private static final String DEFAULT_MIDDLE_DATE = "04/01/2009";
    private static final String DEFAULT_END_DATE = "09/01/2010";
    private static final String DEFAULT_AMOUNT = "10000.00";
    private static final String DEFAULT_SPONSOR_TEMPLATE_CODE = "1";
    private static final String DEFAULT_PI_PERSON_NAME = "majors";
    private static final String DEFAULT_PI_CONTACT_ROLE = "Principal Investigator";
    private static final String DEFAULT_TOTAL_CREDIT_SPLIT = "100";
    private static final String DEFAULT_GRADUATE_STUDENT_COUNT = "5";
    private static final String DEFAULT_BILLING_ELEMENT = "College";
    private static final String DEFAULT_BUDGET_VERSION_NAME = "Ver1";
    private static final String DEFAULT_BUDGET_STATUS = "Complete";
    private static final String ADD_PERSON_BUTTON = "methodToCall.addProjectPerson";
    private static final String ADD_NEW_BUDGET_BUTTON = "methodToCall.addBudgetVersion";
    private static final String OPEN_BUDGET_BUTTON = "methodToCall.openBudgetVersion.line";
    private static final String APPLY_AWARD_TEMPLATE_BUTTON = "methodToCall.applySponsorTemplate";
    private static AwardSeleniumHelper helper;

    public static AwardSeleniumHelper instance(WebDriver driver) {
        if (helper == null) {
            helper = new AwardSeleniumHelper(driver);
        }
        return helper;
    }

    private AwardSeleniumHelper(WebDriver driver) {
        super(driver);
    }

    public void clickAwardHomePage() {
        this.click(HOME_LINK_NAME);
    }

    public void clickAwardContactsPage() {
        this.click(CONTACTS_LINK_NAME);
    }

    public void clickAwardCommitmentsPage() {
        this.click(COMMITMENTS_LINK_NAME);
    }

    public void clickAwardBudgetVersionsPage() {
        this.click(BUDGET_VERSIONS_LINK_NAME);
    }

    public void clickAwardPaymentReportsAndTermsPage() {
        this.click(PAYMENT_REPORTS_AND_TERMS_LINK_NAME);
    }

    public void clickAwardSpecialReviewPage() {
        this.click(SPECIAL_REVIEW_LINK_NAME);
    }

    public void clickAwardCustomDataPage() {
        this.click(CUSTOM_DATA_LINK_NAME);
    }

    public void clickAwardCommentsNotesAndAttachmentsPage() {
        this.click(COMMENTS_NOTES_AND_ATTACHMENTS_LINK_NAME);
    }

    public void clickAwardActionsPage() {
        this.click(ACTIONS_LINK_NAME);
    }

    public void clickAwardMedusaPage() {
        this.click(MEDUSA_LINK_NAME);
    }

    public void openTimeAndMoneyDocument() {
        this.click(TIME_AND_MONEY_LINK_NAME);
    }

    @Override
    public String getDocumentNumber() {
        String locator = "//div[@id='headerarea']/div/table/tbody/tr[1]/td[2]";
        return StringUtils.substringBefore((String)this.getDocumentNumber("//div[@id='headerarea']/div/table/tbody/tr[1]/td[2]"), (String)":");
    }

    public final void createAward() {
        this.clickCentralAdminTab();
        this.click(CREATE_AWARD_LINK_NAME);
        this.assertTitleContains(PAGE_TITLE);
        this.setDefaultRequiredFields();
        this.saveDocument();
        this.assertSave();
    }

    private void setDefaultRequiredFields() {
        this.set(DOCUMENT_DESCRIPTION_ID, DEFAULT_DOCUMENT_DESCRIPTION);
        this.set(TRANSACTION_TYPE_CODE_ID, DEFAULT_TRANSACTION_TYPE);
        this.set(UNIT_NUMBER_ID, "000001");
        this.set(ACTIVITY_TYPE_CODE_ID, DEFAULT_ACTIVITY_TYPE);
        this.set(STATUS_CODE_ID, DEFAULT_STATUS);
        this.set(TYPE_CODE_ID, DEFAULT_TYPE);
        this.set(TITLE_ID, DEFAULT_TITLE);
        this.set(SPONSOR_CODE_ID, DEFAULT_SPONSOR_CODE);
        this.set(PRIME_SPONSOR_CODE_ID, DEFAULT_SPONSOR_CODE);
        this.set(SPONSOR_AWARD_NUMBER_ID, DEFAULT_SPONSOR_AWARD_NUMBER);
        this.set(MODIFICATION_NUMBER_ID, "1");
        this.set(EFFECTIVE_DATE_ID, DEFAULT_BEGIN_DATE);
        this.set(CURRENT_FUND_EFFECTIVE_DATE_ID, DEFAULT_BEGIN_DATE);
        this.set(FINAL_EXPIRATION_DATE_ID, DEFAULT_END_DATE);
        this.set(OBLIGATION_EXPIRATION_DATE_ID, DEFAULT_MIDDLE_DATE);
        this.set(ANTICIPATED_AMOUNT_ID, DEFAULT_AMOUNT);
        this.set(OBLIGATED_AMOUNT_ID, DEFAULT_AMOUNT);
    }

    public void addSponsorTemplate() {
        this.clickAwardHomePage();
        this.openTab(SPONSOR_TEMPLATE_TAB_ID);
        this.set(TEMPLATE_CODE_TAG, "1");
        this.click(APPLY_AWARD_TEMPLATE_BUTTON);
        this.clickYesAnswer();
        this.clickYesAnswer();
    }

    public void addContacts() {
        this.clickAwardContactsPage();
        this.openTab(KEY_PERSONNEL_AND_CREDIT_SPLIT_TAB_ID);
        this.set(PERSON_NAME_TAG, DEFAULT_PI_PERSON_NAME);
        this.set(CONTACT_ROLE_CODE_ID, DEFAULT_PI_CONTACT_ROLE);
        this.click(ADD_PERSON_BUTTON);
        for (int i = 0; i < 4; ++i) {
            this.set(String.format(CREDIT_SPLITS_ID, i), DEFAULT_TOTAL_CREDIT_SPLIT);
            this.set(String.format(UNIT_CREDIT_SPLITS_ID, i), DEFAULT_TOTAL_CREDIT_SPLIT);
        }
    }

    public void addCustomData() {
        this.clickAwardCustomDataPage();
        this.openTab(PERSONNEL_ITEMS_FOR_REVIEW_TAB_ID);
        this.set(GRADUATE_STUDENT_COUNT_ID, DEFAULT_GRADUATE_STUDENT_COUNT);
        this.openTab(ASDF_TAB_ID);
        this.set(BILLING_ELEMENT_ID, DEFAULT_BILLING_ELEMENT);
    }

    public void addBudget() {
        this.clickAwardBudgetVersionsPage();
        this.set(NEW_BUDGET_VERSION_NAME_ID, DEFAULT_BUDGET_VERSION_NAME);
        this.click(ADD_NEW_BUDGET_BUTTON);
        this.assertSelectorContains(".budgetline td", DEFAULT_BUDGET_VERSION_NAME);
    }

    public void openBudget(int budgetNumber) {
        this.clickAwardBudgetVersionsPage();
        this.click(OPEN_BUDGET_BUTTON + String.valueOf(budgetNumber));
    }

    public void finalizeBudget(int budgetNumber) {
        this.clickAwardBudgetVersionsPage();
        this.click(String.format(FINAL_VERSION_FLAG_ID, budgetNumber));
        this.set(String.format(BUDGET_VERSION_ID, budgetNumber), DEFAULT_BUDGET_STATUS);
    }

    public void submit() {
        this.clickAwardActionsPage();
        this.dismissAlert();
        this.routeDocument();
        this.clickYesAnswer();
        this.assertRoute();
    }
}

