/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.web;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.award.web.AwardSeleniumHelper;
import org.kuali.kra.test.infrastructure.KcSeleniumTestBase;

public class AwardSpecialReviewSeleniumTest
extends KcSeleniumTestBase {
    private static final String TABLE_ID = "specialReviewTableId";
    private static final String ERROR_PANEL_ID = "tab-SpecialReview-div";
    private static final String HELPER_PREFIX = "specialReviewHelper.newSpecialReview.";
    private static final String LIST_PREFIX = "document.awardList[0].specialReviews[%d].";
    private static final String SPECIAL_REVIEW_TYPE_CODE_ID = "specialReviewTypeCode";
    private static final String APPROVAL_TYPE_CODE_ID = "approvalTypeCode";
    private static final String PROTOCOL_NUMBER_ID = "protocolNumber";
    private static final String APPLICATION_DATE_ID = "applicationDate";
    private static final String APPROVAL_DATE_ID = "approvalDate";
    private static final String EXPIRATION_DATE_ID = "expirationDate";
    private static final String EXEMPTION_TYPE_CODES_ID = "exemptionTypeCodes";
    private static final String COMMENTS_ID = "comments";
    private static final String HELPER_SPECIAL_REVIEW_TYPE_CODE_ID = "specialReviewHelper.newSpecialReview.specialReviewTypeCode";
    private static final String HELPER_APPROVAL_TYPE_CODE_ID = "specialReviewHelper.newSpecialReview.approvalTypeCode";
    private static final String HELPER_PROTOCOL_NUMBER_ID = "specialReviewHelper.newSpecialReview.protocolNumber";
    private static final String HELPER_APPLICATION_DATE_ID = "specialReviewHelper.newSpecialReview.applicationDate";
    private static final String HELPER_APPROVAL_DATE_ID = "specialReviewHelper.newSpecialReview.approvalDate";
    private static final String HELPER_EXPIRATION_DATE_ID = "specialReviewHelper.newSpecialReview.expirationDate";
    private static final String HELPER_EXEMPTION_TYPE_CODES_ID = "specialReviewHelper.newSpecialReview.exemptionTypeCodes";
    private static final String HELPER_COMMENTS_ID = "specialReviewHelper.newSpecialReview.comments";
    private static final String LIST_SPECIAL_REVIEW_TYPE_CODE_ID = "document.awardList[0].specialReviews[%d].specialReviewTypeCode";
    private static final String LIST_APPROVAL_TYPE_CODE_ID = "document.awardList[0].specialReviews[%d].approvalTypeCode";
    private static final String LIST_PROTOCOL_NUMBER_ID = "document.awardList[0].specialReviews[%d].protocolNumber";
    private static final String LIST_APPLICATION_DATE_ID = "document.awardList[0].specialReviews[%d].applicationDate";
    private static final String LIST_APPROVAL_DATE_ID = "document.awardList[0].specialReviews[%d].approvalDate";
    private static final String LIST_EXPIRATION_DATE_ID = "document.awardList[0].specialReviews[%d].expirationDate";
    private static final String LIST_EXEMPTION_TYPE_CODES_ID = "document.awardList[0].specialReviews[%d].exemptionTypeCodes";
    private static final String LIST_COMMENTS_ID = "document.awardList[0].specialReviews[%d].comments";
    private static final String SPECIAL_REVIEW_TYPE_NAME = "Animal Usage";
    private static final String APPROVAL_TYPE_APPROVED_NAME = "Approved";
    private static final String APPROVAL_TYPE_EXEMPT_NAME = "Exempt";
    private static final String PROTOCOL_NUMBER = "1000000001";
    private static final String APPLICATION_DATE = "01/01/2009";
    private static final String APPROVAL_DATE = "02/01/2009";
    private static final String EXPIRATION_DATE = "03/01/2009";
    private static final String COMMENTS = "This is a test";
    private static final String EXEMPTION_TYPE_E1_NAME = "E1";
    private static final String ADD_SPECIAL_REVIEW_BUTTON = "methodToCall.addSpecialReview";
    private static final String DELETE_SPECIAL_REVIEW_BUTTON = "methodToCall.deleteSpecialReview.line%d";
    private AwardSeleniumHelper helper;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.helper = AwardSeleniumHelper.instance(driver);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.helper = null;
        super.tearDown();
    }

    @Test
    public void testAddApprovedSpecialReview() throws Exception {
        this.helper.createAward();
        this.helper.clickAwardSpecialReviewPage();
        this.setApprovedSpecialReviewFields();
        this.helper.click(ADD_SPECIAL_REVIEW_BUTTON);
        this.helper.assertNoPageErrors();
        this.checkRow(SPECIAL_REVIEW_TYPE_NAME, APPROVAL_TYPE_APPROVED_NAME, PROTOCOL_NUMBER, APPLICATION_DATE, APPROVAL_DATE, EXPIRATION_DATE, Collections.<String>emptyList(), COMMENTS, 0);
        this.helper.closeAndSearchDocument();
        this.helper.clickAwardSpecialReviewPage();
        this.checkRow(SPECIAL_REVIEW_TYPE_NAME, APPROVAL_TYPE_APPROVED_NAME, PROTOCOL_NUMBER, APPLICATION_DATE, APPROVAL_DATE, EXPIRATION_DATE, Collections.<String>emptyList(), COMMENTS, 0);
    }

    @Test
    public void testAddExemptSpecialReview() throws Exception {
        this.helper.createAward();
        this.helper.clickAwardSpecialReviewPage();
        this.setExemptSpecialReviewFields();
        this.helper.click(ADD_SPECIAL_REVIEW_BUTTON);
        this.helper.assertNoPageErrors();
        this.checkRow(SPECIAL_REVIEW_TYPE_NAME, APPROVAL_TYPE_EXEMPT_NAME, "", APPLICATION_DATE, "", EXPIRATION_DATE, Collections.singletonList(EXEMPTION_TYPE_E1_NAME), COMMENTS, 0);
        this.helper.closeAndSearchDocument();
        this.helper.clickAwardSpecialReviewPage();
        this.checkRow(SPECIAL_REVIEW_TYPE_NAME, APPROVAL_TYPE_EXEMPT_NAME, "", APPLICATION_DATE, "", EXPIRATION_DATE, Collections.singletonList(EXEMPTION_TYPE_E1_NAME), COMMENTS, 0);
    }

    @Test
    public void testDeleteSpecialReview() throws Exception {
        this.helper.createAward();
        this.helper.clickAwardSpecialReviewPage();
        this.setApprovedSpecialReviewFields();
        this.helper.click(ADD_SPECIAL_REVIEW_BUTTON);
        this.helper.assertNoPageErrors();
        this.helper.closeAndSearchDocument();
        this.helper.clickAwardSpecialReviewPage();
        this.helper.click(String.format(DELETE_SPECIAL_REVIEW_BUTTON, 0));
        this.helper.clickYesAnswer();
        this.helper.assertTableRowCount(TABLE_ID, 3);
        this.helper.closeAndSearchDocument();
        this.helper.clickAwardSpecialReviewPage();
        this.helper.assertTableRowCount(TABLE_ID, 3);
    }

    @Test
    public void testAddErrorSpecialReview() throws Exception {
        this.helper.createAward();
        this.helper.clickAwardSpecialReviewPage();
        this.helper.click(ADD_SPECIAL_REVIEW_BUTTON);
        this.helper.assertErrorCount(ERROR_PANEL_ID, 2);
    }

    private void setApprovedSpecialReviewFields() throws IOException {
        this.helper.set(HELPER_SPECIAL_REVIEW_TYPE_CODE_ID, SPECIAL_REVIEW_TYPE_NAME);
        this.helper.set(HELPER_APPROVAL_TYPE_CODE_ID, APPROVAL_TYPE_APPROVED_NAME);
        this.helper.set(HELPER_PROTOCOL_NUMBER_ID, PROTOCOL_NUMBER);
        this.helper.set(HELPER_APPLICATION_DATE_ID, APPLICATION_DATE);
        this.helper.set(HELPER_APPROVAL_DATE_ID, APPROVAL_DATE);
        this.helper.set(HELPER_EXPIRATION_DATE_ID, EXPIRATION_DATE);
        this.helper.set(HELPER_COMMENTS_ID, COMMENTS);
    }

    private void setExemptSpecialReviewFields() {
        this.helper.set(HELPER_SPECIAL_REVIEW_TYPE_CODE_ID, SPECIAL_REVIEW_TYPE_NAME);
        this.helper.set(HELPER_APPROVAL_TYPE_CODE_ID, APPROVAL_TYPE_EXEMPT_NAME);
        this.helper.set(HELPER_APPLICATION_DATE_ID, APPLICATION_DATE);
        this.helper.set(HELPER_EXPIRATION_DATE_ID, EXPIRATION_DATE);
        this.helper.set(HELPER_EXEMPTION_TYPE_CODES_ID, EXEMPTION_TYPE_E1_NAME);
        this.helper.set(HELPER_COMMENTS_ID, COMMENTS);
    }

    private void checkRow(String type, String approvalStatus, String protocolNumber, String applicationDate, String approvalDate, String expirationDate, List<String> exemptionTypeCodes, String comments, int index) {
        this.helper.assertElementContains(String.format(LIST_SPECIAL_REVIEW_TYPE_CODE_ID, index), type);
        this.helper.assertElementContains(String.format(LIST_APPROVAL_TYPE_CODE_ID, index), approvalStatus);
        this.helper.assertElementContains(String.format(LIST_PROTOCOL_NUMBER_ID, index), protocolNumber);
        this.helper.assertElementContains(String.format(LIST_APPLICATION_DATE_ID, index), applicationDate);
        this.helper.assertElementContains(String.format(LIST_APPROVAL_DATE_ID, index), approvalDate);
        this.helper.assertElementContains(String.format(LIST_EXPIRATION_DATE_ID, index), expirationDate);
        for (String exemptionTypeCode : exemptionTypeCodes) {
            this.helper.assertSelectedOptionsContain(String.format(LIST_EXEMPTION_TYPE_CODES_ID, index), exemptionTypeCode);
        }
        this.helper.assertElementContains(String.format(LIST_COMMENTS_ID, index), comments);
    }
}

