/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.award.web.struts.action;

import java.sql.Date;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.award.commitments.AwardCostShare;
import org.kuali.kra.award.commitments.AwardFandaRate;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.web.struts.action.AwardCommitmentsAction;
import org.kuali.kra.bo.CostShareType;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public class AwardCommitmentsActionTest {
    AwardCommitmentsAction awardCommitmentsAction;
    Award award;
    AwardFandaRate awardFandaRate;
    AwardCostShare awardCostShare;
    public static final int ZERO = 0;

    @Before
    public void setUp() throws Exception {
        this.awardCommitmentsAction = new AwardCommitmentsAction();
        this.award = new Award();
        this.awardFandaRate = new AwardFandaRate();
        this.awardCostShare = new AwardCostShare();
        this.awardFandaRate.setApplicableFandaRate(new KualiDecimal(5));
        this.awardFandaRate.setFiscalYear("2008");
        this.awardFandaRate.setFandaRateTypeCode("5");
        this.awardFandaRate.setOnCampusFlag("N");
        this.awardFandaRate.setUnderrecoveryOfIndirectCost(new KualiDecimal(1000));
        this.awardFandaRate.setStartDate(new Date(new Long("1183316613046")));
        this.awardFandaRate.setEndDate(new Date(new Long("1214852613046")));
        this.awardCostShare.setCostSharePercentage(new KualiDecimal(55));
        this.awardCostShare.setCostShareType(new CostShareType());
        this.awardCostShare.setDestination("testAccount1");
        this.awardCostShare.setSource("testAccount2");
        this.awardCostShare.setProjectPeriod("2008");
        this.awardCostShare.setCommitmentAmount(new KualiDecimal(34000));
    }

    @After
    public void tearDown() throws Exception {
        this.award = null;
        this.awardFandaRate = null;
        this.awardCostShare = null;
        this.awardCommitmentsAction = null;
    }

    @Test
    public void testAddFandaRateToAward() {
        Assert.assertTrue((boolean)this.awardCommitmentsAction.addFandaRateToAward(this.award, this.awardFandaRate));
    }

    @Test
    public void testDeleteFandaRateFromAward() {
        this.awardCommitmentsAction.addFandaRateToAward(this.award, this.awardFandaRate);
        this.awardCommitmentsAction.deleteFandaRateFromAward(this.award, 0);
        Assert.assertEquals((long)0L, (long)this.award.getAwardFandaRate().size());
    }

    @Test
    public void testAddCostShare() {
        Assert.assertTrue((boolean)this.awardCommitmentsAction.addCostShareToAward(this.award, this.awardCostShare));
    }

    @Test
    public void testDeleteCostShareFromAward() {
        this.awardCommitmentsAction.addCostShareToAward(this.award, this.awardCostShare);
        this.awardCommitmentsAction.deleteCostShareFromAward(this.award, 0);
        Assert.assertEquals((long)0L, (long)this.award.getAwardCostShares().size());
    }
}

