/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.bo;

import gov.grants.apply.forms.phs398CareerDevelopmentAwardSup11V11.CitizenshipDataType;
import java.util.HashMap;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.bo.CitizenshipType;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.service.CitizenshipTypeService;
import org.kuali.kra.test.infrastructure.KcUnitTestBase;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.service.BusinessObjectService;

public class CitizenshipTypeTest
extends KcUnitTestBase {
    private BusinessObjectService businessObjectService;
    private int TEST_CODE = -1;
    private String TEST_DESCRIPTION = "test citizenship";
    private CitizenshipTypeService citizenshipService;

    @Override
    @Before
    public void setUp() throws Exception {
        this.businessObjectService = (BusinessObjectService)KraServiceLocator.getService(BusinessObjectService.class);
        this.citizenshipService = (CitizenshipTypeService)KraServiceLocator.getService(CitizenshipTypeService.class);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.businessObjectService = null;
        this.citizenshipService = null;
    }

    @Test
    public void makeNewCitizenshipType() throws Exception {
        CitizenshipType ct = new CitizenshipType();
        ct.setCitizenshipTypeCode(this.TEST_CODE);
        ct.setDescription(this.TEST_DESCRIPTION);
        ct.setActive(true);
        CitizenshipTypeTest.assertNull((Object)ct.getObjectId());
        this.businessObjectService.save((PersistableBusinessObject)ct);
        CitizenshipTypeTest.assertNotNull((Object)ct.getObjectId());
    }

    @Test
    public void findAndUpdateTestCitizenshipType() throws Exception {
        HashMap<String, String> arguments = new HashMap<String, String>();
        arguments.put("CITIZENSHIP_TYPE_CODE", "1");
        CitizenshipType ct = (CitizenshipType)this.businessObjectService.findByPrimaryKey(CitizenshipType.class, arguments);
        CitizenshipTypeTest.assertEquals((Object)"US CITIZEN OR NONCITIZEN NATIONAL", (Object)ct.getDescription());
        CitizenshipTypeTest.assertEquals((Object)new Long(1L), (Object)ct.getVersionNumber());
        String testDescr = "something cool";
        ct.setDescription(testDescr);
        this.businessObjectService.save((PersistableBusinessObject)ct);
        CitizenshipType ct2 = (CitizenshipType)this.businessObjectService.findByPrimaryKey(CitizenshipType.class, arguments);
        CitizenshipTypeTest.assertEquals((Object)testDescr, (Object)ct2.getDescription());
    }

    @Test
    public void testGetEnumValueOfCitizenshipType1() throws Exception {
        HashMap<String, String> arguments = new HashMap<String, String>();
        arguments.put("CITIZENSHIP_TYPE_CODE", "1");
        CitizenshipType ct = (CitizenshipType)this.businessObjectService.findByPrimaryKey(CitizenshipType.class, arguments);
        CitizenshipDataType.Enum result = this.citizenshipService.getEnumValueOfCitizenshipType(ct);
        CitizenshipTypeTest.assertEquals((long)1L, (long)result.intValue());
    }

    @Test
    public void testGetEnumValueOfCitizenshipType2() throws Exception {
        HashMap<String, String> arguments = new HashMap<String, String>();
        arguments.put("CITIZENSHIP_TYPE_CODE", "2");
        CitizenshipType ct = (CitizenshipType)this.businessObjectService.findByPrimaryKey(CitizenshipType.class, arguments);
        CitizenshipDataType.Enum result = this.citizenshipService.getEnumValueOfCitizenshipType(ct);
        CitizenshipTypeTest.assertEquals((long)2L, (long)result.intValue());
    }

    @Test
    public void testGetEnumValueOfCitizenshipType3() throws Exception {
        HashMap<String, String> arguments = new HashMap<String, String>();
        arguments.put("CITIZENSHIP_TYPE_CODE", "3");
        CitizenshipType ct = (CitizenshipType)this.businessObjectService.findByPrimaryKey(CitizenshipType.class, arguments);
        CitizenshipDataType.Enum result = this.citizenshipService.getEnumValueOfCitizenshipType(ct);
        CitizenshipTypeTest.assertEquals((long)3L, (long)result.intValue());
    }

    @Test
    public void testGetEnumValueOfCitizenshipType4() throws Exception {
        CitizenshipType testType = new CitizenshipType();
        testType.setCitizenshipTypeCode(-101);
        testType.setDescription("super awesome cool description");
        try {
            CitizenshipDataType.Enum result = this.citizenshipService.getEnumValueOfCitizenshipType(testType);
        }
        catch (IllegalArgumentException iae) {
            CitizenshipTypeTest.assertEquals((Object)"Invalid citizenship type provided", (Object)iae.getMessage());
            return;
        }
        CitizenshipTypeTest.assertTrue((boolean)false);
    }
}

