/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.bo;

import org.apache.commons.lang.StringUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.bo.Sponsor;
import org.kuali.kra.bo.SponsorMaintainableImpl;
import org.kuali.kra.test.infrastructure.KcUnitTestBase;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.coreservice.impl.parameter.ParameterServiceImpl;
import org.kuali.rice.krad.bo.PersistableBusinessObject;

public class SponsorMaintainableImplTest
extends KcUnitTestBase {
    public static final String SPONSOR_DOC_TYPE_NAME = "SponsorMaintenanceDocument";
    protected SponsorMaintainableImpl sponsorMaintainableImpl;
    protected ParameterServiceMock parameterService;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.parameterService = new ParameterServiceMock();
        this.sponsorMaintainableImpl = new SponsorMaintainableImpl();
        this.sponsorMaintainableImpl.setBoClass(Sponsor.class);
        this.sponsorMaintainableImpl.setBusinessObject((PersistableBusinessObject)new Sponsor());
        this.sponsorMaintainableImpl.setParameterService((ParameterService)this.parameterService);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
    }

    @Test
    public void testGenerateDefaultValues() {
        this.parameterService.autoGenSponsorCode = true;
        this.sponsorMaintainableImpl.setGenerateDefaultValues(SPONSOR_DOC_TYPE_NAME);
        Sponsor sponsor = (Sponsor)this.sponsorMaintainableImpl.getBusinessObject();
        SponsorMaintainableImplTest.assertTrue((boolean)StringUtils.isNotBlank((String)sponsor.getSponsorCode()));
    }

    @Test
    public void testDefaultValues() {
        this.parameterService.autoGenSponsorCode = false;
        this.sponsorMaintainableImpl.setGenerateDefaultValues(SPONSOR_DOC_TYPE_NAME);
        Sponsor sponsor = (Sponsor)this.sponsorMaintainableImpl.getBusinessObject();
        SponsorMaintainableImplTest.assertTrue((boolean)StringUtils.isBlank((String)sponsor.getSponsorCode()));
    }

    class ParameterServiceMock
    extends ParameterServiceImpl {
        public boolean autoGenSponsorCode = true;

        ParameterServiceMock() {
        }

        public Boolean getParameterValueAsBoolean(String namespace, String detailCode, String parmValue) {
            Assert.assertEquals((Object)"KC-GEN", (Object)namespace);
            Assert.assertEquals((Object)"All", (Object)detailCode);
            Assert.assertEquals((Object)"AUTO_GENERATE_SPONSOR_CODE", (Object)parmValue);
            return this.autoGenSponsorCode;
        }
    }
}

