/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.bo.web;

import java.util.Collection;
import java.util.LinkedHashMap;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.bo.CustomAttribute;
import org.kuali.kra.bo.KcPerson;
import org.kuali.kra.bo.web.MaintenanceDocumentSeleniumHelper;
import org.kuali.kra.test.infrastructure.KcSeleniumTestBase;
import org.kuali.rice.kns.document.MaintenanceDocumentBase;

public class CustomAttributeMaintenanceDocumentSeleniumTest
extends KcSeleniumTestBase {
    private static final String DOCUMENT_TITLE = "Custom Attribute";
    private static final String MAINTENANCE_DOCUMENT_TITLE = "Kuali :: CustomAttribute Maintenance Document";
    private static final String CUSTOM_ATTRIBUTE_ID_ID = "id";
    private static final String DATA_LENGTH_ID = "dataLength";
    private static final String DATA_TYPE_CODE_ID = "dataTypeCode";
    private static final String GROUP_NAME_ID = "groupName";
    private static final String LABEL_ID = "label";
    private static final String LOOKUP_CLASS_ID = "lookupClass";
    private static final String LOOKUP_RETURN_ID = "lookupReturn";
    private static final String NAME_ID = "name";
    private static final String CREATE_DOCUMENT_DESCRIPTION = "Custom Attribute - Test Create";
    private static final int CREATE_DATA_LENGTH = 30;
    private static final String EDIT_DOCUMENT_DESCRIPTION = "Custom Attribute - Test Edit";
    private static final int EDIT_DATA_LENGTH_1 = 30;
    private static final int EDIT_DATA_LENGTH_2 = 35;
    private static final String COPY_DOCUMENT_DESCRIPTION = "Custom Attribute - Test Copy";
    private static final int COPY_DATA_LENGTH_1 = 30;
    private static final int COPY_DATA_LENGTH_2 = 35;
    private static final String DEFAULT_DATA_TYPE_CODE = "1";
    private static final String DEFAULT_DATA_TYPE_CODE_NAME = "String";
    private static final String DEFAULT_GROUP_NAME = "Test Group";
    private static final String DEFAULT_LABEL = "Test 99";
    private static final Class<KcPerson> DEFAULT_LOOKUP_CLASS = KcPerson.class;
    private static final String DEFAULT_LOOKUP_RETURN = "userName";
    private static final String DEFAULT_LOOKUP_RETURN_NAME = "User Name";
    private static final String DEFAULT_NAME = "test99";
    private MaintenanceDocumentSeleniumHelper helper;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.helper = MaintenanceDocumentSeleniumHelper.instance(driver);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.helper = null;
        super.tearDown();
    }

    @Test
    public void testCreateCustomAttribute() throws Exception {
        int customAttributeId = this.getNewCustomAttributeId();
        String documentNumber = this.createNewMaintenanceDocument(CREATE_DOCUMENT_DESCRIPTION, customAttributeId, 30);
        this.verifyExistingMaintenanceDocument(documentNumber, customAttributeId, 30);
    }

    @Test
    public void testEditCustomAttribute() throws Exception {
        int customAttributeId = this.getNewCustomAttributeId();
        this.createNewMaintenanceDocument(EDIT_DOCUMENT_DESCRIPTION, customAttributeId, 30);
        LinkedHashMap<String, String> searchValues = new LinkedHashMap<String, String>();
        searchValues.put(CUSTOM_ATTRIBUTE_ID_ID, String.valueOf(customAttributeId));
        String documentNumber = this.helper.editMaintenanceDocument(DOCUMENT_TITLE, CustomAttribute.class.getName(), searchValues, MAINTENANCE_DOCUMENT_TITLE);
        LinkedHashMap<String, String> fieldValues = new LinkedHashMap<String, String>();
        fieldValues.put(DATA_LENGTH_ID, String.valueOf(35));
        this.helper.populateMaintenanceDocument(EDIT_DOCUMENT_DESCRIPTION, fieldValues);
        this.helper.routeDocument();
        this.helper.assertRoute();
        this.verifyExistingMaintenanceDocument(documentNumber, customAttributeId, 35);
    }

    @Test
    public void testCopyCustomAttribute() throws Exception {
        int customAttributeId1 = this.getNewCustomAttributeId();
        this.createNewMaintenanceDocument(COPY_DOCUMENT_DESCRIPTION, customAttributeId1, 30);
        LinkedHashMap<String, String> searchValues = new LinkedHashMap<String, String>();
        searchValues.put(CUSTOM_ATTRIBUTE_ID_ID, String.valueOf(customAttributeId1));
        String documentNumber = this.helper.copyMaintenanceDocument(DOCUMENT_TITLE, CustomAttribute.class.getName(), searchValues, MAINTENANCE_DOCUMENT_TITLE);
        int customAttributeId2 = this.getNewCustomAttributeId();
        LinkedHashMap<String, String> fieldValues = new LinkedHashMap<String, String>();
        fieldValues.put(CUSTOM_ATTRIBUTE_ID_ID, String.valueOf(customAttributeId2));
        fieldValues.put(DATA_LENGTH_ID, String.valueOf(35));
        fieldValues.put(DATA_TYPE_CODE_ID, DEFAULT_DATA_TYPE_CODE_NAME);
        fieldValues.put(GROUP_NAME_ID, DEFAULT_GROUP_NAME);
        fieldValues.put(LABEL_ID, DEFAULT_LABEL);
        fieldValues.put(LOOKUP_CLASS_ID, DEFAULT_LOOKUP_CLASS.getSimpleName());
        fieldValues.put(LOOKUP_RETURN_ID, DEFAULT_LOOKUP_RETURN_NAME);
        fieldValues.put(NAME_ID, DEFAULT_NAME);
        this.helper.populateMaintenanceDocument(COPY_DOCUMENT_DESCRIPTION, fieldValues);
        this.helper.routeDocument();
        this.helper.assertRoute();
        this.verifyExistingMaintenanceDocument(documentNumber, customAttributeId2, 35);
    }

    private String createNewMaintenanceDocument(String documentDescription, int customAttributeId, Integer dataLength) {
        String documentNumber = this.helper.createMaintenanceDocument(DOCUMENT_TITLE, CustomAttribute.class.getName(), MAINTENANCE_DOCUMENT_TITLE);
        LinkedHashMap<String, String> fieldValues = new LinkedHashMap<String, String>();
        fieldValues.put(CUSTOM_ATTRIBUTE_ID_ID, String.valueOf(customAttributeId));
        fieldValues.put(DATA_LENGTH_ID, String.valueOf(dataLength));
        fieldValues.put(DATA_TYPE_CODE_ID, DEFAULT_DATA_TYPE_CODE_NAME);
        fieldValues.put(GROUP_NAME_ID, DEFAULT_GROUP_NAME);
        fieldValues.put(LABEL_ID, DEFAULT_LABEL);
        fieldValues.put(LOOKUP_CLASS_ID, DEFAULT_LOOKUP_CLASS.getSimpleName());
        fieldValues.put(LOOKUP_RETURN_ID, DEFAULT_LOOKUP_RETURN_NAME);
        fieldValues.put(NAME_ID, DEFAULT_NAME);
        this.helper.populateMaintenanceDocument(documentDescription, fieldValues);
        this.helper.routeDocument();
        this.helper.assertRoute();
        return documentNumber;
    }

    private void verifyExistingMaintenanceDocument(String documentNumber, int customAttributeId, Integer dataLength) throws Exception {
        MaintenanceDocumentBase document = (MaintenanceDocumentBase)this.getDocumentService().getByDocumentHeaderId(documentNumber);
        CustomAttributeMaintenanceDocumentSeleniumTest.assertNotNull((Object)document.getDocumentNumber());
        CustomAttributeMaintenanceDocumentSeleniumTest.assertNotNull((Object)document.getDocumentHeader());
        CustomAttributeMaintenanceDocumentSeleniumTest.assertEquals((Object)documentNumber, (Object)document.getDocumentHeader().getDocumentNumber());
        CustomAttribute customAttribute = (CustomAttribute)document.getNewMaintainableObject().getDataObject();
        CustomAttributeMaintenanceDocumentSeleniumTest.assertEquals((Object)customAttributeId, (Object)customAttribute.getId());
        CustomAttributeMaintenanceDocumentSeleniumTest.assertEquals((Object)dataLength, (Object)customAttribute.getDataLength());
        CustomAttributeMaintenanceDocumentSeleniumTest.assertEquals((Object)DEFAULT_DATA_TYPE_CODE, (Object)customAttribute.getDataTypeCode());
        CustomAttributeMaintenanceDocumentSeleniumTest.assertEquals((Object)DEFAULT_GROUP_NAME, (Object)customAttribute.getGroupName());
        CustomAttributeMaintenanceDocumentSeleniumTest.assertEquals((Object)DEFAULT_LABEL, (Object)customAttribute.getLabel());
        CustomAttributeMaintenanceDocumentSeleniumTest.assertEquals((Object)DEFAULT_LOOKUP_CLASS.getName(), (Object)customAttribute.getLookupClass());
        CustomAttributeMaintenanceDocumentSeleniumTest.assertEquals((Object)DEFAULT_LOOKUP_RETURN, (Object)customAttribute.getLookupReturn());
        CustomAttributeMaintenanceDocumentSeleniumTest.assertEquals((Object)DEFAULT_NAME, (Object)customAttribute.getName());
    }

    private int getNewCustomAttributeId() {
        int maxCustomAttributeId = 1;
        Collection customAttributes = this.getBusinessObjectService().findAll(CustomAttribute.class);
        for (CustomAttribute customAttribute : customAttributes) {
            if (customAttribute.getId() <= maxCustomAttributeId) continue;
            maxCustomAttributeId = customAttribute.getId();
        }
        return maxCustomAttributeId + 1;
    }
}

