/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.bo.web;

import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.LinkedHashMap;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.lang.time.DateUtils;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.bo.InstituteLaRate;
import org.kuali.kra.bo.web.MaintenanceDocumentSeleniumHelper;
import org.kuali.kra.test.infrastructure.KcSeleniumTestBase;
import org.kuali.rice.kns.document.MaintenanceDocumentBase;

public class InstituteLaRateMaintenanceDocumentSeleniumTest
extends KcSeleniumTestBase {
    private static final String DOCUMENT_TITLE = "Institute La Rate";
    private static final String MAINTENANCE_DOCUMENT_TITLE = "Kuali :: Institute La Rates Maintenance Document";
    private static final String FISCAL_YEAR_ID = "fiscalYear";
    private static final String ON_OFF_CAMPUS_FLAG_ID = "onOffCampusFlag";
    private static final String RATE_CLASS_CODE_ID = "rateClassCode";
    private static final String RATE_TYPE_CODE_ID = "rateTypeCode";
    private static final String START_DATE_ID = "startDate";
    private static final String UNIT_NUMBER_ID = "unitNumber";
    private static final String RATE_ID = "instituteRate";
    private static final String ACTIVE_ID = "active";
    private static final String CREATE_DOCUMENT_DESCRIPTION = "Institute La Rate - Test Create";
    private static final String CREATE_RATE = "1.11";
    private static final String EDIT_DOCUMENT_DESCRIPTION = "Institute La Rate - Test Edit";
    private static final String EDIT_RATE_1 = "1.11";
    private static final String EDIT_RATE_2 = "2.22";
    private static final String COPY_DOCUMENT_DESCRIPTION = "Institute La Rate - Test Copy";
    private static final String COPY_RATE = "2.22";
    private static final String DEFAULT_RATE_CLASS_CODE = "12";
    private static final String DEFAULT_RATE_TYPE_CODE = "1";
    private static final boolean DEFAULT_ON_OFF_CAMPUS_FLAG = true;
    private static final String DEFAULT_UNIT_NUMBER = "000001";
    private static final boolean DEFAULT_ACTIVE = true;
    private static final SimpleDateFormat formatter = new SimpleDateFormat("MM/dd/yyyy");
    private MaintenanceDocumentSeleniumHelper helper;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.helper = MaintenanceDocumentSeleniumHelper.instance(driver);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.helper = null;
        super.tearDown();
    }

    @Test
    public void testCreateInstituteLaRate() throws Exception {
        String fiscalYear = this.getNewFiscalYear();
        String startDate = formatter.format(DateUtils.parseDate((String)fiscalYear, (String[])new String[]{"yyyy"}));
        String documentNumber = this.createNewMaintenanceDocument(CREATE_DOCUMENT_DESCRIPTION, fiscalYear, startDate, "1.11");
        this.verifyExistingMaintenanceDocument(documentNumber, fiscalYear, startDate, "1.11");
    }

    @Test
    public void testEditInstituteLaRate() throws Exception {
        String fiscalYear = this.getNewFiscalYear();
        String startDate = formatter.format(DateUtils.parseDate((String)fiscalYear, (String[])new String[]{"yyyy"}));
        this.createNewMaintenanceDocument(EDIT_DOCUMENT_DESCRIPTION, fiscalYear, startDate, "1.11");
        LinkedHashMap<String, String> searchValues = new LinkedHashMap<String, String>();
        searchValues.put(FISCAL_YEAR_ID, fiscalYear);
        searchValues.put(START_DATE_ID, startDate);
        String documentNumber = this.helper.editMaintenanceDocument(DOCUMENT_TITLE, InstituteLaRate.class.getName(), searchValues, MAINTENANCE_DOCUMENT_TITLE);
        LinkedHashMap<String, String> fieldValues = new LinkedHashMap<String, String>();
        fieldValues.put(RATE_ID, "2.22");
        this.helper.populateMaintenanceDocument(EDIT_DOCUMENT_DESCRIPTION, fieldValues);
        this.helper.routeDocument();
        this.helper.assertRoute();
        this.verifyExistingMaintenanceDocument(documentNumber, fiscalYear, startDate, "2.22");
    }

    @Test
    public void testCopyInstituteLaRate() throws Exception {
        String fiscalYear1 = this.getNewFiscalYear();
        String startDate1 = formatter.format(DateUtils.parseDate((String)fiscalYear1, (String[])new String[]{"yyyy"}));
        this.createNewMaintenanceDocument(COPY_DOCUMENT_DESCRIPTION, fiscalYear1, startDate1, "2.22");
        LinkedHashMap<String, String> searchValues = new LinkedHashMap<String, String>();
        searchValues.put(FISCAL_YEAR_ID, fiscalYear1);
        searchValues.put(START_DATE_ID, startDate1);
        String documentNumber = this.helper.copyMaintenanceDocument(DOCUMENT_TITLE, InstituteLaRate.class.getName(), searchValues, MAINTENANCE_DOCUMENT_TITLE);
        String fiscalYear2 = this.getNewFiscalYear();
        String startDate2 = formatter.format(DateUtils.parseDate((String)fiscalYear1, (String[])new String[]{"yyyy"}));
        LinkedHashMap<String, String> fieldValues = new LinkedHashMap<String, String>();
        fieldValues.put(FISCAL_YEAR_ID, fiscalYear2);
        fieldValues.put(ON_OFF_CAMPUS_FLAG_ID, String.valueOf(true));
        fieldValues.put(RATE_CLASS_CODE_ID, DEFAULT_RATE_CLASS_CODE);
        fieldValues.put(RATE_TYPE_CODE_ID, DEFAULT_RATE_TYPE_CODE);
        fieldValues.put(START_DATE_ID, startDate2);
        fieldValues.put(UNIT_NUMBER_ID, DEFAULT_UNIT_NUMBER);
        fieldValues.put(RATE_ID, "2.22");
        fieldValues.put(ACTIVE_ID, String.valueOf(true));
        this.helper.populateMaintenanceDocument(COPY_DOCUMENT_DESCRIPTION, fieldValues);
        this.helper.routeDocument();
        this.helper.assertRoute();
        this.verifyExistingMaintenanceDocument(documentNumber, fiscalYear2, startDate2, "2.22");
    }

    private String createNewMaintenanceDocument(String documentDescription, String fiscalYear, String startDate, String rate) {
        String documentNumber = this.helper.createMaintenanceDocument(DOCUMENT_TITLE, InstituteLaRate.class.getName(), MAINTENANCE_DOCUMENT_TITLE);
        LinkedHashMap<String, String> fieldValues = new LinkedHashMap<String, String>();
        fieldValues.put(FISCAL_YEAR_ID, fiscalYear);
        fieldValues.put(ON_OFF_CAMPUS_FLAG_ID, String.valueOf(true));
        fieldValues.put(RATE_CLASS_CODE_ID, DEFAULT_RATE_CLASS_CODE);
        fieldValues.put(RATE_TYPE_CODE_ID, DEFAULT_RATE_TYPE_CODE);
        fieldValues.put(START_DATE_ID, startDate);
        fieldValues.put(UNIT_NUMBER_ID, DEFAULT_UNIT_NUMBER);
        fieldValues.put(RATE_ID, rate);
        fieldValues.put(ACTIVE_ID, String.valueOf(true));
        this.helper.populateMaintenanceDocument(documentDescription, fieldValues);
        this.helper.routeDocument();
        this.helper.assertRoute();
        return documentNumber;
    }

    private void verifyExistingMaintenanceDocument(String documentNumber, String fiscalYear, String startDate, String rate) throws Exception {
        MaintenanceDocumentBase document = (MaintenanceDocumentBase)this.getDocumentService().getByDocumentHeaderId(documentNumber);
        InstituteLaRateMaintenanceDocumentSeleniumTest.assertNotNull((Object)document.getDocumentNumber());
        InstituteLaRateMaintenanceDocumentSeleniumTest.assertNotNull((Object)document.getDocumentHeader());
        InstituteLaRateMaintenanceDocumentSeleniumTest.assertEquals((Object)documentNumber, (Object)document.getDocumentHeader().getDocumentNumber());
        InstituteLaRate instituteLaRate = (InstituteLaRate)document.getNewMaintainableObject().getDataObject();
        InstituteLaRateMaintenanceDocumentSeleniumTest.assertEquals((Object)fiscalYear, (Object)instituteLaRate.getFiscalYear());
        InstituteLaRateMaintenanceDocumentSeleniumTest.assertEquals((Object)true, (Object)instituteLaRate.getOnOffCampusFlag());
        InstituteLaRateMaintenanceDocumentSeleniumTest.assertEquals((Object)DEFAULT_RATE_CLASS_CODE, (Object)instituteLaRate.getRateClassCode());
        InstituteLaRateMaintenanceDocumentSeleniumTest.assertEquals((Object)DEFAULT_RATE_TYPE_CODE, (Object)instituteLaRate.getRateTypeCode());
        InstituteLaRateMaintenanceDocumentSeleniumTest.assertEquals((Object)startDate, (Object)formatter.format(instituteLaRate.getStartDate()));
        InstituteLaRateMaintenanceDocumentSeleniumTest.assertEquals((Object)DEFAULT_UNIT_NUMBER, (Object)instituteLaRate.getUnitNumber());
        InstituteLaRateMaintenanceDocumentSeleniumTest.assertEquals((Object)rate, (Object)instituteLaRate.getInstituteRate().toString());
        InstituteLaRateMaintenanceDocumentSeleniumTest.assertEquals((Object)true, (Object)instituteLaRate.isActive());
    }

    private String getNewFiscalYear() {
        int maxFiscalYear = 1;
        Collection instituteLaRates = this.getBusinessObjectService().findAll(InstituteLaRate.class);
        for (InstituteLaRate instituteLaRate : instituteLaRates) {
            int fiscalYear = NumberUtils.toInt((String)instituteLaRate.getFiscalYear(), (int)1970);
            if (fiscalYear <= maxFiscalYear) continue;
            maxFiscalYear = fiscalYear;
        }
        return String.valueOf(maxFiscalYear + 1);
    }
}

