/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.bo.web;

import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.LinkedHashMap;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.lang.time.DateUtils;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.bo.InstituteRate;
import org.kuali.kra.bo.web.MaintenanceDocumentSeleniumHelper;
import org.kuali.kra.test.infrastructure.KcSeleniumTestBase;
import org.kuali.rice.kns.document.MaintenanceDocumentBase;

public class InstituteRateMaintenanceDocumentSeleniumTest
extends KcSeleniumTestBase {
    private static final String DOCUMENT_TITLE = "Institute Rate";
    private static final String MAINTENANCE_DOCUMENT_TITLE = "Kuali :: Institute Rates Maintenance Document";
    private static final String ACTIVITY_TYPE_CODE_ID = "activityTypeCode";
    private static final String FISCAL_YEAR_ID = "fiscalYear";
    private static final String ON_OFF_CAMPUS_FLAG_ID = "onOffCampusFlag";
    private static final String RATE_CLASS_CODE_ID = "rateClassCode";
    private static final String RATE_TYPE_CODE_ID = "rateTypeCode";
    private static final String START_DATE_ID = "startDate";
    private static final String UNIT_NUMBER_ID = "unitNumber";
    private static final String RATE_ID = "instituteRate";
    private static final String ACTIVE_ID = "active";
    private static final String CREATE_DOCUMENT_DESCRIPTION = "Institute Rate - Test Create";
    private static final String CREATE_RATE = "1.11";
    private static final String EDIT_DOCUMENT_DESCRIPTION = "Institute Rate - Test Edit";
    private static final String EDIT_RATE_1 = "1.11";
    private static final String EDIT_RATE_2 = "2.22";
    private static final String COPY_DOCUMENT_DESCRIPTION = "Institute Rate - Test Copy";
    private static final String COPY_RATE = "2.22";
    private static final String DEFAULT_ACTIVITY_TYPE_CODE = "1";
    private static final String DEFAULT_RATE_CLASS_CODE = "5";
    private static final String DEFAULT_RATE_TYPE_CODE = "2";
    private static final boolean DEFAULT_ON_OFF_CAMPUS_FLAG = true;
    private static final String DEFAULT_UNIT_NUMBER = "000001";
    private static final boolean DEFAULT_ACTIVE = true;
    private static final SimpleDateFormat formatter = new SimpleDateFormat("MM/dd/yyyy");
    private MaintenanceDocumentSeleniumHelper helper;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.helper = MaintenanceDocumentSeleniumHelper.instance(driver);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.helper = null;
        super.tearDown();
    }

    @Test
    public void testCreateInstituteRate() throws Exception {
        String fiscalYear = this.getNewFiscalYear();
        String startDate = formatter.format(DateUtils.parseDate((String)fiscalYear, (String[])new String[]{"yyyy"}));
        String documentNumber = this.createNewMaintenanceDocument(CREATE_DOCUMENT_DESCRIPTION, fiscalYear, startDate, "1.11");
        this.verifyExistingMaintenanceDocument(documentNumber, fiscalYear, startDate, "1.11");
    }

    @Test
    public void testEditInstituteRate() throws Exception {
        String fiscalYear = this.getNewFiscalYear();
        String startDate = formatter.format(DateUtils.parseDate((String)fiscalYear, (String[])new String[]{"yyyy"}));
        this.createNewMaintenanceDocument(EDIT_DOCUMENT_DESCRIPTION, fiscalYear, startDate, "1.11");
        LinkedHashMap<String, String> searchValues = new LinkedHashMap<String, String>();
        searchValues.put(FISCAL_YEAR_ID, fiscalYear);
        searchValues.put(START_DATE_ID, startDate);
        String documentNumber = this.helper.editMaintenanceDocument(DOCUMENT_TITLE, InstituteRate.class.getName(), searchValues, MAINTENANCE_DOCUMENT_TITLE);
        LinkedHashMap<String, String> fieldValues = new LinkedHashMap<String, String>();
        fieldValues.put(RATE_ID, "2.22");
        this.helper.populateMaintenanceDocument(EDIT_DOCUMENT_DESCRIPTION, fieldValues);
        this.helper.routeDocument();
        this.helper.assertRoute();
        this.verifyExistingMaintenanceDocument(documentNumber, fiscalYear, startDate, "2.22");
    }

    @Test
    public void testCopyInstituteRate() throws Exception {
        String fiscalYear1 = this.getNewFiscalYear();
        String startDate1 = formatter.format(DateUtils.parseDate((String)fiscalYear1, (String[])new String[]{"yyyy"}));
        this.createNewMaintenanceDocument(COPY_DOCUMENT_DESCRIPTION, fiscalYear1, startDate1, "2.22");
        LinkedHashMap<String, String> searchValues = new LinkedHashMap<String, String>();
        searchValues.put(FISCAL_YEAR_ID, fiscalYear1);
        searchValues.put(START_DATE_ID, startDate1);
        String documentNumber = this.helper.copyMaintenanceDocument(DOCUMENT_TITLE, InstituteRate.class.getName(), searchValues, MAINTENANCE_DOCUMENT_TITLE);
        String fiscalYear2 = this.getNewFiscalYear();
        String startDate2 = formatter.format(DateUtils.parseDate((String)fiscalYear1, (String[])new String[]{"yyyy"}));
        LinkedHashMap<String, String> fieldValues = new LinkedHashMap<String, String>();
        fieldValues.put(ACTIVITY_TYPE_CODE_ID, DEFAULT_ACTIVITY_TYPE_CODE);
        fieldValues.put(FISCAL_YEAR_ID, fiscalYear2);
        fieldValues.put(ON_OFF_CAMPUS_FLAG_ID, String.valueOf(true));
        fieldValues.put(RATE_CLASS_CODE_ID, DEFAULT_RATE_CLASS_CODE);
        fieldValues.put(RATE_TYPE_CODE_ID, DEFAULT_RATE_TYPE_CODE);
        fieldValues.put(START_DATE_ID, startDate2);
        fieldValues.put(UNIT_NUMBER_ID, DEFAULT_UNIT_NUMBER);
        fieldValues.put(RATE_ID, "2.22");
        fieldValues.put(ACTIVE_ID, String.valueOf(true));
        this.helper.populateMaintenanceDocument(COPY_DOCUMENT_DESCRIPTION, fieldValues);
        this.helper.routeDocument();
        this.helper.assertRoute();
        this.verifyExistingMaintenanceDocument(documentNumber, fiscalYear2, startDate2, "2.22");
    }

    private String createNewMaintenanceDocument(String documentDescription, String fiscalYear, String startDate, String rate) {
        String documentNumber = this.helper.createMaintenanceDocument(DOCUMENT_TITLE, InstituteRate.class.getName(), MAINTENANCE_DOCUMENT_TITLE);
        LinkedHashMap<String, String> fieldValues = new LinkedHashMap<String, String>();
        fieldValues.put(ACTIVITY_TYPE_CODE_ID, DEFAULT_ACTIVITY_TYPE_CODE);
        fieldValues.put(FISCAL_YEAR_ID, fiscalYear);
        fieldValues.put(ON_OFF_CAMPUS_FLAG_ID, String.valueOf(true));
        fieldValues.put(RATE_CLASS_CODE_ID, DEFAULT_RATE_CLASS_CODE);
        fieldValues.put(RATE_TYPE_CODE_ID, DEFAULT_RATE_TYPE_CODE);
        fieldValues.put(START_DATE_ID, startDate);
        fieldValues.put(UNIT_NUMBER_ID, DEFAULT_UNIT_NUMBER);
        fieldValues.put(RATE_ID, rate);
        fieldValues.put(ACTIVE_ID, String.valueOf(true));
        this.helper.populateMaintenanceDocument(documentDescription, fieldValues);
        this.helper.routeDocument();
        this.helper.assertRoute();
        return documentNumber;
    }

    private void verifyExistingMaintenanceDocument(String documentNumber, String fiscalYear, String startDate, String rate) throws Exception {
        MaintenanceDocumentBase document = (MaintenanceDocumentBase)this.getDocumentService().getByDocumentHeaderId(documentNumber);
        InstituteRateMaintenanceDocumentSeleniumTest.assertNotNull((Object)document.getDocumentNumber());
        InstituteRateMaintenanceDocumentSeleniumTest.assertNotNull((Object)document.getDocumentHeader());
        InstituteRateMaintenanceDocumentSeleniumTest.assertEquals((Object)documentNumber, (Object)document.getDocumentHeader().getDocumentNumber());
        InstituteRate instituteRate = (InstituteRate)document.getNewMaintainableObject().getDataObject();
        InstituteRateMaintenanceDocumentSeleniumTest.assertEquals((Object)DEFAULT_ACTIVITY_TYPE_CODE, (Object)instituteRate.getActivityTypeCode());
        InstituteRateMaintenanceDocumentSeleniumTest.assertEquals((Object)fiscalYear, (Object)instituteRate.getFiscalYear());
        InstituteRateMaintenanceDocumentSeleniumTest.assertEquals((Object)true, (Object)instituteRate.getOnOffCampusFlag());
        InstituteRateMaintenanceDocumentSeleniumTest.assertEquals((Object)DEFAULT_RATE_CLASS_CODE, (Object)instituteRate.getRateClassCode());
        InstituteRateMaintenanceDocumentSeleniumTest.assertEquals((Object)DEFAULT_RATE_TYPE_CODE, (Object)instituteRate.getRateTypeCode());
        InstituteRateMaintenanceDocumentSeleniumTest.assertEquals((Object)startDate, (Object)formatter.format(instituteRate.getStartDate()));
        InstituteRateMaintenanceDocumentSeleniumTest.assertEquals((Object)DEFAULT_UNIT_NUMBER, (Object)instituteRate.getUnitNumber());
        InstituteRateMaintenanceDocumentSeleniumTest.assertEquals((Object)rate, (Object)instituteRate.getInstituteRate().toString());
        InstituteRateMaintenanceDocumentSeleniumTest.assertEquals((Object)true, (Object)instituteRate.isActive());
    }

    private String getNewFiscalYear() {
        int maxFiscalYear = 1;
        Collection instituteRates = this.getBusinessObjectService().findAll(InstituteRate.class);
        for (InstituteRate instituteRate : instituteRates) {
            int fiscalYear = NumberUtils.toInt((String)instituteRate.getFiscalYear(), (int)1970);
            if (fiscalYear <= maxFiscalYear) continue;
            maxFiscalYear = fiscalYear;
        }
        return String.valueOf(maxFiscalYear + 1);
    }
}

