/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.bo.web;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.kuali.kra.test.infrastructure.KcSeleniumHelper;
import org.openqa.selenium.WebDriver;

public class MaintenanceDocumentSeleniumHelper
extends KcSeleniumHelper {
    private static final String DOCUMENT_DESCRIPTION_ID = "document.documentHeader.documentDescription";
    private static final String MAINTAINABLE_PREFIX = "document.newMaintainableObject.";
    private static final String MAINTAINABLE_COLLECTION_PREFIX = "document.newMaintainableObject.add.";
    private static MaintenanceDocumentSeleniumHelper helper;

    public static MaintenanceDocumentSeleniumHelper instance(WebDriver driver) {
        if (helper == null) {
            helper = new MaintenanceDocumentSeleniumHelper(driver);
        }
        return helper;
    }

    private MaintenanceDocumentSeleniumHelper(WebDriver driver) {
        super(driver);
    }

    public void lookupMaintenanceDocument(String documentTitle) {
        this.clickMaintenanceTab();
        this.click(documentTitle);
    }

    public String createMaintenanceDocument(String documentTitle, String className, String nextPageTitle) {
        this.lookupMaintenanceDocument(documentTitle);
        this.createNewMaintenanceDocument(className, nextPageTitle);
        return this.getDocumentNumber();
    }

    public String editMaintenanceDocument(String documentTitle, String className, Map<String, String> searchValues, String nextPageTitle) {
        this.lookupMaintenanceDocument(documentTitle);
        this.editExistingMaintenanceDocument(className, searchValues, nextPageTitle);
        return this.getDocumentNumber();
    }

    public String copyMaintenanceDocument(String documentTitle, String className, Map<String, String> searchValues, String nextPageTitle) {
        this.lookupMaintenanceDocument(documentTitle);
        this.copyExistingMaintenanceDocument(className, searchValues, nextPageTitle);
        return this.getDocumentNumber();
    }

    public void populateMaintenanceDocument(String documentDescription, Map<String, String> fieldValues) {
        this.populateMaintenanceDocument(documentDescription, fieldValues, new ArrayList<Map<String, String>>());
    }

    public void populateMaintenanceDocument(String documentDescription, Map<String, String> fieldValues, List<Map<String, String>> collectionFieldValuesList) {
        this.set(DOCUMENT_DESCRIPTION_ID, documentDescription);
        for (Map.Entry<String, String> entry : fieldValues.entrySet()) {
            helper.set(MAINTAINABLE_PREFIX + entry.getKey(), entry.getValue());
        }
        for (Map map : collectionFieldValuesList) {
            for (Map.Entry fieldValue : map.entrySet()) {
                helper.set(MAINTAINABLE_COLLECTION_PREFIX + (String)fieldValue.getKey(), (String)fieldValue.getValue());
            }
        }
    }
}

